/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.UnknownHostException;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.ConnectionCategory;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.OutboundConnectionSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectableSnitchHelper
implements IEndpointStateChangeSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(ReconnectableSnitchHelper.class);
    private final IEndpointSnitch snitch;
    private final String localDc;
    private final boolean preferLocal;

    public ReconnectableSnitchHelper(IEndpointSnitch snitch, String localDc, boolean preferLocal) {
        this.snitch = snitch;
        this.localDc = localDc;
        this.preferLocal = preferLocal;
    }

    private void reconnect(InetAddressAndPort publicAddress, VersionedValue localAddressValue) {
        try {
            ReconnectableSnitchHelper.reconnect(publicAddress, InetAddressAndPort.getByName(localAddressValue.value), this.snitch, this.localDc);
        }
        catch (UnknownHostException e) {
            logger.error("Error in getting the IP address resolved: ", (Throwable)e);
        }
    }

    @VisibleForTesting
    static void reconnect(InetAddressAndPort publicAddress, InetAddressAndPort localAddress, IEndpointSnitch snitch, String localDc) {
        if (!new OutboundConnectionSettings(publicAddress, localAddress).withDefaults(ConnectionCategory.MESSAGING).authenticate()) {
            logger.debug("InternodeAuthenticator said don't reconnect to {} on {}", (Object)publicAddress, (Object)localAddress);
            return;
        }
        if (snitch.getDatacenter(publicAddress).equals(localDc)) {
            MessagingService.instance().maybeReconnectWithNewIp(publicAddress, localAddress);
            logger.debug("Initiated reconnect to an Internal IP {} for the {}", (Object)localAddress, (Object)publicAddress);
        }
    }

    @Override
    public void beforeChange(InetAddressAndPort endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    @Override
    public void onJoin(InetAddressAndPort endpoint, EndpointState epState) {
        if (this.preferLocal && !Gossiper.instance.isDeadState(epState)) {
            VersionedValue address = epState.getApplicationState(ApplicationState.INTERNAL_ADDRESS_AND_PORT);
            if (address == null) {
                address = epState.getApplicationState(ApplicationState.INTERNAL_ADDRESS_AND_PORT);
            }
            if (address != null) {
                this.reconnect(endpoint, address);
            }
        }
    }

    @Override
    public void onChange(InetAddressAndPort endpoint, ApplicationState state, VersionedValue value) {
        if (this.preferLocal && !Gossiper.instance.isDeadState(Gossiper.instance.getEndpointStateForEndpoint(endpoint))) {
            if (state == ApplicationState.INTERNAL_ADDRESS_AND_PORT) {
                this.reconnect(endpoint, value);
            } else if (state == ApplicationState.INTERNAL_IP && null == Gossiper.instance.getEndpointStateForEndpoint(endpoint).getApplicationState(ApplicationState.INTERNAL_ADDRESS_AND_PORT)) {
                this.reconnect(endpoint, value);
            }
        }
    }

    @Override
    public void onAlive(InetAddressAndPort endpoint, EndpointState state) {
        VersionedValue internalIP = state.getApplicationState(ApplicationState.INTERNAL_IP);
        VersionedValue internalIPAndPorts = state.getApplicationState(ApplicationState.INTERNAL_ADDRESS_AND_PORT);
        if (this.preferLocal && internalIP != null) {
            this.reconnect(endpoint, internalIPAndPorts != null ? internalIPAndPorts : internalIP);
        }
    }

    @Override
    public void onDead(InetAddressAndPort endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddressAndPort endpoint) {
    }

    @Override
    public void onRestart(InetAddressAndPort endpoint, EndpointState state) {
    }
}

