/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.Map;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import net.nmoncho.shaded.com.google.common.collect.Maps;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.locator.ReplicaMultimap;

public class RangesByEndpoint
extends ReplicaMultimap<InetAddressAndPort, RangesAtEndpoint> {
    public RangesByEndpoint(Map<InetAddressAndPort, RangesAtEndpoint> map) {
        super(map);
    }

    @Override
    public RangesAtEndpoint get(InetAddressAndPort endpoint) {
        Preconditions.checkNotNull(endpoint);
        return this.map.getOrDefault(endpoint, RangesAtEndpoint.empty(endpoint));
    }

    public static class Builder
    extends ReplicaMultimap.Builder<InetAddressAndPort, RangesAtEndpoint.Builder> {
        @Override
        protected RangesAtEndpoint.Builder newBuilder(InetAddressAndPort endpoint) {
            return new RangesAtEndpoint.Builder(endpoint);
        }

        public RangesByEndpoint build() {
            return new RangesByEndpoint((Map<InetAddressAndPort, RangesAtEndpoint>)ImmutableMap.copyOf(Maps.transformValues(this.map, RangesAtEndpoint.Builder::build)));
        }
    }
}

