/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.Map;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import net.nmoncho.shaded.com.google.common.collect.Maps;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.locator.ReplicaMultimap;

public class EndpointsByRange
extends ReplicaMultimap<Range<Token>, EndpointsForRange> {
    public EndpointsByRange(Map<Range<Token>, EndpointsForRange> map) {
        super(map);
    }

    @Override
    public EndpointsForRange get(Range<Token> range) {
        Preconditions.checkNotNull(range);
        return this.map.getOrDefault(range, EndpointsForRange.empty(range));
    }

    public static class Builder
    extends ReplicaMultimap.Builder<Range<Token>, EndpointsForRange.Builder> {
        @Override
        protected EndpointsForRange.Builder newBuilder(Range<Token> range) {
            return new EndpointsForRange.Builder(range);
        }

        public void putAll(Range<Token> range, EndpointsForRange replicas, ReplicaCollection.Builder.Conflict ignoreConflicts) {
            ((EndpointsForRange.Builder)this.get(range)).addAll(replicas, ignoreConflicts);
        }

        public EndpointsByRange build() {
            return new EndpointsByRange((Map<Range<Token>, EndpointsForRange>)ImmutableMap.copyOf(Maps.transformValues(this.map, EndpointsForRange.Builder::build)));
        }
    }
}

