/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import net.nmoncho.shaded.com.google.common.collect.Iterables;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;

public abstract class AbstractEndpointSnitch
implements IEndpointSnitch {
    @Override
    public abstract int compareEndpoints(InetAddressAndPort var1, Replica var2, Replica var3);

    @Override
    public <C extends ReplicaCollection<? extends C>> C sortedByProximity(InetAddressAndPort address, C unsortedAddress) {
        return unsortedAddress.sorted((r1, r2) -> this.compareEndpoints(address, (Replica)r1, (Replica)r2));
    }

    @Override
    public void gossiperStarting() {
    }

    @Override
    public boolean isWorthMergingForRangeQuery(ReplicaCollection<?> merged, ReplicaCollection<?> l1, ReplicaCollection<?> l2) {
        boolean mergedHasRemote = this.hasRemoteNode(merged);
        return mergedHasRemote ? this.hasRemoteNode(l1) || this.hasRemoteNode(l2) : true;
    }

    private boolean hasRemoteNode(ReplicaCollection<?> l) {
        String localDc = DatabaseDescriptor.getLocalDataCenter();
        return Iterables.any(l, replica -> !localDc.equals(this.getDatacenter((Replica)replica)));
    }
}

