/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.nmoncho.shaded.com.google.common.util.concurrent.RateLimiter;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.apache.cassandra.io.util.FileInputStreamPlus;
import org.apache.cassandra.io.util.FileOutputStreamPlus;
import org.apache.cassandra.io.util.FileWriter;
import org.apache.cassandra.io.util.PathUtils;
import org.apache.cassandra.utils.Throwables;

public class File
implements Comparable<File> {
    private static FileSystem filesystem = FileSystems.getDefault();
    @Nullable
    final Path path;

    public static String pathSeparator() {
        return filesystem.getSeparator();
    }

    public File(String parent, String child) {
        this(parent.isEmpty() ? null : filesystem.getPath(parent, new String[0]), child);
    }

    public File(File parent, String child) {
        this(parent.path, child);
    }

    public File(Path parent, String child) {
        if (child.startsWith(File.pathSeparator())) {
            child = child.substring(File.pathSeparator().length());
        }
        this.path = parent == null ? filesystem.getPath(child, new String[0]) : parent.resolve(child);
    }

    public File(String path) {
        this(path.isEmpty() ? null : filesystem.getPath(path, new String[0]));
    }

    public File(java.io.File file) {
        this(file.getPath().isEmpty() ? null : file.toPath());
    }

    public File(java.io.File parent, String child) {
        this(new File(parent), child);
    }

    public File(URI path) {
        this(Paths.get(path));
        if (!path.isAbsolute() || path.isOpaque()) {
            throw new IllegalArgumentException();
        }
    }

    public File(Path path) {
        if (path != null && path.getFileSystem() != filesystem) {
            throw new IllegalArgumentException("Incompatible file system");
        }
        this.path = path;
    }

    public static Path getPath(String first, String ... more) {
        return filesystem.getPath(first, more);
    }

    public boolean tryDelete() {
        return this.path != null && PathUtils.tryDelete(this.path);
    }

    public Throwable delete(Throwable accumulate) {
        return this.delete(accumulate, null);
    }

    public Throwable delete(Throwable accumulate, RateLimiter rateLimiter) {
        return PathUtils.delete(this.toPathForWrite(), accumulate, rateLimiter);
    }

    public void delete() {
        Throwables.maybeFail(this.delete(null, null));
    }

    public void deleteIfExists() {
        if (this.path != null) {
            PathUtils.deleteIfExists(this.path);
        }
    }

    public void delete(RateLimiter rateLimiter) {
        Throwables.maybeFail(this.delete(null, rateLimiter));
    }

    public void deleteRecursive(RateLimiter rateLimiter) {
        PathUtils.deleteRecursive(this.toPathForWrite(), rateLimiter);
    }

    public void deleteRecursive() {
        PathUtils.deleteRecursive(this.toPathForWrite());
    }

    public void deleteOnExit() {
        if (this.path != null) {
            PathUtils.deleteOnExit(this.path);
        }
    }

    public void deleteRecursiveOnExit() {
        if (this.path != null) {
            PathUtils.deleteRecursiveOnExit(this.path);
        }
    }

    public boolean tryMove(File to) {
        return this.path != null && PathUtils.tryRename(this.path, to.path);
    }

    public void move(File to) {
        PathUtils.rename(this.toPathForRead(), to.toPathForWrite());
    }

    public long length() {
        return this.path == null ? 0L : PathUtils.tryGetLength(this.path);
    }

    public long lastModified() {
        return this.path == null ? 0L : PathUtils.tryGetLastModified(this.path);
    }

    public boolean trySetLastModified(long value) {
        return this.path != null && PathUtils.trySetLastModified(this.path, value);
    }

    public boolean trySetReadable(boolean value) {
        return this.path != null && PathUtils.trySetReadable(this.path, value);
    }

    public boolean trySetWritable(boolean value) {
        return this.path != null && PathUtils.trySetWritable(this.path, value);
    }

    public boolean trySetExecutable(boolean value) {
        return this.path != null && PathUtils.trySetExecutable(this.path, value);
    }

    public boolean exists() {
        return this.path != null && PathUtils.exists(this.path);
    }

    public boolean isDirectory() {
        return this.path != null && PathUtils.isDirectory(this.path);
    }

    public boolean isFile() {
        return this.path != null && PathUtils.isFile(this.path);
    }

    public boolean isReadable() {
        return this.path != null && Files.isReadable(this.path);
    }

    public boolean isWritable() {
        return this.path != null && Files.isWritable(this.path);
    }

    public boolean isExecutable() {
        return this.path != null && Files.isExecutable(this.path);
    }

    public boolean createFileIfNotExists() {
        return PathUtils.createFileIfNotExists(this.toPathForWrite());
    }

    public boolean createDirectoriesIfNotExists() {
        return PathUtils.createDirectoriesIfNotExists(this.toPathForWrite());
    }

    public boolean tryCreateDirectory() {
        return this.path != null && PathUtils.tryCreateDirectory(this.path);
    }

    public boolean tryCreateDirectories() {
        return this.path != null && PathUtils.tryCreateDirectories(this.path);
    }

    public File parent() {
        if (this.path == null) {
            return null;
        }
        Path parent = this.path.getParent();
        if (parent == null) {
            return null;
        }
        return new File(parent);
    }

    public String parentPath() {
        File parent = this.parent();
        return parent == null ? null : parent.toString();
    }

    public boolean isAbsolute() {
        return this.path != null && this.path.isAbsolute();
    }

    public boolean isAncestorOf(File child) {
        return PathUtils.isContained(this.toPath(), child.toPath());
    }

    public File toAbsolute() {
        return new File(this.toPath().toAbsolutePath());
    }

    public String absolutePath() {
        return this.toPath().toAbsolutePath().toString();
    }

    public File toCanonical() {
        Path canonical = PathUtils.toCanonicalPath(this.toPath());
        return canonical == this.path ? this : new File(canonical);
    }

    public String canonicalPath() {
        return this.toCanonical().toString();
    }

    public String name() {
        return this.path == null ? "" : PathUtils.filename(this.path);
    }

    public void forEach(Consumer<File> forEach) {
        PathUtils.forEach(this.path, path -> forEach.accept(new File((Path)path)));
    }

    public void forEachRecursive(Consumer<File> forEach) {
        PathUtils.forEachRecursive(this.path, path -> forEach.accept(new File((Path)path)));
    }

    private static <V> ThrowingFunction<IOException, V, RuntimeException> nulls() {
        return ignore -> null;
    }

    private static <V> ThrowingFunction<IOException, V, IOException> rethrow() {
        return fail -> {
            if (fail == null) {
                throw new FileNotFoundException();
            }
            throw fail;
        };
    }

    private static <V> ThrowingFunction<IOException, V, UncheckedIOException> unchecked() {
        return fail -> {
            if (fail == null) {
                fail = new FileNotFoundException();
            }
            throw new UncheckedIOException((IOException)fail);
        };
    }

    public String[] tryListNames() {
        return this.tryListNames(File.nulls());
    }

    public String[] tryListNames(BiPredicate<File, String> filter) {
        return this.tryListNames(filter, File.nulls());
    }

    public File[] tryList() {
        return this.tryList(File.nulls());
    }

    public File[] tryList(Predicate<File> filter) {
        return this.tryList(filter, File.nulls());
    }

    public File[] tryList(BiPredicate<File, String> filter) {
        return this.tryList(filter, File.nulls());
    }

    public String[] listNames() throws IOException {
        return this.tryListNames(File.rethrow());
    }

    public String[] listNames(BiPredicate<File, String> filter) throws IOException {
        return this.tryListNames(filter, File.rethrow());
    }

    public File[] list() throws IOException {
        return this.tryList(File.rethrow());
    }

    public File[] list(Predicate<File> filter) throws IOException {
        return this.tryList(filter, File.rethrow());
    }

    public File[] list(BiPredicate<File, String> filter) throws IOException {
        return this.tryList(filter, File.rethrow());
    }

    public String[] listNamesUnchecked() throws UncheckedIOException {
        return this.tryListNames(File.unchecked());
    }

    public String[] listNamesUnchecked(BiPredicate<File, String> filter) throws UncheckedIOException {
        return this.tryListNames(filter, File.unchecked());
    }

    public File[] listUnchecked() throws UncheckedIOException {
        return this.tryList(File.unchecked());
    }

    public File[] listUnchecked(Predicate<File> filter) throws UncheckedIOException {
        return this.tryList(filter, File.unchecked());
    }

    public File[] listUnchecked(BiPredicate<File, String> filter) throws UncheckedIOException {
        return this.tryList(filter, File.unchecked());
    }

    public <T extends Throwable> String[] tryListNames(ThrowingFunction<IOException, String[], T> orElse) throws T {
        return File.tryListNames(this.path, Function.identity(), orElse);
    }

    public <T extends Throwable> String[] tryListNames(BiPredicate<File, String> filter, ThrowingFunction<IOException, String[], T> orElse) throws T {
        return (String[])File.tryList(this.path, stream -> stream.map(PathUtils::filename).filter(filename -> filter.test(this, (String)filename)), String[]::new, orElse);
    }

    private <T extends Throwable> File[] tryList(ThrowingFunction<IOException, File[], T> orElse) throws T {
        return File.tryList(this.path, Function.identity(), orElse);
    }

    private <T extends Throwable> File[] tryList(Predicate<File> filter, ThrowingFunction<IOException, File[], T> orElse) throws T {
        return File.tryList(this.path, stream -> stream.filter(filter), orElse);
    }

    private <T extends Throwable> File[] tryList(BiPredicate<File, String> filter, ThrowingFunction<IOException, File[], T> orElse) throws T {
        return File.tryList(this.path, stream -> stream.filter(file -> filter.test(this, file.name())), orElse);
    }

    private static <T extends Throwable> String[] tryListNames(Path path, Function<Stream<File>, Stream<File>> toFiles, ThrowingFunction<IOException, String[], T> orElse) throws T {
        if (path == null) {
            return (String[])orElse.apply(null);
        }
        return (String[])PathUtils.tryList(path, stream -> ((Stream)toFiles.apply(stream.map(File::new))).map(File::name), String[]::new, orElse);
    }

    private static <T extends Throwable, V> V[] tryList(Path path, Function<Stream<Path>, Stream<V>> transformation, IntFunction<V[]> constructor, ThrowingFunction<IOException, V[], T> orElse) throws T {
        if (path == null) {
            return (Object[])orElse.apply(null);
        }
        return PathUtils.tryList(path, transformation, constructor, orElse);
    }

    private static <T extends Throwable> File[] tryList(Path path, Function<Stream<File>, Stream<File>> toFiles, ThrowingFunction<IOException, File[], T> orElse) throws T {
        if (path == null) {
            return (File[])orElse.apply(null);
        }
        return (File[])PathUtils.tryList(path, stream -> (Stream)toFiles.apply(stream.map(File::new)), File[]::new, orElse);
    }

    public String path() {
        return this.toString();
    }

    public Path toPath() {
        return this.path == null ? filesystem.getPath("", new String[0]) : this.path;
    }

    public String toString() {
        return this.path == null ? "" : this.path.toString();
    }

    public int hashCode() {
        return this.path == null ? 0 : this.path.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof File && Objects.equals(this.path, ((File)obj).path);
    }

    @Override
    public int compareTo(File that) {
        if (this.path == null || that.path == null) {
            return this.path == null && that.path == null ? 0 : (this.path == null ? -1 : 1);
        }
        return this.path.compareTo(that.path);
    }

    public java.io.File toJavaIOFile() {
        return this.path == null ? new java.io.File("") : this.path.toFile();
    }

    public FileChannel newReadChannel() throws NoSuchFileException {
        return PathUtils.newReadChannel(this.toPathForRead());
    }

    public FileChannel newReadWriteChannel() throws NoSuchFileException {
        return PathUtils.newReadWriteChannel(this.toPathForRead());
    }

    public FileChannel newWriteChannel(WriteMode mode) throws NoSuchFileException {
        switch (mode) {
            default: {
                throw new AssertionError();
            }
            case APPEND: {
                return PathUtils.newWriteAppendChannel(this.toPathForWrite());
            }
            case OVERWRITE: 
        }
        return PathUtils.newWriteOverwriteChannel(this.toPathForWrite());
    }

    public FileWriter newWriter(WriteMode mode) throws IOException {
        return new FileWriter(this, mode);
    }

    public FileOutputStreamPlus newOutputStream(WriteMode mode) throws NoSuchFileException {
        return new FileOutputStreamPlus(this, mode);
    }

    public FileInputStreamPlus newInputStream() throws NoSuchFileException {
        return new FileInputStreamPlus(this);
    }

    private Path toPathForWrite() {
        if (this.path == null) {
            throw new IllegalStateException("Cannot write to an empty path");
        }
        return this.path;
    }

    private Path toPathForRead() {
        if (this.path == null) {
            throw new IllegalStateException("Cannot read from an empty path");
        }
        return this.path;
    }

    public static void unsafeSetFilesystem(FileSystem fs) {
        filesystem = fs;
    }

    public static enum WriteMode {
        OVERWRITE,
        APPEND;

    }
}

