/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import org.apache.cassandra.io.sstable.SSTableId;
import org.apache.cassandra.utils.TimeUUID;

public final class UUIDBasedSSTableId
implements SSTableId,
Comparable<UUIDBasedSSTableId> {
    public static final int STRING_LEN = 28;
    public static final int BYTES_LEN = 16;
    private final TimeUUID uuid;
    private final String repr;

    public UUIDBasedSSTableId(TimeUUID uuid) {
        this.uuid = uuid;
        this.repr = this.asString();
    }

    @Override
    public ByteBuffer asBytes() {
        return ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN).putLong(0, this.uuid.uuidTimestamp()).putLong(8, this.uuid.lsb());
    }

    private String asString() {
        long ts = this.uuid.uuidTimestamp();
        long nanoPart = ts % 10000000L;
        long seconds = (ts /= 10000000L) % 86400L;
        return String.format("%4s_%4s_%5s%13s", Long.toString(ts /= 86400L, 36), Long.toString(seconds, 36), Long.toString(nanoPart, 36), Long.toUnsignedString(this.uuid.lsb(), 36)).replace(' ', '0');
    }

    @Override
    public String toString() {
        return this.repr;
    }

    @Override
    public int compareTo(UUIDBasedSSTableId o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        return this.uuid.compareTo(o.uuid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UUIDBasedSSTableId that = (UUIDBasedSSTableId)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public static class Builder
    implements SSTableId.Builder<UUIDBasedSSTableId> {
        public static final Builder instance = new Builder();
        private static final Pattern PATTERN = Pattern.compile("([0-9a-z]{4})_([0-9a-z]{4})_([0-9a-z]{5})([0-9a-z]{13})", 2);

        @Override
        public Supplier<UUIDBasedSSTableId> generator(Stream<SSTableId> existingIdentifiers) {
            return () -> new UUIDBasedSSTableId(TimeUUID.Generator.nextTimeUUID());
        }

        @Override
        public boolean isUniqueIdentifier(String str) {
            return str != null && str.length() == 28 && PATTERN.matcher(str).matches();
        }

        @Override
        public boolean isUniqueIdentifier(ByteBuffer bytes) {
            return bytes != null && bytes.remaining() == 16;
        }

        @Override
        public UUIDBasedSSTableId fromString(@Nonnull String s) throws IllegalArgumentException {
            Matcher m = PATTERN.matcher(s);
            if (!m.matches()) {
                throw new IllegalArgumentException("String '" + s + "' is not a valid UUID based sstable identifier");
            }
            long dayPart = Long.parseLong(m.group(1), 36);
            long secondPart = Long.parseLong(m.group(2), 36);
            long nanoPart = Long.parseLong(m.group(3), 36);
            long ts = (dayPart * 86400L + secondPart) * 10000000L + nanoPart;
            long randomPart = Long.parseUnsignedLong(m.group(4), 36);
            TimeUUID uuid = new TimeUUID(ts, randomPart);
            return new UUIDBasedSSTableId(uuid);
        }

        @Override
        public UUIDBasedSSTableId fromBytes(@Nonnull ByteBuffer bytes) throws IllegalArgumentException {
            Preconditions.checkArgument(bytes.remaining() == 16, "Buffer does not have a valid number of bytes remaining. Expecting: %s but was: %s", 16, bytes.remaining());
            bytes = bytes.order() == ByteOrder.BIG_ENDIAN ? bytes : bytes.duplicate().order(ByteOrder.BIG_ENDIAN);
            TimeUUID uuid = new TimeUUID(bytes.getLong(0), bytes.getLong(8));
            return new UUIDBasedSSTableId(uuid);
        }
    }
}

