/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.Collection;
import java.util.Set;
import net.nmoncho.shaded.com.google.common.base.Throwables;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.JVMStabilityInspector;

public interface ISSTableScanner
extends UnfilteredPartitionIterator {
    public long getLengthInBytes();

    public long getCompressedLengthInBytes();

    public long getCurrentPosition();

    public long getBytesScanned();

    public Set<SSTableReader> getBackingSSTables();

    public static void closeAllAndPropagate(Collection<ISSTableScanner> scanners, Throwable throwable) {
        for (ISSTableScanner scanner : scanners) {
            try {
                scanner.close();
            }
            catch (Throwable t2) {
                JVMStabilityInspector.inspectThrowable(t2);
                if (throwable == null) {
                    throwable = t2;
                    continue;
                }
                throwable.addSuppressed(t2);
            }
        }
        if (throwable != null) {
            Throwables.propagate(throwable);
        }
    }
}

