/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.EnumSet;
import java.util.regex.Pattern;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.base.Objects;

public class Component {
    public static final char separator = '-';
    static final EnumSet<Type> TYPES = EnumSet.allOf(Type.class);
    public static final Component DATA = new Component(Type.DATA);
    public static final Component PRIMARY_INDEX = new Component(Type.PRIMARY_INDEX);
    public static final Component FILTER = new Component(Type.FILTER);
    public static final Component COMPRESSION_INFO = new Component(Type.COMPRESSION_INFO);
    public static final Component STATS = new Component(Type.STATS);
    public static final Component DIGEST = new Component(Type.DIGEST);
    public static final Component CRC = new Component(Type.CRC);
    public static final Component SUMMARY = new Component(Type.SUMMARY);
    public static final Component TOC = new Component(Type.TOC);
    public final Type type;
    public final String name;
    public final int hashCode;

    public Component(Type type) {
        this(type, type.repr);
        assert (type != Type.CUSTOM);
    }

    public Component(Type type, String name) {
        assert (name != null) : "Component name cannot be null";
        this.type = type;
        this.name = name;
        this.hashCode = Objects.hashCode(new Object[]{type, name});
    }

    public String name() {
        return this.name;
    }

    public static Component parse(String name) {
        Type type = Type.fromRepresentation(name);
        switch (type) {
            case DATA: {
                return DATA;
            }
            case PRIMARY_INDEX: {
                return PRIMARY_INDEX;
            }
            case FILTER: {
                return FILTER;
            }
            case COMPRESSION_INFO: {
                return COMPRESSION_INFO;
            }
            case STATS: {
                return STATS;
            }
            case DIGEST: {
                return DIGEST;
            }
            case CRC: {
                return CRC;
            }
            case SUMMARY: {
                return SUMMARY;
            }
            case TOC: {
                return TOC;
            }
            case SECONDARY_INDEX: {
                return new Component(Type.SECONDARY_INDEX, name);
            }
            case CUSTOM: {
                return new Component(Type.CUSTOM, name);
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Component)) {
            return false;
        }
        Component that = (Component)o;
        return this.type == that.type && this.name.equals(that.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static enum Type {
        DATA("Data.db"),
        PRIMARY_INDEX("Index.db"),
        FILTER("Filter.db"),
        COMPRESSION_INFO("CompressionInfo.db"),
        STATS("Statistics.db"),
        DIGEST("Digest.crc32"),
        CRC("CRC.db"),
        SUMMARY("Summary.db"),
        TOC("TOC.txt"),
        SECONDARY_INDEX("SI_.*.db"),
        CUSTOM(null);

        final String repr;

        private Type(String repr) {
            this.repr = repr;
        }

        @VisibleForTesting
        public static Type fromRepresentation(String repr) {
            for (Type type : TYPES) {
                if (type.repr == null || !Pattern.matches(type.repr, repr)) continue;
                return type;
            }
            return CUSTOM;
        }
    }
}

