/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import net.nmoncho.shaded.com.google.common.collect.Sets;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.cql3.functions.types.TypeCodec;
import org.apache.cassandra.cql3.functions.types.UserType;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.cql3.statements.schema.CreateTypeStatement;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableSimpleUnsortedWriter;
import org.apache.cassandra.io.sstable.SSTableSimpleWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.SchemaTransformations;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLSSTableWriter
implements Closeable {
    public static final ByteBuffer UNSET_VALUE = ByteBufferUtil.UNSET_BYTE_BUFFER;
    private final AbstractSSTableSimpleWriter writer;
    private final ModificationStatement modificationStatement;
    private final List<ColumnSpecification> boundNames;
    private final List<TypeCodec> typeCodecs;

    private CQLSSTableWriter(AbstractSSTableSimpleWriter writer, ModificationStatement modificationStatement, List<ColumnSpecification> boundNames) {
        this.writer = writer;
        this.modificationStatement = modificationStatement;
        this.boundNames = boundNames;
        this.typeCodecs = boundNames.stream().map(bn -> UDHelper.codecFor(UDHelper.driverType(bn.type))).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public CQLSSTableWriter addRow(Object ... values) throws InvalidRequestException, IOException {
        return this.addRow(Arrays.asList(values));
    }

    public CQLSSTableWriter addRow(List<Object> values) throws InvalidRequestException, IOException {
        int size = Math.min(values.size(), this.boundNames.size());
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            Object value = values.get(i);
            rawValues.add(this.serialize(value, this.typeCodecs.get(i), this.boundNames.get(i)));
        }
        return this.rawAddRow(rawValues);
    }

    public CQLSSTableWriter addRow(Map<String, Object> values) throws InvalidRequestException, IOException {
        int size = this.boundNames.size();
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            ColumnSpecification spec = this.boundNames.get(i);
            Object value = values.get(spec.name.toString());
            rawValues.add(this.serialize(value, this.typeCodecs.get(i), this.boundNames.get(i)));
        }
        return this.rawAddRow(rawValues);
    }

    public CQLSSTableWriter rawAddRow(ByteBuffer ... values) throws InvalidRequestException, IOException {
        return this.rawAddRow(Arrays.asList(values));
    }

    public CQLSSTableWriter rawAddRow(List<ByteBuffer> values) throws InvalidRequestException, IOException {
        if (values.size() != this.boundNames.size()) {
            throw new InvalidRequestException(String.format("Invalid number of arguments, expecting %d values but got %d", this.boundNames.size(), values.size()));
        }
        QueryOptions options = QueryOptions.forInternalCalls(null, values);
        ClientState state = ClientState.forInternalCalls();
        List<ByteBuffer> keys = this.modificationStatement.buildPartitionKeyNames(options, state);
        long now = Clock.Global.currentTimeMillis();
        UpdateParameters params = new UpdateParameters(this.modificationStatement.metadata, this.modificationStatement.updatedColumns(), ClientState.forInternalCalls(), options, this.modificationStatement.getTimestamp(TimeUnit.MILLISECONDS.toMicros(now), options), options.getNowInSec((int)TimeUnit.MILLISECONDS.toSeconds(now)), this.modificationStatement.getTimeToLive(options), Collections.emptyMap());
        try {
            if (this.modificationStatement.hasSlices()) {
                Slices slices = this.modificationStatement.createSlices(options);
                for (ByteBuffer key : keys) {
                    for (Slice slice : slices) {
                        this.modificationStatement.addUpdateForKey(this.writer.getUpdateFor(key), slice, params);
                    }
                }
            } else {
                NavigableSet<Clustering<?>> clusterings = this.modificationStatement.createClustering(options, state);
                for (ByteBuffer key : keys) {
                    for (Clustering<?> clustering : clusterings) {
                        this.modificationStatement.addUpdateForKey(this.writer.getUpdateFor(key), clustering, params);
                    }
                }
            }
            return this;
        }
        catch (SSTableSimpleUnsortedWriter.SyncException e) {
            throw (IOException)e.getCause();
        }
    }

    public CQLSSTableWriter rawAddRow(Map<String, ByteBuffer> values) throws InvalidRequestException, IOException {
        int size = Math.min(values.size(), this.boundNames.size());
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            ColumnSpecification spec = this.boundNames.get(i);
            rawValues.add(values.get(spec.name.toString()));
        }
        return this.rawAddRow(rawValues);
    }

    public UserType getUDType(String dataType) {
        KeyspaceMetadata ksm = Schema.instance.getKeyspaceMetadata(this.modificationStatement.keyspace());
        org.apache.cassandra.db.marshal.UserType userType = ksm.types.getNullable(ByteBufferUtil.bytes(dataType));
        return (UserType)UDHelper.driverType(userType);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private ByteBuffer serialize(Object value, TypeCodec codec, ColumnSpecification columnSpecification) {
        if (value == null || value == UNSET_VALUE) {
            return (ByteBuffer)value;
        }
        try {
            return codec.serialize(value, ProtocolVersion.CURRENT);
        }
        catch (ClassCastException cce) {
            return columnSpecification.type.decompose(value);
        }
    }

    static {
        CassandraRelevantProperties.FORCE_LOAD_LOCAL_KEYSPACES.setBoolean(true);
        DatabaseDescriptor.clientInitialization(false);
        if (DatabaseDescriptor.getPartitioner() == null) {
            DatabaseDescriptor.setPartitionerUnsafe(Murmur3Partitioner.instance);
        }
    }

    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private static final long DEFAULT_BUFFER_SIZE_IN_MIB_FOR_UNSORTED = 128L;
        protected SSTableFormat.Type formatType = null;
        private final List<CreateTypeStatement.Raw> typeStatements = new ArrayList<CreateTypeStatement.Raw>();
        private CreateTableStatement.Raw schemaStatement;
        private ModificationStatement.Parsed modificationStatement;
        private IPartitioner partitioner;
        private File directory;
        private boolean sorted = false;
        private long maxSSTableSizeInMiB = -1L;
        private Consumer<Collection<SSTableReader>> sstableProducedListener;
        private boolean openSSTableOnProduced = false;

        protected Builder() {
        }

        public Builder inDirectory(String directory) {
            return this.inDirectory(new File(directory));
        }

        public Builder inDirectory(File directory) {
            if (!directory.exists()) {
                throw new IllegalArgumentException(directory + " doesn't exists");
            }
            if (!directory.isWritable()) {
                throw new IllegalArgumentException(directory + " exists but is not writable");
            }
            this.directory = directory;
            return this;
        }

        public Builder withType(String typeDefinition) throws SyntaxException {
            this.typeStatements.add(QueryProcessor.parseStatement(typeDefinition, CreateTypeStatement.Raw.class, "CREATE TYPE"));
            return this;
        }

        public Builder forTable(String schema) {
            this.schemaStatement = QueryProcessor.parseStatement(schema, CreateTableStatement.Raw.class, "CREATE TABLE");
            return this;
        }

        public Builder withPartitioner(IPartitioner partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public Builder using(String modificationStatement) {
            this.modificationStatement = QueryProcessor.parseStatement(modificationStatement, ModificationStatement.Parsed.class, "INSERT/UPDATE/DELETE");
            return this;
        }

        public Builder withMaxSSTableSizeInMiB(int size) {
            if (size <= 0) {
                logger.warn("A non-positive value for maximum SSTable size is specified, which disables the size limiting effectively. Please supply a positive value in order to enforce size limiting for the produced SSTables.");
            }
            this.maxSSTableSizeInMiB = size;
            return this;
        }

        public Builder withBufferSizeInMiB(int size) {
            return this.withMaxSSTableSizeInMiB(size);
        }

        @Deprecated
        public Builder withBufferSizeInMB(int size) {
            return this.withBufferSizeInMiB(size);
        }

        public Builder sorted() {
            this.sorted = true;
            return this;
        }

        public Builder withSSTableProducedListener(Consumer<Collection<SSTableReader>> sstableProducedListener) {
            this.sstableProducedListener = sstableProducedListener;
            return this;
        }

        public Builder openSSTableOnProduced() {
            this.openSSTableOnProduced = true;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CQLSSTableWriter build() {
            if (this.directory == null) {
                throw new IllegalStateException("No ouptut directory specified, you should provide a directory with inDirectory()");
            }
            if (this.schemaStatement == null) {
                throw new IllegalStateException("Missing schema, you should provide the schema for the SSTable to create with forTable()");
            }
            if (this.modificationStatement == null) {
                throw new IllegalStateException("No modification (INSERT/UPDATE/DELETE) statement specified, you should provide a modification statement through using()");
            }
            Preconditions.checkState(Sets.difference(SchemaConstants.LOCAL_SYSTEM_KEYSPACE_NAMES, Schema.instance.getKeyspaces()).isEmpty(), "Local keyspaces were not loaded. If this is running as a client, please make sure to add %s=true system property.", (Object)CassandraRelevantProperties.FORCE_LOAD_LOCAL_KEYSPACES.getKey());
            if (this.isMaxSSTableSizeUnset()) {
                this.maxSSTableSizeInMiB = this.sorted ? -1L : 128L;
            }
            Class<CQLSSTableWriter> clazz = CQLSSTableWriter.class;
            synchronized (CQLSSTableWriter.class) {
                AbstractSSTableSimpleWriter writer;
                String keyspaceName = this.schemaStatement.keyspace();
                Schema.instance.transform(SchemaTransformations.addKeyspace(KeyspaceMetadata.create(keyspaceName, KeyspaceParams.simple(1), Tables.none(), Views.none(), Types.none(), Functions.none()), true));
                KeyspaceMetadata ksm = Schema.instance.getKeyspaceMetadata(keyspaceName);
                TableMetadata tableMetadata = ksm.tables.getNullable(this.schemaStatement.table());
                if (tableMetadata == null) {
                    Types types = this.createTypes(keyspaceName);
                    Schema.instance.transform(SchemaTransformations.addTypes(types, true));
                    tableMetadata = this.createTable(types);
                    Schema.instance.transform(SchemaTransformations.addTable(tableMetadata, true));
                }
                ModificationStatement preparedModificationStatement = this.prepareModificationStatement();
                TableMetadataRef ref = TableMetadataRef.forOfflineTools(tableMetadata);
                AbstractSSTableSimpleWriter abstractSSTableSimpleWriter = writer = this.sorted ? new SSTableSimpleWriter(this.directory, ref, preparedModificationStatement.updatedColumns(), this.maxSSTableSizeInMiB) : new SSTableSimpleUnsortedWriter(this.directory, ref, preparedModificationStatement.updatedColumns(), this.maxSSTableSizeInMiB);
                if (this.formatType != null) {
                    writer.setSSTableFormatType(this.formatType);
                }
                if (this.sstableProducedListener != null) {
                    writer.setSSTableProducedListener(this.sstableProducedListener);
                }
                writer.setShouldOpenProducedSSTable(this.openSSTableOnProduced);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new CQLSSTableWriter(writer, preparedModificationStatement, preparedModificationStatement.getBindVariables());
            }
        }

        private boolean isMaxSSTableSizeUnset() {
            return this.maxSSTableSizeInMiB <= 0L;
        }

        private Types createTypes(String keyspace) {
            Types.RawBuilder builder = Types.rawBuilder(keyspace);
            for (CreateTypeStatement.Raw st : this.typeStatements) {
                st.addToRawBuilder(builder);
            }
            return builder.build();
        }

        private TableMetadata createTable(Types types) {
            ClientState state = ClientState.forInternalCalls();
            CreateTableStatement statement = this.schemaStatement.prepare(state);
            statement.validate(ClientState.forInternalCalls());
            TableMetadata.Builder builder = statement.builder(types);
            if (this.partitioner != null) {
                builder.partitioner(this.partitioner);
            }
            return builder.build();
        }

        private ModificationStatement prepareModificationStatement() {
            ClientState state = ClientState.forInternalCalls();
            ModificationStatement preparedModificationStatement = this.modificationStatement.prepare(state);
            preparedModificationStatement.validate(state);
            if (preparedModificationStatement.hasConditions()) {
                throw new IllegalArgumentException("Conditional statements are not supported");
            }
            if (preparedModificationStatement.isCounter()) {
                throw new IllegalArgumentException("Counter modification statements are not supported");
            }
            if (preparedModificationStatement.getBindVariables().isEmpty()) {
                throw new IllegalArgumentException("Provided preparedModificationStatement statement has no bind variables");
            }
            return preparedModificationStatement;
        }
    }
}

