/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.sa;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import net.nmoncho.shaded.com.google.common.base.Charsets;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sasi.disk.TokenTreeBuilder;
import org.apache.cassandra.index.sasi.sa.Term;

public class CharTerm
extends Term<CharBuffer> {
    public CharTerm(int position, CharBuffer value, TokenTreeBuilder tokens) {
        super(position, value, tokens);
    }

    @Override
    public ByteBuffer getTerm() {
        return Charsets.UTF_8.encode(((CharBuffer)this.value).duplicate());
    }

    @Override
    public ByteBuffer getSuffix(int start) {
        return Charsets.UTF_8.encode(((CharBuffer)this.value).subSequence(((CharBuffer)this.value).position() + start, ((CharBuffer)this.value).remaining()));
    }

    @Override
    public int compareTo(AbstractType<?> comparator, Term other) {
        return ((CharBuffer)this.value).compareTo((CharBuffer)other.value);
    }

    @Override
    public int length() {
        return ((CharBuffer)this.value).length();
    }
}

