/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.conf.view;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.index.sasi.SSTableIndex;
import org.apache.cassandra.index.sasi.conf.ColumnIndex;
import org.apache.cassandra.index.sasi.conf.view.PrefixTermTree;
import org.apache.cassandra.index.sasi.conf.view.RangeTermTree;
import org.apache.cassandra.index.sasi.conf.view.TermTree;
import org.apache.cassandra.index.sasi.plan.Expression;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Interval;
import org.apache.cassandra.utils.IntervalTree;

public class View
implements Iterable<SSTableIndex> {
    private final Map<Descriptor, SSTableIndex> view;
    private final TermTree termTree;
    private final AbstractType<?> keyValidator;
    private final IntervalTree<Key, SSTableIndex, Interval<Key, SSTableIndex>> keyIntervalTree;

    public View(ColumnIndex index, Set<SSTableIndex> indexes) {
        this(index, Collections.emptyList(), Collections.emptyList(), indexes);
    }

    public View(ColumnIndex index, Collection<SSTableIndex> currentView, Collection<SSTableReader> oldSSTables, Set<SSTableIndex> newIndexes) {
        HashMap<Descriptor, SSTableIndex> newView = new HashMap<Descriptor, SSTableIndex>();
        AbstractType<?> validator = index.getValidator();
        RangeTermTree.Builder termTreeBuilder = validator instanceof AsciiType || validator instanceof UTF8Type ? new PrefixTermTree.Builder(index.getMode().mode, validator) : new RangeTermTree.Builder(index.getMode().mode, validator);
        ArrayList<Interval<Key, SSTableIndex>> keyIntervals = new ArrayList<Interval<Key, SSTableIndex>>();
        HashSet<SSTableReader> toRemove = new HashSet<SSTableReader>(oldSSTables);
        toRemove.removeAll(newIndexes.stream().map(SSTableIndex::getSSTable).collect(Collectors.toSet()));
        for (SSTableIndex sstableIndex : Iterables.concat(newIndexes, currentView)) {
            SSTableReader sstable = sstableIndex.getSSTable();
            if (toRemove.contains(sstable) || sstable.isMarkedCompacted() || newView.containsKey(sstable.descriptor)) {
                sstableIndex.release();
                continue;
            }
            newView.put(sstable.descriptor, sstableIndex);
            termTreeBuilder.add(sstableIndex);
            keyIntervals.add(Interval.create(new Key(sstableIndex.minKey(), index.keyValidator()), new Key(sstableIndex.maxKey(), index.keyValidator()), sstableIndex));
        }
        this.view = newView;
        this.termTree = ((TermTree.Builder)termTreeBuilder).build();
        this.keyValidator = index.keyValidator();
        this.keyIntervalTree = IntervalTree.build(keyIntervals);
        if (this.keyIntervalTree.intervalCount() != this.termTree.intervalCount()) {
            throw new IllegalStateException(String.format("mismatched sizes for intervals tree for keys vs terms: %d != %d", this.keyIntervalTree.intervalCount(), this.termTree.intervalCount()));
        }
    }

    public Set<SSTableIndex> match(Expression expression) {
        return this.termTree.search(expression);
    }

    public List<SSTableIndex> match(ByteBuffer minKey, ByteBuffer maxKey) {
        return this.keyIntervalTree.search((Key)((Object)Interval.create(new Key(minKey, this.keyValidator), new Key(maxKey, this.keyValidator), null)));
    }

    @Override
    public Iterator<SSTableIndex> iterator() {
        return this.view.values().iterator();
    }

    public Collection<SSTableIndex> getIndexes() {
        return this.view.values();
    }

    private static class Key
    implements Comparable<Key> {
        private final ByteBuffer key;
        private final AbstractType<?> comparator;

        public Key(ByteBuffer key, AbstractType<?> comparator) {
            this.key = key;
            this.comparator = comparator;
        }

        @Override
        public int compareTo(Key o) {
            return this.comparator.compare(this.key, o.key);
        }
    }
}

