/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.conf.view;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import net.nmoncho.shaded.com.google.common.collect.Sets;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sasi.SSTableIndex;
import org.apache.cassandra.index.sasi.conf.view.RangeTermTree;
import org.apache.cassandra.index.sasi.conf.view.TermTree;
import org.apache.cassandra.index.sasi.disk.OnDiskIndexBuilder;
import org.apache.cassandra.index.sasi.plan.Expression;
import org.apache.cassandra.index.sasi.utils.trie.KeyAnalyzer;
import org.apache.cassandra.index.sasi.utils.trie.PatriciaTrie;
import org.apache.cassandra.index.sasi.utils.trie.Trie;
import org.apache.cassandra.utils.Interval;
import org.apache.cassandra.utils.IntervalTree;

public class PrefixTermTree
extends RangeTermTree {
    private final OnDiskIndexBuilder.Mode mode;
    private final Trie<ByteBuffer, Set<SSTableIndex>> trie;

    public PrefixTermTree(ByteBuffer min, ByteBuffer max, Trie<ByteBuffer, Set<SSTableIndex>> trie, IntervalTree<RangeTermTree.Term, SSTableIndex, Interval<RangeTermTree.Term, SSTableIndex>> ranges, OnDiskIndexBuilder.Mode mode, AbstractType<?> comparator) {
        super(min, max, ranges, comparator);
        this.mode = mode;
        this.trie = trie;
    }

    @Override
    public Set<SSTableIndex> search(Expression e) {
        Trie<ByteBuffer, Set<SSTableIndex>> indexes = e == null || e.lower == null || this.mode == OnDiskIndexBuilder.Mode.CONTAINS ? this.trie : this.trie.prefixMap(e.lower.value);
        HashSet view = new HashSet(indexes.size());
        indexes.values().forEach(view::addAll);
        return Sets.union(view, super.search(e));
    }

    private static class ByteBufferKeyAnalyzer
    implements KeyAnalyzer<ByteBuffer> {
        private final AbstractType<?> comparator;
        private static final int MSB = 128;

        public ByteBufferKeyAnalyzer(AbstractType<?> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(ByteBuffer a, ByteBuffer b) {
            return this.comparator.compare(a, b);
        }

        @Override
        public int lengthInBits(ByteBuffer o) {
            return o.remaining() * 8;
        }

        @Override
        public boolean isBitSet(ByteBuffer key, int bitIndex) {
            if (bitIndex >= this.lengthInBits(key)) {
                return false;
            }
            int index = bitIndex / 8;
            int bit = bitIndex % 8;
            return (key.get(index) & this.mask(bit)) != 0;
        }

        @Override
        public int bitIndex(ByteBuffer key, ByteBuffer otherKey) {
            int length = Math.max(key.remaining(), otherKey.remaining());
            boolean allNull = true;
            for (int i = 0; i < length; ++i) {
                byte b2;
                byte b1 = this.valueAt(key, i);
                if (b1 != (b2 = this.valueAt(otherKey, i))) {
                    int xor = b1 ^ b2;
                    for (int j = 0; j < 8; ++j) {
                        if ((xor & this.mask(j)) == 0) continue;
                        return i * 8 + j;
                    }
                }
                if (b1 == 0) continue;
                allNull = false;
            }
            return allNull ? -1 : -2;
        }

        @Override
        public boolean isPrefix(ByteBuffer key, ByteBuffer prefix) {
            if (key.remaining() < prefix.remaining()) {
                return false;
            }
            for (int i = 0; i < prefix.remaining(); ++i) {
                if (key.get(i) == prefix.get(i)) continue;
                return false;
            }
            return true;
        }

        private byte valueAt(ByteBuffer value, int index) {
            return index >= 0 && index < value.remaining() ? value.get(index) : (byte)0;
        }

        private int mask(int bit) {
            return 128 >>> bit;
        }
    }

    public static class Builder
    extends RangeTermTree.Builder {
        private final PatriciaTrie<ByteBuffer, Set<SSTableIndex>> trie;

        protected Builder(OnDiskIndexBuilder.Mode mode, AbstractType<?> comparator) {
            super(mode, comparator);
            this.trie = new PatriciaTrie(new ByteBufferKeyAnalyzer(comparator));
        }

        @Override
        public void addIndex(SSTableIndex index) {
            super.addIndex(index);
            this.addTerm(index.minTerm(), index);
            this.addTerm(index.maxTerm(), index);
        }

        @Override
        public TermTree build() {
            return new PrefixTermTree(this.min, this.max, this.trie, IntervalTree.build(this.intervals), this.mode, this.comparator);
        }

        private void addTerm(ByteBuffer term, SSTableIndex index) {
            HashSet<SSTableIndex> indexes = (HashSet<SSTableIndex>)this.trie.get(term);
            if (indexes == null) {
                indexes = new HashSet<SSTableIndex>();
                this.trie.put((Object)term, indexes);
            }
            indexes.add(index);
        }
    }
}

