/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.analyzer;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.nmoncho.shaded.com.google.common.annotations.Beta;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.index.sasi.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sasi.analyzer.DelimiterTokenizingOptions;
import org.apache.cassandra.utils.AbstractIterator;

@Beta
public class DelimiterAnalyzer
extends AbstractAnalyzer {
    private static final Map<AbstractType<?>, Charset> VALID_ANALYZABLE_TYPES = new HashMap<AbstractType<?>, Charset>(){
        {
            this.put(UTF8Type.instance, StandardCharsets.UTF_8);
            this.put(AsciiType.instance, StandardCharsets.US_ASCII);
        }
    };
    private char delimiter;
    private Charset charset;
    private Iterator<ByteBuffer> iter;

    @Override
    public ByteBuffer next() {
        return this.iter.next();
    }

    @Override
    public void init(Map<String, String> options, AbstractType<?> validator) {
        DelimiterTokenizingOptions tokenizingOptions = DelimiterTokenizingOptions.buildFromMap(options);
        this.delimiter = tokenizingOptions.getDelimiter();
        this.charset = VALID_ANALYZABLE_TYPES.get(validator);
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public void reset(ByteBuffer input) {
        Preconditions.checkNotNull(input);
        final CharBuffer cb = this.charset.decode(input);
        this.iter = new AbstractIterator<ByteBuffer>(){

            @Override
            protected ByteBuffer computeNext() {
                boolean readaheadRemaining;
                if (!cb.hasRemaining()) {
                    return (ByteBuffer)this.endOfData();
                }
                CharBuffer readahead = cb.duplicate();
                while ((readaheadRemaining = readahead.hasRemaining()) && readahead.get() != DelimiterAnalyzer.this.delimiter) {
                }
                char[] chars = new char[readahead.position() - cb.position() - (readaheadRemaining ? 1 : 0)];
                cb.get(chars);
                Preconditions.checkState(!cb.hasRemaining() || cb.get() == DelimiterAnalyzer.this.delimiter);
                return 0 < chars.length ? DelimiterAnalyzer.this.charset.encode(CharBuffer.wrap(chars)) : this.computeNext();
            }
        };
    }

    @Override
    public boolean isTokenizing() {
        return true;
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> validator) {
        return VALID_ANALYZABLE_TYPES.containsKey(validator);
    }
}

