/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.nmoncho.shaded.com.google.common.base.Function;
import net.nmoncho.shaded.com.google.common.collect.Iterators;
import net.nmoncho.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LimitedLocalNodeFirstLocalBalancingPolicy
implements LoadBalancingPolicy {
    private static final Logger logger = LoggerFactory.getLogger(LimitedLocalNodeFirstLocalBalancingPolicy.class);
    private static final Set<InetAddress> localAddresses = Collections.unmodifiableSet(LimitedLocalNodeFirstLocalBalancingPolicy.getLocalInetAddresses());
    private final CopyOnWriteArraySet<Host> liveReplicaHosts = new CopyOnWriteArraySet();
    private final Set<InetAddress> replicaAddresses = new HashSet<InetAddress>();
    private final Set<String> allowedDCs = new CopyOnWriteArraySet<String>();

    public LimitedLocalNodeFirstLocalBalancingPolicy(String[] replicas) {
        for (String replica : replicas) {
            try {
                InetAddress[] addresses = InetAddress.getAllByName(replica);
                Collections.addAll(this.replicaAddresses, addresses);
            }
            catch (UnknownHostException e) {
                logger.warn("Invalid replica host name: {}, skipping it", (Object)replica);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Created instance with the following replicas: {}", Arrays.asList(replicas));
        }
    }

    public void init(Cluster cluster, Collection<Host> hosts) {
        HashSet<String> dcs = new HashSet<String>();
        for (Host host : hosts) {
            if (!this.replicaAddresses.contains(host.getAddress())) continue;
            dcs.add(host.getDatacenter());
        }
        ArrayList<Host> replicaHosts = new ArrayList<Host>();
        for (Host host : hosts) {
            if (!dcs.contains(host.getDatacenter())) continue;
            replicaHosts.add(host);
        }
        this.liveReplicaHosts.addAll(replicaHosts);
        this.allowedDCs.addAll(dcs);
        logger.trace("Initialized with replica hosts: {}", replicaHosts);
    }

    public void close() {
    }

    public HostDistance distance(Host host) {
        if (LimitedLocalNodeFirstLocalBalancingPolicy.isLocalHost(host)) {
            return HostDistance.LOCAL;
        }
        return HostDistance.REMOTE;
    }

    public Iterator<Host> newQueryPlan(String keyspace, Statement statement) {
        ArrayList<Host> local = new ArrayList<Host>(1);
        ArrayList<Host> remote = new ArrayList<Host>(this.liveReplicaHosts.size());
        for (Host liveReplicaHost : this.liveReplicaHosts) {
            if (LimitedLocalNodeFirstLocalBalancingPolicy.isLocalHost(liveReplicaHost)) {
                local.add(liveReplicaHost);
                continue;
            }
            remote.add(liveReplicaHost);
        }
        Collections.shuffle(remote);
        logger.trace("Using the following hosts order for the new query plan: {} | {}", local, remote);
        return Iterators.concat(local.iterator(), remote.iterator());
    }

    public void onAdd(Host host) {
        if (this.liveReplicaHosts.contains(host)) {
            this.liveReplicaHosts.add(host);
            logger.trace("Added a new host {}", (Object)host);
        }
    }

    public void onUp(Host host) {
        if (this.liveReplicaHosts.contains(host)) {
            this.liveReplicaHosts.add(host);
            logger.trace("The host {} is now up", (Object)host);
        }
    }

    public void onDown(Host host) {
        if (this.liveReplicaHosts.remove(host)) {
            logger.trace("The host {} is now down", (Object)host);
        }
    }

    public void onRemove(Host host) {
        if (this.liveReplicaHosts.remove(host)) {
            logger.trace("Removed the host {}", (Object)host);
        }
    }

    public void onSuspected(Host host) {
    }

    private static boolean isLocalHost(Host host) {
        InetAddress hostAddress = host.getAddress();
        return hostAddress.isLoopbackAddress() || localAddresses.contains(hostAddress);
    }

    private static Set<InetAddress> getLocalInetAddresses() {
        try {
            return Sets.newHashSet(Iterators.concat(Iterators.transform(Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), new Function<NetworkInterface, Iterator<InetAddress>>(){

                @Override
                public Iterator<InetAddress> apply(NetworkInterface netIface) {
                    return Iterators.forEnumeration(netIface.getInetAddresses());
                }
            })));
        }
        catch (SocketException e) {
            logger.warn("Could not retrieve local network interfaces.", (Throwable)e);
            return Collections.emptySet();
        }
    }
}

