/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.nmoncho.shaded.com.google.common.net.HostAndPort;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.cql3.CqlBulkOutputFormat;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.io.sstable.CQLSSTableWriter;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.utils.NativeSSTableLoaderClient;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlBulkRecordWriter
extends RecordWriter<Object, List<ByteBuffer>>
implements org.apache.hadoop.mapred.RecordWriter<Object, List<ByteBuffer>> {
    public static final String OUTPUT_LOCATION = "mapreduce.output.bulkoutputformat.localdir";
    public static final String BUFFER_SIZE_IN_MB = "mapreduce.output.bulkoutputformat.buffersize";
    public static final String STREAM_THROTTLE_MBITS = "mapreduce.output.bulkoutputformat.streamthrottlembits";
    public static final String MAX_FAILED_HOSTS = "mapreduce.output.bulkoutputformat.maxfailedhosts";
    public static final String IGNORE_HOSTS = "mapreduce.output.bulkoutputformat.ignorehosts";
    private final Logger logger = LoggerFactory.getLogger(CqlBulkRecordWriter.class);
    protected final Configuration conf;
    protected final int maxFailures;
    protected final int bufferSize;
    protected Closeable writer;
    protected SSTableLoader loader;
    protected Progressable progress;
    protected TaskAttemptContext context;
    protected final Set<InetAddressAndPort> ignores = new HashSet<InetAddressAndPort>();
    private String keyspace;
    private String table;
    private String schema;
    private String insertStatement;
    private File outputDir;
    private boolean deleteSrc;
    private IPartitioner partitioner;

    CqlBulkRecordWriter(TaskAttemptContext context) throws IOException {
        this(HadoopCompat.getConfiguration((JobContext)context));
        this.context = context;
        this.setConfigs();
    }

    CqlBulkRecordWriter(Configuration conf, Progressable progress) throws IOException {
        this(conf);
        this.progress = progress;
        this.setConfigs();
    }

    CqlBulkRecordWriter(Configuration conf) throws IOException {
        this.conf = conf;
        DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(Integer.parseInt(conf.get(STREAM_THROTTLE_MBITS, "0")));
        this.maxFailures = Integer.parseInt(conf.get(MAX_FAILED_HOSTS, "0"));
        this.bufferSize = Integer.parseInt(conf.get(BUFFER_SIZE_IN_MB, "64"));
        this.setConfigs();
    }

    private void setConfigs() throws IOException {
        this.keyspace = ConfigHelper.getOutputKeyspace(this.conf);
        this.table = ConfigHelper.getOutputColumnFamily(this.conf);
        String aliasedCf = CqlBulkOutputFormat.getTableForAlias(this.conf, this.table);
        if (aliasedCf != null) {
            this.table = aliasedCf;
        }
        this.schema = CqlBulkOutputFormat.getTableSchema(this.conf, this.table);
        this.insertStatement = CqlBulkOutputFormat.getTableInsertStatement(this.conf, this.table);
        this.outputDir = this.getTableDirectory();
        this.deleteSrc = CqlBulkOutputFormat.getDeleteSourceOnSuccess(this.conf);
        try {
            this.partitioner = ConfigHelper.getInputPartitioner(this.conf);
        }
        catch (Exception e) {
            this.partitioner = Murmur3Partitioner.instance;
        }
        try {
            for (String hostToIgnore : CqlBulkOutputFormat.getIgnoreHosts(this.conf)) {
                this.ignores.add(InetAddressAndPort.getByName(hostToIgnore));
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unknown host: " + e.getMessage());
        }
    }

    protected String getOutputLocation() throws IOException {
        String dir = this.conf.get(OUTPUT_LOCATION, CassandraRelevantProperties.JAVA_IO_TMPDIR.getString());
        if (dir == null) {
            throw new IOException("Output directory not defined, if hadoop is not setting java.io.tmpdir then define mapreduce.output.bulkoutputformat.localdir");
        }
        return dir;
    }

    private void prepareWriter() throws IOException {
        if (this.writer == null) {
            this.writer = CQLSSTableWriter.builder().forTable(this.schema).using(this.insertStatement).withPartitioner(ConfigHelper.getOutputPartitioner(this.conf)).inDirectory(this.outputDir).withBufferSizeInMiB(Integer.parseInt(this.conf.get(BUFFER_SIZE_IN_MB, "64"))).withPartitioner(this.partitioner).build();
        }
        if (this.loader == null) {
            ExternalClient externalClient = new ExternalClient(this.conf);
            externalClient.setTableMetadata(TableMetadataRef.forOfflineTools(CreateTableStatement.parse(this.schema, this.keyspace).build()));
            this.loader = new SSTableLoader(this.outputDir, externalClient, new NullOutputHandler()){

                @Override
                public void onSuccess(StreamState finalState) {
                    if (CqlBulkRecordWriter.this.deleteSrc) {
                        FileUtils.deleteRecursive(CqlBulkRecordWriter.this.outputDir);
                    }
                }
            };
        }
    }

    public void write(Object key, List<ByteBuffer> values) throws IOException {
        this.prepareWriter();
        try {
            ((CQLSSTableWriter)this.writer).rawAddRow(values);
            if (null != this.progress) {
                this.progress.progress();
            }
            if (null != this.context) {
                HadoopCompat.progress(this.context);
            }
        }
        catch (InvalidRequestException e) {
            throw new IOException("Error adding row with key: " + key, e);
        }
    }

    private File getTableDirectory() throws IOException {
        File dir = new File(String.format("%s%s%s%s%s-%s", this.getOutputLocation(), File.pathSeparator(), this.keyspace, File.pathSeparator(), this.table, UUID.randomUUID().toString()));
        if (!dir.exists() && !dir.tryCreateDirectories()) {
            throw new IOException("Failed to created output directory: " + dir);
        }
        return dir;
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.close();
    }

    @Deprecated
    public void close(Reporter reporter) throws IOException {
        this.close();
    }

    private void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            StreamResultFuture future = this.loader.stream(this.ignores, new StreamEventHandler[0]);
            while (true) {
                try {
                    future.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException | TimeoutException te) {
                    if (null != this.progress) {
                        this.progress.progress();
                    }
                    if (null == this.context) continue;
                    HadoopCompat.progress(this.context);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                break;
            }
            if (this.loader.getFailedHosts().size() > 0) {
                if (this.loader.getFailedHosts().size() > this.maxFailures) {
                    throw new IOException("Too many hosts failed: " + this.loader.getFailedHosts());
                }
                this.logger.warn("Some hosts failed: {}", this.loader.getFailedHosts());
            }
        }
    }

    public static class NullOutputHandler
    implements OutputHandler {
        @Override
        public void output(String msg) {
        }

        @Override
        public void debug(String msg) {
        }

        @Override
        public void warn(String msg) {
        }

        @Override
        public void warn(String msg, Throwable th) {
        }
    }

    public static class ExternalClient
    extends NativeSSTableLoaderClient {
        public ExternalClient(Configuration conf) {
            super(ExternalClient.resolveHostAddresses(conf), ConfigHelper.getOutputInitialPort(conf), ConfigHelper.getOutputKeyspaceUserName(conf), ConfigHelper.getOutputKeyspacePassword(conf), CqlConfigHelper.getSSLOptions(conf).orNull());
        }

        private static Collection<InetSocketAddress> resolveHostAddresses(Configuration conf) {
            HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
            int port = CqlConfigHelper.getOutputNativePort(conf);
            for (String host : ConfigHelper.getOutputInitialAddress(conf).split(",")) {
                try {
                    HostAndPort hap = HostAndPort.fromString(host);
                    addresses.add(new InetSocketAddress(InetAddress.getByName(hap.getHost()), hap.getPortOrDefault(port)));
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
            return addresses;
        }
    }
}

