/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.collect.ImmutableSet;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.TokenSerializer;
import org.apache.cassandra.gms.VersionGenerator;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.format.VersionAndType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.StringUtils;

public class VersionedValue
implements Comparable<VersionedValue> {
    public static final IVersionedSerializer<VersionedValue> serializer = new VersionedValueSerializer();
    public static final char DELIMITER = ',';
    public static final String DELIMITER_STR = new String(new char[]{','});
    public static final String STATUS_BOOTSTRAPPING = "BOOT";
    public static final String STATUS_BOOTSTRAPPING_REPLACE = "BOOT_REPLACE";
    public static final String STATUS_NORMAL = "NORMAL";
    public static final String STATUS_LEAVING = "LEAVING";
    public static final String STATUS_LEFT = "LEFT";
    public static final String STATUS_MOVING = "MOVING";
    public static final String REMOVING_TOKEN = "removing";
    public static final String REMOVED_TOKEN = "removed";
    public static final String HIBERNATE = "hibernate";
    public static final String SHUTDOWN = "shutdown";
    public static final String REMOVAL_COORDINATOR = "REMOVER";
    public static final Set<String> BOOTSTRAPPING_STATUS = ImmutableSet.of("BOOT", "BOOT_REPLACE");
    public final int version;
    public final String value;

    private VersionedValue(String value, int version) {
        assert (value != null);
        this.value = value;
        this.version = version;
    }

    private VersionedValue(String value) {
        this(value, VersionGenerator.getNextVersion());
    }

    public static VersionedValue unsafeMakeVersionedValue(String value, int version) {
        return new VersionedValue(value, version);
    }

    @Override
    public int compareTo(VersionedValue value) {
        return this.version - value.version;
    }

    public String toString() {
        return "Value(" + this.value + ',' + this.version + ')';
    }

    public byte[] toBytes() {
        return this.value.getBytes(StandardCharsets.ISO_8859_1);
    }

    private static String versionString(String ... args) {
        return StringUtils.join((Object[])args, (char)',');
    }

    private static class VersionedValueSerializer
    implements IVersionedSerializer<VersionedValue> {
        private VersionedValueSerializer() {
        }

        @Override
        public void serialize(VersionedValue value, DataOutputPlus out, int version) throws IOException {
            out.writeUTF(this.outValue(value, version));
            out.writeInt(value.version);
        }

        private String outValue(VersionedValue value, int version) {
            return value.value;
        }

        @Override
        public VersionedValue deserialize(DataInputPlus in, int version) throws IOException {
            String value = in.readUTF();
            int valVersion = in.readInt();
            return new VersionedValue(value, valVersion);
        }

        @Override
        public long serializedSize(VersionedValue value, int version) {
            return TypeSizes.sizeof(this.outValue(value, version)) + TypeSizes.sizeof(value.version);
        }
    }

    public static class VersionedValueFactory {
        final IPartitioner partitioner;

        public VersionedValueFactory(IPartitioner partitioner) {
            this.partitioner = partitioner;
        }

        public VersionedValue cloneWithHigherVersion(VersionedValue value) {
            return new VersionedValue(value.value);
        }

        @Deprecated
        public VersionedValue bootReplacing(InetAddress oldNode) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.STATUS_BOOTSTRAPPING_REPLACE, oldNode.getHostAddress()}));
        }

        public VersionedValue bootReplacingWithPort(InetAddressAndPort oldNode) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.STATUS_BOOTSTRAPPING_REPLACE, oldNode.getHostAddressAndPort()}));
        }

        public VersionedValue bootstrapping(Collection<Token> tokens) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.STATUS_BOOTSTRAPPING, this.makeTokenString(tokens)}));
        }

        public VersionedValue normal(Collection<Token> tokens) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.STATUS_NORMAL, this.makeTokenString(tokens)}));
        }

        private String makeTokenString(Collection<Token> tokens) {
            return this.partitioner.getTokenFactory().toString(Iterables.get(tokens, 0));
        }

        public VersionedValue load(double load) {
            return new VersionedValue(String.valueOf(load));
        }

        public VersionedValue diskUsage(String state) {
            return new VersionedValue(state);
        }

        public VersionedValue schema(UUID newVersion) {
            return new VersionedValue(newVersion.toString());
        }

        public VersionedValue leaving(Collection<Token> tokens) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.STATUS_LEAVING, this.makeTokenString(tokens)}));
        }

        public VersionedValue left(Collection<Token> tokens, long expireTime) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.STATUS_LEFT, this.makeTokenString(tokens), Long.toString(expireTime)}));
        }

        @VisibleForTesting
        public VersionedValue left(Collection<Token> tokens, long expireTime, int generation) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.STATUS_LEFT, this.makeTokenString(tokens), Long.toString(expireTime)}), generation);
        }

        public VersionedValue moving(Token token) {
            return new VersionedValue("MOVING," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue hostId(UUID hostId) {
            return new VersionedValue(hostId.toString());
        }

        public VersionedValue tokens(Collection<Token> tokens) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bos);
            try {
                TokenSerializer.serialize(this.partitioner, tokens, out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new VersionedValue(new String(bos.toByteArray(), StandardCharsets.ISO_8859_1));
        }

        public VersionedValue removingNonlocal(UUID hostId) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.REMOVING_TOKEN, hostId.toString()}));
        }

        public VersionedValue removedNonlocal(UUID hostId, long expireTime) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.REMOVED_TOKEN, hostId.toString(), Long.toString(expireTime)}));
        }

        public VersionedValue removalCoordinator(UUID hostId) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.REMOVAL_COORDINATOR, hostId.toString()}));
        }

        public VersionedValue hibernate(boolean value) {
            return new VersionedValue("hibernate," + value);
        }

        public VersionedValue rpcReady(boolean value) {
            return new VersionedValue(String.valueOf(value));
        }

        public VersionedValue shutdown(boolean value) {
            return new VersionedValue("shutdown," + value);
        }

        public VersionedValue datacenter(String dcId) {
            return new VersionedValue(dcId);
        }

        public VersionedValue rack(String rackId) {
            return new VersionedValue(rackId);
        }

        public VersionedValue rpcaddress(InetAddress endpoint) {
            return new VersionedValue(endpoint.getHostAddress());
        }

        public VersionedValue nativeaddressAndPort(InetAddressAndPort address) {
            return new VersionedValue(address.getHostAddressAndPort());
        }

        public VersionedValue releaseVersion() {
            return new VersionedValue(FBUtilities.getReleaseVersionString());
        }

        @VisibleForTesting
        public VersionedValue releaseVersion(String version) {
            return new VersionedValue(version);
        }

        @VisibleForTesting
        public VersionedValue networkVersion(int version) {
            return new VersionedValue(String.valueOf(version));
        }

        public VersionedValue networkVersion() {
            return new VersionedValue(String.valueOf(12));
        }

        public VersionedValue internalIP(InetAddress private_ip) {
            return new VersionedValue(private_ip.getHostAddress());
        }

        public VersionedValue internalAddressAndPort(InetAddressAndPort private_ip_and_port) {
            return new VersionedValue(private_ip_and_port.getHostAddressAndPort());
        }

        public VersionedValue severity(double value) {
            return new VersionedValue(String.valueOf(value));
        }

        public VersionedValue sstableVersions(Set<VersionAndType> versions) {
            return new VersionedValue(versions.stream().map(VersionAndType::toString).collect(Collectors.joining(",")));
        }
    }
}

