/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.gms.HeartBeatStateSerializer;
import org.apache.cassandra.gms.VersionGenerator;
import org.apache.cassandra.io.IVersionedSerializer;

public class HeartBeatState {
    public static final int EMPTY_VERSION = -1;
    public static final IVersionedSerializer<HeartBeatState> serializer = new HeartBeatStateSerializer();
    private volatile int generation;
    private volatile int version;

    HeartBeatState(int gen) {
        this(gen, 0);
    }

    public HeartBeatState(HeartBeatState other) {
        this.generation = other.generation;
        this.version = other.version;
    }

    public HeartBeatState(int gen, int ver) {
        this.generation = gen;
        this.version = ver;
    }

    public static HeartBeatState empty() {
        return new HeartBeatState(0, -1);
    }

    public boolean isEmpty() {
        return this.version == -1;
    }

    public int getGeneration() {
        return this.generation;
    }

    void updateHeartBeat() {
        this.version = VersionGenerator.getNextVersion();
    }

    public int getHeartBeatVersion() {
        return this.version;
    }

    void forceNewerGenerationUnsafe() {
        ++this.generation;
    }

    @VisibleForTesting
    public void forceHighestPossibleVersionUnsafe() {
        this.version = Integer.MAX_VALUE;
    }

    public String toString() {
        return String.format("HeartBeat: generation = %d, version = %d", this.generation, this.version);
    }
}

