/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.nmoncho.shaded.com.google.common.collect.ImmutableList;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.TokenAllocatorBase;
import org.apache.cassandra.diag.DiagnosticEvent;

final class TokenAllocatorEvent<Unit>
extends DiagnosticEvent {
    private final TokenAllocatorEventType type;
    private final TokenAllocatorBase<Unit> allocator;
    private final int replicas;
    @Nullable
    private final Integer numTokens;
    @Nullable
    private final Collection<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> sortedUnits;
    @Nullable
    private final Map<Unit, Collection<Token>> unitToTokens;
    @Nullable
    private final ImmutableMap<Token, Unit> sortedTokens;
    @Nullable
    private final List<Token> tokens;
    @Nullable
    private final Unit unit;
    @Nullable
    private final TokenAllocatorBase.TokenInfo<Unit> tokenInfo;

    TokenAllocatorEvent(TokenAllocatorEventType type, TokenAllocatorBase<Unit> allocator, @Nullable Integer numTokens, @Nullable ImmutableList<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> sortedUnits, @Nullable ImmutableMap<Unit, Collection<Token>> unitToTokens, @Nullable ImmutableMap<Token, Unit> sortedTokens, @Nullable ImmutableList<Token> tokens, Unit unit, @Nullable TokenAllocatorBase.TokenInfo<Unit> tokenInfo) {
        this.type = type;
        this.allocator = allocator;
        this.replicas = allocator.getReplicas();
        this.numTokens = numTokens;
        this.sortedUnits = sortedUnits;
        this.unitToTokens = unitToTokens;
        this.sortedTokens = sortedTokens;
        this.tokens = tokens;
        this.unit = unit;
        this.tokenInfo = tokenInfo;
    }

    public TokenAllocatorEventType getType() {
        return this.type;
    }

    public HashMap<String, Serializable> toMap() {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (this.allocator != null) {
            if (this.allocator.partitioner != null) {
                ret.put("partitioner", (Serializable)((Object)this.allocator.partitioner.getClass().getSimpleName()));
            }
            if (this.allocator.strategy != null) {
                ret.put("strategy", (Serializable)((Object)this.allocator.strategy.getClass().getSimpleName()));
            }
        }
        ret.put("replicas", Integer.valueOf(this.replicas));
        ret.put("numTokens", this.numTokens);
        ret.put("sortedUnits", (Serializable)((Object)String.valueOf(this.sortedUnits)));
        ret.put("sortedTokens", (Serializable)((Object)String.valueOf(this.sortedTokens)));
        ret.put("unitToTokens", (Serializable)((Object)String.valueOf(this.unitToTokens)));
        ret.put("tokens", (Serializable)((Object)String.valueOf(this.tokens)));
        ret.put("unit", (Serializable)((Object)String.valueOf(this.unit)));
        ret.put("tokenInfo", (Serializable)((Object)String.valueOf(this.tokenInfo)));
        return ret;
    }

    static enum TokenAllocatorEventType {
        REPLICATION_AWARE_TOKEN_ALLOCATOR_INSTANCIATED,
        NO_REPLICATION_AWARE_TOKEN_ALLOCATOR_INSTANCIATED,
        UNIT_ADDED,
        UNIT_REMOVED,
        TOKEN_INFOS_CREATED,
        RANDOM_TOKENS_GENERATED,
        TOKENS_ALLOCATED;

    }
}

