/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.Collection;
import java.util.Set;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.collect.Streams;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamRequest;
import org.apache.cassandra.streaming.StreamState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamStateStore
implements StreamEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(StreamStateStore.class);

    public SystemKeyspace.AvailableRanges getAvailableRanges(String keyspace, IPartitioner partitioner) {
        return SystemKeyspace.getAvailableRanges(keyspace, partitioner);
    }

    @VisibleForTesting
    public boolean isDataAvailable(String keyspace, Token token) {
        SystemKeyspace.AvailableRanges availableRanges = this.getAvailableRanges(keyspace, token.getPartitioner());
        return Streams.concat(availableRanges.full.stream(), availableRanges.trans.stream()).anyMatch(range -> range.contains(token));
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
        if (event.eventType == StreamEvent.Type.STREAM_COMPLETE) {
            StreamEvent.SessionCompleteEvent se = (StreamEvent.SessionCompleteEvent)event;
            if (se.success) {
                Set<String> keyspaces = se.transferredRangesPerKeyspace.keySet();
                for (String keyspace : keyspaces) {
                    SystemKeyspace.updateTransferredRanges(se.streamOperation, se.peer, keyspace, (Collection<Range<Token>>)se.transferredRangesPerKeyspace.get(keyspace));
                }
                for (StreamRequest request : se.requests) {
                    SystemKeyspace.updateAvailableRanges(request.keyspace, request.full.ranges(), request.transientReplicas.ranges());
                }
            }
        }
    }

    @Override
    public void onSuccess(StreamState streamState) {
    }

    @Override
    public void onFailure(Throwable throwable) {
    }
}

