/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.collect.Sets;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;

public abstract class Splitter {
    private final IPartitioner partitioner;

    protected Splitter(IPartitioner partitioner) {
        this.partitioner = partitioner;
    }

    @VisibleForTesting
    protected abstract Token tokenForValue(BigInteger var1);

    @VisibleForTesting
    protected abstract BigInteger valueForToken(Token var1);

    @VisibleForTesting
    protected BigInteger tokensInRange(Range<Token> range) {
        if (((Token)range.left).equals(range.right)) {
            return this.tokensInRange(new Range<Token>(this.partitioner.getMinimumToken(), this.partitioner.getMaximumToken()));
        }
        BigInteger totalTokens = BigInteger.ZERO;
        for (Range<Token> unwrapped : range.unwrap()) {
            totalTokens = totalTokens.add(this.valueForToken(this.token((Token)unwrapped.right)).subtract(this.valueForToken((Token)unwrapped.left))).abs();
        }
        return totalTokens;
    }

    @VisibleForTesting
    protected BigInteger elapsedTokens(Token token, Range<Token> range) {
        if (!range.contains(token)) {
            return BigInteger.ZERO;
        }
        BigInteger elapsedTokens = BigInteger.ZERO;
        for (Range<Token> unwrapped : range.unwrap()) {
            if (unwrapped.contains(token)) {
                elapsedTokens = elapsedTokens.add(this.tokensInRange(new Range<Token>((Token)unwrapped.left, token)));
                continue;
            }
            if (token.compareTo(unwrapped.left) >= 0) continue;
            elapsedTokens = elapsedTokens.add(this.tokensInRange(unwrapped));
        }
        return elapsedTokens;
    }

    public double positionInRange(Token token, Range<Token> range) {
        if (((Token)range.left).equals(range.right)) {
            return this.positionInRange(token, new Range<Token>(this.partitioner.getMinimumToken(), this.partitioner.getMaximumToken()));
        }
        if (token.equals(range.left)) {
            return 0.0;
        }
        if (token.equals(range.right)) {
            return 1.0;
        }
        if (!range.contains(token)) {
            return -1.0;
        }
        return new BigDecimal(this.elapsedTokens(token, range)).divide(new BigDecimal(this.tokensInRange(range)), 3, 6).doubleValue();
    }

    public List<Token> splitOwnedRanges(int parts, List<WeightedRange> weightedRanges, boolean dontSplitRanges) {
        if (weightedRanges.isEmpty() || parts == 1) {
            return Collections.singletonList(this.partitioner.getMaximumToken());
        }
        BigInteger totalTokens = BigInteger.ZERO;
        for (WeightedRange weightedRange : weightedRanges) {
            totalTokens = totalTokens.add(weightedRange.totalTokens(this));
        }
        BigInteger perPart = totalTokens.divide(BigInteger.valueOf(parts));
        if (perPart.equals(BigInteger.ZERO)) {
            return Collections.singletonList(this.partitioner.getMaximumToken());
        }
        if (dontSplitRanges) {
            return this.splitOwnedRangesNoPartialRanges(weightedRanges, perPart, parts);
        }
        ArrayList<Token> boundaries = new ArrayList<Token>();
        BigInteger sum = BigInteger.ZERO;
        BigInteger tokensLeft = totalTokens;
        for (WeightedRange weightedRange : weightedRanges) {
            BigInteger currentRangeWidth = weightedRange.totalTokens(this);
            BigInteger left = this.valueForToken(weightedRange.left());
            while (sum.add(currentRangeWidth).compareTo(perPart) >= 0) {
                BigInteger withinRangeBoundary = perPart.subtract(sum);
                left = left.add(withinRangeBoundary);
                boundaries.add(this.tokenForValue(left));
                tokensLeft = tokensLeft.subtract(perPart);
                currentRangeWidth = currentRangeWidth.subtract(withinRangeBoundary);
                sum = BigInteger.ZERO;
                int partsLeft = parts - boundaries.size();
                if (partsLeft == 0) break;
                if (partsLeft != 1) continue;
                perPart = tokensLeft;
            }
            sum = sum.add(currentRangeWidth);
        }
        boundaries.set(boundaries.size() - 1, this.partitioner.getMaximumToken());
        assert (boundaries.size() == parts) : boundaries.size() + "!=" + parts + " " + boundaries + ":" + weightedRanges;
        return boundaries;
    }

    private List<Token> splitOwnedRangesNoPartialRanges(List<WeightedRange> weightedRanges, BigInteger perPart, int parts) {
        ArrayList<Token> boundaries = new ArrayList<Token>(parts);
        BigInteger sum = BigInteger.ZERO;
        int rangesCount = weightedRanges.size();
        for (int i = 0; boundaries.size() < parts - 1 && i < rangesCount - 1; ++i) {
            WeightedRange r = weightedRanges.get(i);
            WeightedRange nextRange = weightedRanges.get(i + 1);
            BigInteger currentRangeWidth = r.totalTokens(this);
            BigInteger nextRangeWidth = nextRange.totalTokens(this);
            if ((sum = sum.add(currentRangeWidth)).compareTo(perPart) <= 0 && sum.add(nextRangeWidth).compareTo(perPart) <= 0) continue;
            BigInteger diffCurrent = sum.subtract(perPart).abs();
            BigInteger diffNext = sum.add(nextRangeWidth).subtract(perPart).abs();
            if (diffNext.compareTo(diffCurrent) < 0) continue;
            sum = BigInteger.ZERO;
            boundaries.add(this.token(r.right()));
        }
        boundaries.add(this.partitioner.getMaximumToken());
        return boundaries;
    }

    private Token token(Token t) {
        return t.equals(this.partitioner.getMinimumToken()) ? this.partitioner.getMaximumToken() : t;
    }

    public Set<Range<Token>> split(Collection<Range<Token>> ranges, int parts) {
        int numRanges = ranges.size();
        if (numRanges >= parts) {
            return Sets.newHashSet(ranges);
        }
        int partsPerRange = (int)Math.ceil((double)parts / (double)numRanges);
        return ranges.stream().map(range -> this.split((Range<Token>)range, partsPerRange)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<Range<Token>> split(Range<Token> range, int parts) {
        BigInteger numTokens = this.tokensInRange(range);
        if (BigInteger.valueOf(parts).compareTo(numTokens) > 0) {
            return Collections.singleton(range);
        }
        Token left = (Token)range.left;
        HashSet<Range<Token>> subranges = new HashSet<Range<Token>>(parts);
        for (double i = 1.0; i <= (double)parts; i += 1.0) {
            Token right = this.partitioner.split((Token)range.left, (Token)range.right, i / (double)parts);
            subranges.add(new Range<Token>(left, right));
            left = right;
        }
        return subranges;
    }

    public static class WeightedRange {
        private final double weight;
        private final Range<Token> range;

        public WeightedRange(double weight, Range<Token> range) {
            this.weight = weight;
            this.range = range;
        }

        public BigInteger totalTokens(Splitter splitter) {
            BigInteger right = splitter.valueForToken(splitter.token((Token)this.range.right));
            BigInteger left = splitter.valueForToken((Token)this.range.left);
            BigInteger factor = BigInteger.valueOf(Math.max(1L, (long)(1.0 / this.weight)));
            BigInteger size = right.subtract(left);
            return size.abs().divide(factor);
        }

        public Token left() {
            return (Token)this.range.left;
        }

        public Token right() {
            return (Token)this.range.right;
        }

        public Range<Token> range() {
            return this.range;
        }

        public String toString() {
            return "WeightedRange{weight=" + this.weight + ", range=" + this.range + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeightedRange)) {
                return false;
            }
            WeightedRange that = (WeightedRange)o;
            return Objects.equals(this.range, that.range);
        }

        public int hashCode() {
            return Objects.hash(this.weight, this.range);
        }
    }
}

