/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.Snapshot;
import java.util.Collection;
import java.util.function.Function;
import net.nmoncho.shaded.com.google.common.collect.ImmutableList;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.commons.math3.util.Precision;

public class TableMetricTables {
    private static final String KEYSPACE_NAME = "keyspace_name";
    private static final String TABLE_NAME = "table_name";
    private static final String P50 = "p50th";
    private static final String P99 = "p99th";
    private static final String MAX = "max";
    private static final String RATE = "per_second";
    private static final double BYTES_TO_MIB = 9.5367431640625E-7;
    private static final double NS_TO_MS = 1.0E-6;
    private static final AbstractType<?> TYPE = CompositeType.getInstance(UTF8Type.instance, UTF8Type.instance);
    private static final IPartitioner PARTITIONER = new LocalPartitioner(TYPE);

    public static Collection<VirtualTable> getAll(String name) {
        return ImmutableList.of(new LatencyTableMetric(name, "local_read_latency", t -> t.readLatency.latency), new LatencyTableMetric(name, "local_scan_latency", t -> t.rangeLatency.latency), new LatencyTableMetric(name, "coordinator_read_latency", t -> t.coordinatorReadLatency), new LatencyTableMetric(name, "coordinator_scan_latency", t -> t.coordinatorScanLatency), new LatencyTableMetric(name, "local_write_latency", t -> t.writeLatency.latency), new LatencyTableMetric(name, "coordinator_write_latency", t -> t.coordinatorWriteLatency), new HistogramTableMetric(name, "tombstones_per_read", t -> t.tombstoneScannedHistogram.cf), new HistogramTableMetric(name, "rows_per_read", t -> t.liveScannedHistogram.cf), new StorageTableMetric(name, "disk_usage", t -> t.totalDiskSpaceUsed), new StorageTableMetric(name, "max_partition_size", t -> t.maxPartitionSize));
    }

    private static TableMetadata buildMetadata(String keyspace, String table, Function<TableMetrics, ? extends Metric> func, String colName, AbstractType colType, String suffix) {
        TableMetadata.Builder metadata = TableMetadata.builder(keyspace, table).kind(TableMetadata.Kind.VIRTUAL).addPartitionKeyColumn(KEYSPACE_NAME, (AbstractType)UTF8Type.instance).addPartitionKeyColumn(TABLE_NAME, (AbstractType)UTF8Type.instance).partitioner(PARTITIONER);
        Keyspace system = Keyspace.system().iterator().next();
        Metric test = func.apply(system.getColumnFamilyStores().iterator().next().metric);
        if (test instanceof Counting) {
            metadata.addRegularColumn(colName, colType);
            if (test instanceof Sampling) {
                metadata.addRegularColumn(P50 + suffix, (AbstractType)DoubleType.instance).addRegularColumn(P99 + suffix, (AbstractType)DoubleType.instance).addRegularColumn(MAX + suffix, (AbstractType)DoubleType.instance);
            }
            if (test instanceof Metered) {
                metadata.addRegularColumn(RATE, (AbstractType)DoubleType.instance);
            }
        } else if (test instanceof Gauge) {
            metadata.addRegularColumn(colName, colType);
        }
        return metadata.build();
    }

    private static class TableMetricTable
    extends AbstractVirtualTable {
        final Function<TableMetrics, ? extends Metric> func;
        final String columnName;
        final String suffix;

        TableMetricTable(String keyspace, String table, Function<TableMetrics, ? extends Metric> func, String colName, AbstractType colType, String suffix) {
            super(TableMetricTables.buildMetadata(keyspace, table, func, colName, colType, suffix));
            this.func = func;
            this.columnName = colName;
            this.suffix = suffix;
        }

        public void add(SimpleDataSet result, String column, double value) {
            result.column(column, value);
        }

        public void add(SimpleDataSet result, String column, long value) {
            result.column(column, value);
        }

        @Override
        public AbstractVirtualTable.DataSet data() {
            SimpleDataSet result = new SimpleDataSet(this.metadata());
            for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
                Metric metric = this.func.apply(cfs.metric);
                result.row(cfs.keyspace.getName(), cfs.name);
                if (metric instanceof Counting) {
                    this.add(result, this.columnName, ((Counting)metric).getCount());
                    if (metric instanceof Sampling) {
                        Sampling histo = (Sampling)metric;
                        Snapshot snapshot = histo.getSnapshot();
                        this.add(result, TableMetricTables.P50 + this.suffix, snapshot.getMedian());
                        this.add(result, TableMetricTables.P99 + this.suffix, snapshot.get99thPercentile());
                        this.add(result, TableMetricTables.MAX + this.suffix, (double)snapshot.getMax());
                    }
                    if (!(metric instanceof Metered)) continue;
                    Metered timer = (Metered)metric;
                    this.add(result, TableMetricTables.RATE, timer.getFiveMinuteRate());
                    continue;
                }
                if (!(metric instanceof Gauge)) continue;
                this.add(result, this.columnName, (Long)((Gauge)metric).getValue());
            }
            return result;
        }
    }

    private static class LatencyTableMetric
    extends HistogramTableMetric {
        <M extends Metric & Sampling> LatencyTableMetric(String keyspace, String table, Function<TableMetrics, M> func) {
            super(keyspace, table, func, "_ms");
        }

        @Override
        public void add(SimpleDataSet result, String column, double value) {
            if (column.endsWith(this.suffix)) {
                value *= 1.0E-6;
            }
            super.add(result, column, value);
        }
    }

    private static class HistogramTableMetric
    extends TableMetricTable {
        <M extends Metric & Sampling> HistogramTableMetric(String keyspace, String table, Function<TableMetrics, M> func) {
            this(keyspace, table, func, "");
        }

        <M extends Metric & Sampling> HistogramTableMetric(String keyspace, String table, Function<TableMetrics, M> func, String suffix) {
            super(keyspace, table, func, "count", LongType.instance, suffix);
        }

        @Override
        public void add(SimpleDataSet result, String column, double value) {
            result.column(column, Precision.round((double)value, (int)3, (int)4));
        }
    }

    private static class StorageTableMetric
    extends TableMetricTable {
        <M extends Metric & Counting> StorageTableMetric(String keyspace, String table, CountingFunction<M> func) {
            super(keyspace, table, func, "mebibytes", LongType.instance, "");
        }

        StorageTableMetric(String keyspace, String table, GaugeFunction func) {
            super(keyspace, table, func, "mebibytes", LongType.instance, "");
        }

        @Override
        public void add(SimpleDataSet result, String column, long value) {
            result.column(column, (long)Math.ceil((double)value * 9.5367431640625E-7));
        }

        static interface CountingFunction<M extends Metric & Counting>
        extends Function<TableMetrics, M> {
        }

        static interface GaugeFunction
        extends Function<TableMetrics, Gauge<Long>> {
        }
    }
}

