/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import java.util.Iterator;
import java.util.NavigableMap;
import java.util.function.Supplier;
import net.nmoncho.shaded.com.google.common.collect.AbstractIterator;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.AbstractUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.SingletonUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.Clock;

public abstract class AbstractVirtualTable
implements VirtualTable {
    protected final TableMetadata metadata;

    protected AbstractVirtualTable(TableMetadata metadata) {
        if (!metadata.isVirtual()) {
            throw new IllegalArgumentException("Cannot instantiate a non-virtual table");
        }
        this.metadata = metadata;
    }

    @Override
    public TableMetadata metadata() {
        return this.metadata;
    }

    public abstract DataSet data();

    public DataSet data(DecoratedKey partitionKey) {
        return this.data();
    }

    @Override
    public final UnfilteredPartitionIterator select(DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter, ColumnFilter columnFilter) {
        Partition partition = this.data(partitionKey).getPartition(partitionKey);
        if (null == partition) {
            return EmptyIterators.unfilteredPartition(this.metadata);
        }
        long now = Clock.Global.currentTimeMillis();
        UnfilteredRowIterator rowIterator = partition.toRowIterator(this.metadata(), clusteringIndexFilter, columnFilter, now);
        return new SingletonUnfilteredPartitionIterator(rowIterator);
    }

    @Override
    public final UnfilteredPartitionIterator select(final DataRange dataRange, final ColumnFilter columnFilter) {
        DataSet data = this.data();
        if (data.isEmpty()) {
            return EmptyIterators.unfilteredPartition(this.metadata);
        }
        final Iterator<Partition> iterator = data.getPartitions(dataRange);
        final long now = Clock.Global.currentTimeMillis();
        return new AbstractUnfilteredPartitionIterator(){

            @Override
            public UnfilteredRowIterator next() {
                Partition partition = (Partition)iterator.next();
                return partition.toRowIterator(AbstractVirtualTable.this.metadata, dataRange.clusteringIndexFilter(partition.key()), columnFilter, now);
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public TableMetadata metadata() {
                return AbstractVirtualTable.this.metadata;
            }
        };
    }

    @Override
    public void apply(PartitionUpdate update) {
        throw new InvalidRequestException("Modification is not supported by table " + this.metadata);
    }

    @Override
    public void truncate() {
        throw new InvalidRequestException("Truncation is not supported by table " + this.metadata);
    }

    public String toString() {
        return this.metadata().toString();
    }

    public static class SimpleTable
    extends AbstractVirtualTable {
        private final Supplier<? extends DataSet> supplier;

        public SimpleTable(TableMetadata metadata, Supplier<DataSet> supplier) {
            super(metadata);
            this.supplier = supplier;
        }

        @Override
        public DataSet data() {
            return this.supplier.get();
        }
    }

    public static abstract class AbstractDataSet
    implements DataSet {
        protected final NavigableMap<DecoratedKey, Partition> partitions;

        protected AbstractDataSet(NavigableMap<DecoratedKey, Partition> partitions) {
            this.partitions = partitions;
        }

        @Override
        public boolean isEmpty() {
            return this.partitions.isEmpty();
        }

        @Override
        public Partition getPartition(DecoratedKey key) {
            return (Partition)this.partitions.get(key);
        }

        @Override
        public Iterator<Partition> getPartitions(final DataRange dataRange) {
            AbstractBounds<PartitionPosition> keyRange = dataRange.keyRange();
            PartitionPosition startKey = (PartitionPosition)keyRange.left;
            PartitionPosition endKey = (PartitionPosition)keyRange.right;
            NavigableMap<DecoratedKey, Partition> selection = this.partitions;
            if (startKey.isMinimum() && endKey.isMinimum()) {
                return selection.values().iterator();
            }
            if (startKey.isMinimum() && endKey instanceof DecoratedKey) {
                return selection.headMap((DecoratedKey)endKey, keyRange.isEndInclusive()).values().iterator();
            }
            if (startKey instanceof DecoratedKey && endKey instanceof DecoratedKey) {
                return selection.subMap((DecoratedKey)startKey, keyRange.isStartInclusive(), (DecoratedKey)endKey, keyRange.isEndInclusive()).values().iterator();
            }
            if (startKey instanceof DecoratedKey) {
                selection = selection.tailMap((DecoratedKey)startKey, keyRange.isStartInclusive());
            }
            if (endKey instanceof DecoratedKey) {
                selection = selection.headMap((DecoratedKey)endKey, keyRange.isEndInclusive());
            }
            final Iterator iterator = selection.values().iterator();
            return new AbstractIterator<Partition>(){
                private boolean encounteredPartitionsWithinRange;

                @Override
                protected Partition computeNext() {
                    while (iterator.hasNext()) {
                        Partition partition = (Partition)iterator.next();
                        if (dataRange.contains(partition.key())) {
                            this.encounteredPartitionsWithinRange = true;
                            return partition;
                        }
                        if (!this.encounteredPartitionsWithinRange) continue;
                        return (Partition)this.endOfData();
                    }
                    return (Partition)this.endOfData();
                }
            };
        }
    }

    public static interface Partition {
        public DecoratedKey key();

        public UnfilteredRowIterator toRowIterator(TableMetadata var1, ClusteringIndexFilter var2, ColumnFilter var3, long var4);
    }

    public static interface DataSet {
        public boolean isEmpty();

        public Partition getPartition(DecoratedKey var1);

        public Iterator<Partition> getPartitions(DataRange var1);
    }
}

