/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import java.util.Optional;
import java.util.function.Predicate;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.Replica;

public final class ViewUtils {
    private ViewUtils() {
    }

    public static Optional<Replica> getViewNaturalEndpoint(AbstractReplicationStrategy replicationStrategy, Token baseToken, Token viewToken) {
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getLocalDatacenter();
        EndpointsForToken naturalBaseReplicas = replicationStrategy.getNaturalReplicasForToken(baseToken);
        EndpointsForToken naturalViewReplicas = replicationStrategy.getNaturalReplicasForToken(viewToken);
        Optional<Replica> localReplica = Iterables.tryFind(naturalViewReplicas, Replica::isSelf).toJavaUtil();
        if (localReplica.isPresent()) {
            return localReplica;
        }
        Predicate<Replica> isLocalDC = r -> !(replicationStrategy instanceof NetworkTopologyStrategy) || DatabaseDescriptor.getEndpointSnitch().getDatacenter((Replica)r).equals(localDataCenter);
        EndpointsForToken baseReplicas = (EndpointsForToken)naturalBaseReplicas.filter(r -> !naturalViewReplicas.endpoints().contains(r.endpoint()) && isLocalDC.test((Replica)r));
        EndpointsForToken viewReplicas = (EndpointsForToken)naturalViewReplicas.filter(r -> !naturalBaseReplicas.endpoints().contains(r.endpoint()) && isLocalDC.test((Replica)r));
        assert (baseReplicas.size() == viewReplicas.size()) : "Replication strategy should have the same number of endpoints for the base and the view";
        int baseIdx = -1;
        for (int i = 0; i < baseReplicas.size(); ++i) {
            if (!baseReplicas.get(i).isSelf()) continue;
            baseIdx = i;
            break;
        }
        if (baseIdx < 0) {
            return Optional.empty();
        }
        return Optional.of(viewReplicas.get(baseIdx));
    }
}

