/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import net.nmoncho.shaded.com.google.common.collect.Maps;
import net.nmoncho.shaded.com.google.common.util.concurrent.Striped;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.view.TableViews;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.schema.SystemDistributedKeyspace;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewManager {
    private static final Logger logger = LoggerFactory.getLogger(ViewManager.class);
    private static final Striped<Lock> LOCKS = Striped.lazyWeakLock(DatabaseDescriptor.getConcurrentViewWriters() * 1024);
    private static final boolean enableCoordinatorBatchlog = Boolean.getBoolean("cassandra.mv_enable_coordinator_batchlog");
    private final ConcurrentMap<String, View> viewsByName = new ConcurrentHashMap<String, View>();
    private final ConcurrentMap<TableId, TableViews> viewsByBaseTable = new ConcurrentHashMap<TableId, TableViews>();
    private final Keyspace keyspace;

    public ViewManager(Keyspace keyspace) {
        this.keyspace = keyspace;
    }

    public boolean updatesAffectView(Collection<? extends IMutation> mutations, boolean coordinatorBatchlog) {
        if (!enableCoordinatorBatchlog && coordinatorBatchlog) {
            return false;
        }
        for (IMutation iMutation : mutations) {
            for (PartitionUpdate update : iMutation.getPartitionUpdates()) {
                assert (this.keyspace.getName().equals(update.metadata().keyspace));
                if (coordinatorBatchlog && this.keyspace.getReplicationStrategy().getReplicationFactor().allReplicas == 1 || this.forTable(update.metadata().id).updatedViews(update).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private Iterable<View> allViews() {
        return this.viewsByName.values();
    }

    public void reload(boolean buildAllViews) {
        Views views = this.keyspace.getMetadata().views;
        HashMap<String, ViewMetadata> newViewsByName = Maps.newHashMapWithExpectedSize(views.size());
        for (ViewMetadata viewMetadata : views) {
            newViewsByName.put(viewMetadata.name(), viewMetadata);
        }
        for (Map.Entry entry : newViewsByName.entrySet()) {
            if (this.viewsByName.containsKey(entry.getKey())) continue;
            this.addView((ViewMetadata)entry.getValue());
        }
        if (!buildAllViews) {
            return;
        }
        if (!StorageService.instance.isInitialized()) {
            logger.info("Not submitting build tasks for views in keyspace {} as storage service is not initialized", (Object)this.keyspace.getName());
            return;
        }
        for (View view : this.allViews()) {
            view.build();
            view.updateDefinition((ViewMetadata)newViewsByName.get(view.name));
        }
    }

    public void addView(ViewMetadata definition) {
        if (!this.keyspace.hasColumnFamilyStore(definition.baseTableId)) {
            logger.warn("Not adding view {} because the base table {} is unknown", (Object)definition.name(), (Object)definition.baseTableId);
            return;
        }
        View view = new View(definition, this.keyspace.getColumnFamilyStore(definition.baseTableId));
        this.forTable(view.getDefinition().baseTableId).add(view);
        this.viewsByName.put(definition.name(), view);
    }

    public void dropView(String name) {
        View view = (View)this.viewsByName.remove(name);
        if (view == null) {
            return;
        }
        view.stopBuild();
        this.forTable(view.getDefinition().baseTableId).removeByName(name);
        SystemKeyspace.setViewRemoved(this.keyspace.getName(), view.name);
        SystemDistributedKeyspace.setViewRemoved(this.keyspace.getName(), view.name);
    }

    public View getByName(String name) {
        return (View)this.viewsByName.get(name);
    }

    public void buildAllViews() {
        for (View view : this.allViews()) {
            view.build();
        }
    }

    public TableViews forTable(TableId id) {
        TableViews previous;
        TableViews views = (TableViews)this.viewsByBaseTable.get(id);
        if (views == null && (previous = this.viewsByBaseTable.putIfAbsent(id, views = new TableViews(id))) != null) {
            views = previous;
        }
        return views;
    }

    public static Lock acquireLockFor(int keyAndCfidHash) {
        Lock lock = LOCKS.get(keyAndCfidHash);
        if (lock.tryLock()) {
            return lock;
        }
        return null;
    }
}

