/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.streaming.CassandraCompressedStreamWriter;
import org.apache.cassandra.db.streaming.CassandraEntireSSTableStreamWriter;
import org.apache.cassandra.db.streaming.CassandraStreamHeader;
import org.apache.cassandra.db.streaming.CassandraStreamWriter;
import org.apache.cassandra.db.streaming.ComponentContext;
import org.apache.cassandra.db.streaming.ComponentManifest;
import org.apache.cassandra.db.streaming.CompressionInfo;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.OutgoingStream;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamingDataOutputPlus;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Ref;

public class CassandraOutgoingFile
implements OutgoingStream {
    private final Ref<SSTableReader> ref;
    private final long estimatedKeys;
    private final List<SSTableReader.PartitionPositionBounds> sections;
    private final String filename;
    private final boolean shouldStreamEntireSSTable;
    private final StreamOperation operation;
    private final CassandraStreamHeader header;

    public CassandraOutgoingFile(StreamOperation operation, Ref<SSTableReader> ref, List<SSTableReader.PartitionPositionBounds> sections, List<Range<Token>> normalizedRanges, long estimatedKeys) {
        Preconditions.checkNotNull(ref.get());
        Range.assertNormalized(normalizedRanges);
        this.operation = operation;
        this.ref = ref;
        this.estimatedKeys = estimatedKeys;
        this.sections = sections;
        SSTableReader sstable = ref.get();
        this.filename = sstable.getFilename();
        this.shouldStreamEntireSSTable = this.computeShouldStreamEntireSSTables();
        ComponentManifest manifest = ComponentManifest.create(sstable.descriptor);
        this.header = CassandraOutgoingFile.makeHeader(sstable, operation, sections, estimatedKeys, this.shouldStreamEntireSSTable, manifest);
    }

    private static CassandraStreamHeader makeHeader(SSTableReader sstable, StreamOperation operation, List<SSTableReader.PartitionPositionBounds> sections, long estimatedKeys, boolean shouldStreamEntireSSTable, ComponentManifest manifest) {
        boolean keepSSTableLevel = operation == StreamOperation.BOOTSTRAP || operation == StreamOperation.REBUILD;
        CompressionInfo compressionInfo = sstable.compression ? CompressionInfo.newLazyInstance(sstable.getCompressionMetadata(), sections) : null;
        return CassandraStreamHeader.builder().withSSTableFormat(sstable.descriptor.formatType).withSSTableVersion(sstable.descriptor.version).withSSTableLevel(keepSSTableLevel ? sstable.getSSTableLevel() : 0).withEstimatedKeys(estimatedKeys).withSections(sections).withCompressionInfo(compressionInfo).withSerializationHeader(sstable.header.toComponent()).isEntireSSTable(shouldStreamEntireSSTable).withComponentManifest(manifest).withFirstKey(sstable.first).withTableId(sstable.metadata().id).build();
    }

    @VisibleForTesting
    public static CassandraOutgoingFile fromStream(OutgoingStream stream) {
        Preconditions.checkArgument(stream instanceof CassandraOutgoingFile);
        return (CassandraOutgoingFile)stream;
    }

    @VisibleForTesting
    public Ref<SSTableReader> getRef() {
        return this.ref;
    }

    @Override
    public String getName() {
        return this.filename;
    }

    @Override
    public long getEstimatedSize() {
        return this.header.size();
    }

    @Override
    public TableId getTableId() {
        return this.ref.get().metadata().id;
    }

    @Override
    public int getNumFiles() {
        return this.shouldStreamEntireSSTable ? this.header.componentManifest.components().size() : 1;
    }

    @Override
    public long getRepairedAt() {
        return this.ref.get().getRepairedAt();
    }

    @Override
    public TimeUUID getPendingRepair() {
        return this.ref.get().getPendingRepair();
    }

    @Override
    public void write(StreamSession session, StreamingDataOutputPlus out, int version) throws IOException {
        SSTableReader sstable = this.ref.get();
        if (this.shouldStreamEntireSSTable) {
            try (ComponentContext context = sstable.runWithLock(ignored -> ComponentContext.create(sstable.descriptor));){
                CassandraStreamHeader current = CassandraOutgoingFile.makeHeader(sstable, this.operation, this.sections, this.estimatedKeys, true, context.manifest());
                CassandraStreamHeader.serializer.serialize(current, out, version);
                out.flush();
                CassandraEntireSSTableStreamWriter writer = new CassandraEntireSSTableStreamWriter(sstable, session, context);
                writer.write(out);
            }
        } else {
            CassandraStreamHeader.serializer.serialize(this.header, out, version);
            out.flush();
            CassandraStreamWriter writer = this.header.isCompressed() ? new CassandraCompressedStreamWriter(sstable, this.header, session) : new CassandraStreamWriter(sstable, this.header, session);
            writer.write(out);
        }
    }

    @VisibleForTesting
    public boolean computeShouldStreamEntireSSTables() {
        if (!DatabaseDescriptor.streamEntireSSTables() || this.ref.get().getSSTableMetadata().hasLegacyCounterShards) {
            return false;
        }
        return this.contained(this.sections, this.ref.get());
    }

    @VisibleForTesting
    public boolean contained(List<SSTableReader.PartitionPositionBounds> sections, SSTableReader sstable) {
        if (sections == null || sections.isEmpty()) {
            return false;
        }
        long transferLength = sections.stream().mapToLong(p -> p.upperPosition - p.lowerPosition).sum();
        return transferLength == sstable.uncompressedLength();
    }

    @Override
    public void finish() {
        this.ref.release();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraOutgoingFile that = (CassandraOutgoingFile)o;
        return this.estimatedKeys == that.estimatedKeys && Objects.equals(this.ref, that.ref) && Objects.equals(this.sections, that.sections);
    }

    public int hashCode() {
        return Objects.hash(this.ref, this.estimatedKeys, this.sections);
    }

    public String toString() {
        return "CassandraOutgoingFile{" + this.filename + '}';
    }
}

