/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.memtable;

import java.util.Arrays;
import java.util.List;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.Token;

public class ShardBoundaries {
    private static final Token[] EMPTY_TOKEN_ARRAY = new Token[0];
    public static final ShardBoundaries NONE = new ShardBoundaries(EMPTY_TOKEN_ARRAY, -1L);
    private final Token[] boundaries;
    public final long ringVersion;

    @VisibleForTesting
    public ShardBoundaries(Token[] boundaries, long ringVersion) {
        this.boundaries = boundaries;
        this.ringVersion = ringVersion;
    }

    public ShardBoundaries(List<Token> boundaries, long ringVersion) {
        this(boundaries.toArray(EMPTY_TOKEN_ARRAY), ringVersion);
    }

    public int getShardForToken(Token tk) {
        for (int i = 0; i < this.boundaries.length; ++i) {
            if (tk.compareTo(this.boundaries[i]) >= 0) continue;
            return i;
        }
        return this.boundaries.length;
    }

    public int getShardForKey(PartitionPosition key) {
        if (this.boundaries.length == 0) {
            return 0;
        }
        assert (key.getPartitioner() == DatabaseDescriptor.getPartitioner());
        return this.getShardForToken(key.getToken());
    }

    public int shardCount() {
        return this.boundaries.length + 1;
    }

    public String toString() {
        if (this.boundaries.length == 0) {
            return "shard 0: (min, max)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("shard 0: (min, ").append(this.boundaries[0]).append(") ");
        for (int i = 0; i < this.boundaries.length - 1; ++i) {
            sb.append("shard ").append(i + 1).append(": (").append(this.boundaries[i]).append(", ").append(this.boundaries[i + 1]).append("] ");
        }
        sb.append("shard ").append(this.boundaries.length).append(": (").append(this.boundaries[this.boundaries.length - 1]).append(", max)");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardBoundaries that = (ShardBoundaries)o;
        return Arrays.equals(this.boundaries, that.boundaries);
    }

    public int hashCode() {
        return Arrays.hashCode(this.boundaries);
    }
}

