/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.memtable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import net.nmoncho.shaded.com.google.common.base.Throwables;
import net.nmoncho.shaded.com.google.common.collect.ImmutableList;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.DiskBoundaries;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.IntervalSet;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flushing {
    private static final Logger logger = LoggerFactory.getLogger(Flushing.class);

    private Flushing() {
    }

    public static List<FlushRunnable> flushRunnables(ColumnFamilyStore cfs, Memtable memtable, LifecycleTransaction txn) {
        DiskBoundaries diskBoundaries = cfs.getDiskBoundaries();
        ImmutableList<PartitionPosition> boundaries = diskBoundaries.positions;
        List<Directories.DataDirectory> locations = diskBoundaries.directories;
        if (boundaries == null) {
            FlushRunnable runnable = Flushing.flushRunnable(cfs, memtable, null, null, txn, null);
            return Collections.singletonList(runnable);
        }
        ArrayList<FlushRunnable> runnables = new ArrayList<FlushRunnable>(boundaries.size());
        PartitionPosition rangeStart = ((PartitionPosition)boundaries.get(0)).getPartitioner().getMinimumToken().minKeyBound();
        try {
            for (int i = 0; i < boundaries.size(); ++i) {
                PartitionPosition t = (PartitionPosition)boundaries.get(i);
                FlushRunnable runnable = Flushing.flushRunnable(cfs, memtable, rangeStart, t, txn, locations.get(i));
                runnables.add(runnable);
                rangeStart = t;
            }
            return runnables;
        }
        catch (Throwable e) {
            throw Throwables.propagate(Flushing.abortRunnables(runnables, e));
        }
    }

    static FlushRunnable flushRunnable(ColumnFamilyStore cfs, Memtable memtable, PartitionPosition from, PartitionPosition to, LifecycleTransaction txn, Directories.DataDirectory flushLocation) {
        Memtable.FlushablePartitionSet<?> flushSet = memtable.getFlushSet(from, to);
        SSTableFormat.Type formatType = SSTableFormat.Type.current();
        long estimatedSize = formatType.info.getWriterFactory().estimateSize(flushSet);
        Descriptor descriptor = flushLocation == null ? cfs.newSSTableDescriptor(cfs.getDirectories().getWriteableLocationAsFile(estimatedSize), formatType) : cfs.newSSTableDescriptor(cfs.getDirectories().getLocationForDisk(flushLocation), formatType);
        SSTableMultiWriter writer = Flushing.createFlushWriter(cfs, flushSet, txn, descriptor, flushSet.partitionCount());
        return new FlushRunnable(flushSet, writer, cfs.metric, true);
    }

    public static Throwable abortRunnables(List<FlushRunnable> runnables, Throwable t) {
        if (runnables != null) {
            for (FlushRunnable runnable : runnables) {
                t = runnable.writer.abort(t);
            }
        }
        return t;
    }

    public static SSTableMultiWriter createFlushWriter(ColumnFamilyStore cfs, Memtable.FlushablePartitionSet<?> flushSet, LifecycleTransaction txn, Descriptor descriptor, long partitionCount) {
        MetadataCollector sstableMetadataCollector = new MetadataCollector(flushSet.metadata().comparator).commitLogIntervals(new IntervalSet<CommitLogPosition>(flushSet.commitLogLowerBound(), flushSet.commitLogUpperBound()));
        return cfs.createSSTableMultiWriter(descriptor, partitionCount, 0L, ActiveRepairService.NO_PENDING_REPAIR, false, sstableMetadataCollector, new SerializationHeader(true, flushSet.metadata(), flushSet.columns(), flushSet.encodingStats()), (LifecycleNewTracker)txn);
    }

    public static class FlushRunnable
    implements Callable<SSTableMultiWriter> {
        private final Memtable.FlushablePartitionSet<?> toFlush;
        private final SSTableMultiWriter writer;
        private final TableMetrics metrics;
        private final boolean isBatchLogTable;
        private final boolean logCompletion;

        public FlushRunnable(Memtable.FlushablePartitionSet<?> flushSet, SSTableMultiWriter writer, TableMetrics metrics, boolean logCompletion) {
            this.toFlush = flushSet;
            this.writer = writer;
            this.metrics = metrics;
            this.isBatchLogTable = this.toFlush.metadata() == SystemKeyspace.Batches;
            this.logCompletion = logCompletion;
        }

        private void writeSortedContents() {
            logger.info("Writing {}, flushed range = [{}, {})", new Object[]{this.toFlush.memtable(), this.toFlush.from(), this.toFlush.to()});
            for (Partition partition : this.toFlush) {
                if (this.isBatchLogTable && !partition.partitionLevelDeletion().isLive() && partition.hasRows() || partition.isEmpty()) continue;
                UnfilteredRowIterator iter = partition.unfilteredIterator();
                Throwable throwable = null;
                try {
                    this.writer.append(iter);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iter == null) continue;
                    if (throwable != null) {
                        try {
                            iter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iter.close();
                }
            }
            if (this.logCompletion) {
                long bytesFlushed = this.writer.getFilePointer();
                logger.info("Completed flushing {} ({}) for commitlog position {}", new Object[]{this.writer.getFilename(), FBUtilities.prettyPrintMemory(bytesFlushed), this.toFlush.memtable().getFinalCommitLogUpperBound()});
                this.metrics.bytesFlushed.inc(bytesFlushed);
            }
        }

        @Override
        public SSTableMultiWriter call() {
            this.writeSortedContents();
            return this.writer;
        }

        public String toString() {
            return "Flush " + this.toFlush.metadata().keyspace + '.' + this.toFlush.metadata().name;
        }
    }
}

