/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.regex.Pattern;
import net.nmoncho.shaded.com.google.common.primitives.UnsignedLongs;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.serializers.UUIDSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;

public class UUIDType
extends AbstractType<UUID> {
    public static final UUIDType instance = new UUIDType();
    static final Pattern regexPattern = Pattern.compile("[A-Fa-f0-9]{8}\\-[A-Fa-f0-9]{4}\\-[A-Fa-f0-9]{4}\\-[A-Fa-f0-9]{4}\\-[A-Fa-f0-9]{12}");

    UUIDType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        long msb2;
        int version2;
        boolean p2;
        boolean p1 = accessorL.size(left) == 16;
        boolean bl = p2 = accessorR.size(right) == 16;
        if (!(p1 & p2)) {
            assert (p1 || accessorL.isEmpty(left));
            assert (p2 || accessorR.isEmpty(right));
            return p1 ? 1 : (p2 ? -1 : 0);
        }
        long msb1 = accessorL.getLong(left, 0);
        int version1 = (int)(msb1 >>> 12 & 0xFL);
        if (version1 != (version2 = (int)((msb2 = accessorR.getLong(right, 0)) >>> 12 & 0xFL))) {
            return version1 - version2;
        }
        if (version1 == 1) {
            long reorder2;
            long reorder1 = TimeUUIDType.reorderTimestampBytes(msb1);
            int c = Long.compare(reorder1, reorder2 = TimeUUIDType.reorderTimestampBytes(msb2));
            if (c != 0) {
                return c;
            }
        } else {
            int c = UnsignedLongs.compare(msb1, msb2);
            if (c != 0) {
                return c;
            }
        }
        return UnsignedLongs.compare(accessorL.getLong(left, 8), accessorR.getLong(right, 8));
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return otherType instanceof UUIDType || otherType instanceof TimeUUIDType;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        ByteBuffer parsed = UUIDType.parse(source);
        if (parsed != null) {
            return parsed;
        }
        throw new MarshalException(String.format("Unable to make UUID from '%s'", source));
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.UUID;
    }

    @Override
    public TypeSerializer<UUID> getSerializer() {
        return UUIDSerializer.instance;
    }

    static ByteBuffer parse(String source) {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        if (regexPattern.matcher(source).matches()) {
            try {
                return UUIDGen.toByteBuffer(UUID.fromString(source));
            }
            catch (IllegalArgumentException e) {
                throw new MarshalException(String.format("Unable to make UUID from '%s'", source), e);
            }
        }
        return null;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a uuid, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    static int version(ByteBuffer uuid) {
        return (uuid.get(6) & 0xF0) >> 4;
    }

    @Override
    public int valueLengthIfFixed() {
        return 16;
    }
}

