/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import net.nmoncho.shaded.com.google.common.collect.Maps;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.BytesSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicCompositeType
extends AbstractCompositeType {
    private static final Logger logger = LoggerFactory.getLogger(DynamicCompositeType.class);
    @VisibleForTesting
    public final Map<Byte, AbstractType<?>> aliases;
    private final Serializer serializer;
    private static final ConcurrentHashMap<Map<Byte, AbstractType<?>>, DynamicCompositeType> instances = new ConcurrentHashMap();

    public static DynamicCompositeType getInstance(TypeParser parser) {
        return DynamicCompositeType.getInstance(parser.getAliasParameters());
    }

    public static DynamicCompositeType getInstance(Map<Byte, AbstractType<?>> aliases) {
        DynamicCompositeType dct = instances.get(aliases);
        return null == dct ? instances.computeIfAbsent(aliases, DynamicCompositeType::new) : dct;
    }

    private DynamicCompositeType(Map<Byte, AbstractType<?>> aliases) {
        this.aliases = ImmutableMap.copyOf(aliases);
        this.serializer = new Serializer(aliases);
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return this.serializer;
    }

    @Override
    protected <V> boolean readIsStatic(V value, ValueAccessor<V> accessor) {
        return false;
    }

    @Override
    protected int startingOffset(boolean isStatic) {
        return 0;
    }

    @Override
    protected <V> int getComparatorSize(int i, V value, ValueAccessor<V> accessor, int offset) {
        short header = accessor.getShort(value, offset);
        if ((header & 0x8000) == 0) {
            return 2 + header;
        }
        return 2;
    }

    private <V> AbstractType<?> getComparator(V value, ValueAccessor<V> accessor, int offset) {
        try {
            short header = accessor.getShort(value, offset);
            if ((header & 0x8000) == 0) {
                String name = accessor.toString(accessor.slice(value, offset + 2, header));
                return TypeParser.parse(name);
            }
            return this.aliases.get((byte)(header & 0xFF));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected <V> AbstractType<?> getComparator(int i, V value, ValueAccessor<V> accessor, int offset) {
        return this.getComparator(value, accessor, offset);
    }

    @Override
    protected <VL, VR> AbstractType<?> getComparator(int i, VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR, int offsetL, int offsetR) {
        AbstractType<Object> comp1 = this.getComparator(left, accessorL, offsetL);
        AbstractType<Object> comp2 = this.getComparator(right, accessorR, offsetR);
        AbstractType<?> rawComp = comp1;
        if (comp1 instanceof ReversedType && comp2 instanceof ReversedType) {
            comp1 = ((ReversedType)comp1).baseType;
            comp2 = ((ReversedType)comp2).baseType;
        }
        if (comp1 != comp2) {
            int cmp = comp1.getClass().getSimpleName().compareTo(comp2.getClass().getSimpleName());
            if (cmp != 0) {
                return cmp < 0 ? FixedValueComparator.alwaysLesserThan : FixedValueComparator.alwaysGreaterThan;
            }
            cmp = comp1.getClass().getName().compareTo(comp2.getClass().getName());
            if (cmp != 0) {
                return cmp < 0 ? FixedValueComparator.alwaysLesserThan : FixedValueComparator.alwaysGreaterThan;
            }
        }
        return rawComp;
    }

    @Override
    protected <V> AbstractType<?> getAndAppendComparator(int i, V value, ValueAccessor<V> accessor, StringBuilder sb, int offset) {
        try {
            short header = accessor.getShort(value, offset);
            if ((header & 0x8000) == 0) {
                String name = accessor.toString(accessor.slice(value, offset + 2, header));
                sb.append(name).append("@");
                return TypeParser.parse(name);
            }
            sb.append((char)(header & 0xFF)).append("@");
            return this.aliases.get((byte)(header & 0xFF));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected AbstractCompositeType.ParsedComparator parseComparator(int i, String part) {
        return new DynamicParsedComparator(part);
    }

    @Override
    protected <V> AbstractType<?> validateComparator(int i, V input, ValueAccessor<V> accessor, int offset) throws MarshalException {
        AbstractType<?> comparator = null;
        if (accessor.sizeFromOffset(input, offset) < 2) {
            throw new MarshalException("Not enough bytes to header of the comparator part of component " + i);
        }
        short header = accessor.getShort(input, offset);
        offset += 2;
        if ((header & 0x8000) == 0) {
            if (accessor.sizeFromOffset(input, offset) < header) {
                throw new MarshalException("Not enough bytes to read comparator name of component " + i);
            }
            V value = accessor.slice(input, offset, header);
            String valueStr = null;
            try {
                valueStr = accessor.toString(value);
                comparator = TypeParser.parse(valueStr);
            }
            catch (CharacterCodingException ce) {
                logger.error("Failed when decoding the byte buffer in ByteBufferUtil.string()", (Throwable)ce);
            }
            catch (Exception e) {
                logger.error("Failed to parse value string \"{}\" with exception:", (Object)valueStr, (Object)e);
            }
        } else {
            comparator = this.aliases.get((byte)(header & 0xFF));
        }
        if (comparator == null) {
            throw new MarshalException("Cannot find comparator for component " + i);
        }
        return comparator;
    }

    @Override
    public ByteBuffer decompose(Object ... objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!(previous instanceof DynamicCompositeType)) {
            return false;
        }
        DynamicCompositeType cp = (DynamicCompositeType)previous;
        if (this.aliases.size() < cp.aliases.size()) {
            return false;
        }
        for (Map.Entry<Byte, AbstractType<?>> entry : cp.aliases.entrySet()) {
            AbstractType<?> tprev = entry.getValue();
            AbstractType<?> tnew = this.aliases.get(entry.getKey());
            if (tnew != null && tnew == tprev) continue;
            return false;
        }
        return true;
    }

    @Override
    public <V> boolean referencesUserType(V name, ValueAccessor<V> accessor) {
        return Iterables.any(this.aliases.values(), t -> t.referencesUserType(name, accessor));
    }

    public DynamicCompositeType withUpdatedUserType(UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        instances.remove(this.aliases);
        return DynamicCompositeType.getInstance(Maps.transformValues(this.aliases, v -> v.withUpdatedUserType(udt)));
    }

    @Override
    public AbstractType<?> expandUserTypes() {
        return DynamicCompositeType.getInstance(Maps.transformValues(this.aliases, v -> v.expandUserTypes()));
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyAliasesParameters(this.aliases);
    }

    @VisibleForTesting
    public static class FixedValueComparator
    extends AbstractType<Void> {
        public static final FixedValueComparator alwaysLesserThan = new FixedValueComparator(-1);
        public static final FixedValueComparator alwaysGreaterThan = new FixedValueComparator(1);
        private final int cmp;

        public FixedValueComparator(int cmp) {
            super(AbstractType.ComparisonType.CUSTOM);
            this.cmp = cmp;
        }

        @Override
        public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
            return this.cmp;
        }

        @Override
        public <V> Void compose(V value, ValueAccessor<V> accessor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer decompose(Void value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> String getString(V value, ValueAccessor<V> accessor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer fromString(String str) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Term fromJSONObject(Object parsed) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void validate(ByteBuffer bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeSerializer<Void> getSerializer() {
            throw new UnsupportedOperationException();
        }
    }

    private class DynamicParsedComparator
    implements AbstractCompositeType.ParsedComparator {
        final AbstractType<?> type;
        final boolean isAlias;
        final String comparatorName;
        final String remainingPart;

        DynamicParsedComparator(String part) {
            String[] splits = part.split("@");
            if (splits.length != 2) {
                throw new IllegalArgumentException("Invalid component representation: " + part);
            }
            this.comparatorName = splits[0];
            this.remainingPart = splits[1];
            try {
                AbstractType<?> t = null;
                if (this.comparatorName.length() == 1) {
                    t = DynamicCompositeType.this.aliases.get((byte)this.comparatorName.charAt(0));
                }
                boolean bl = this.isAlias = t != null;
                if (!this.isAlias) {
                    t = TypeParser.parse(this.comparatorName);
                }
                this.type = t;
            }
            catch (ConfigurationException | SyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public AbstractType<?> getAbstractType() {
            return this.type;
        }

        @Override
        public String getRemainingPart() {
            return this.remainingPart;
        }

        @Override
        public int getComparatorSerializedSize() {
            return this.isAlias ? 2 : 2 + ByteBufferUtil.bytes(this.comparatorName).remaining();
        }

        @Override
        public void serializeComparator(ByteBuffer bb) {
            int header = 0;
            header = this.isAlias ? 0x8000 | (byte)this.comparatorName.charAt(0) & 0xFF : this.comparatorName.length();
            ByteBufferUtil.writeShortLength(bb, header);
            if (!this.isAlias) {
                bb.put(ByteBufferUtil.bytes(this.comparatorName));
            }
        }
    }

    public static class Serializer
    extends BytesSerializer {
        private final Map<Byte, AbstractType<?>> aliases;

        public Serializer(Map<Byte, AbstractType<?>> aliases) {
            this.aliases = aliases;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Serializer that = (Serializer)o;
            return this.aliases.equals(that.aliases);
        }

        public int hashCode() {
            return Objects.hash(this.aliases);
        }
    }
}

