/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.nmoncho.shaded.com.google.common.collect.ImmutableList;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import net.nmoncho.shaded.com.google.common.collect.Lists;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.BytesSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CompositeType
extends AbstractCompositeType {
    private static final int STATIC_MARKER = 65535;
    public final List<AbstractType<?>> types;
    private final Serializer serializer;
    private static final ConcurrentMap<List<AbstractType<?>>, CompositeType> instances = new ConcurrentHashMap();

    public static CompositeType getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        return CompositeType.getInstance(parser.getTypeParameters());
    }

    public static CompositeType getInstance(Iterable<AbstractType<?>> types) {
        return CompositeType.getInstance(Lists.newArrayList(types));
    }

    public static CompositeType getInstance(AbstractType ... types) {
        return CompositeType.getInstance(Arrays.asList(types));
    }

    protected static int startingOffsetInternal(boolean isStatic) {
        return isStatic ? 2 : 0;
    }

    @Override
    protected int startingOffset(boolean isStatic) {
        return CompositeType.startingOffsetInternal(isStatic);
    }

    protected static <V> boolean readIsStaticInternal(V value, ValueAccessor<V> accessor) {
        if (accessor.size(value) < 2) {
            return false;
        }
        short header = accessor.getShort(value, 0);
        return (header & 0xFFFF) == 65535;
    }

    @Override
    protected <V> boolean readIsStatic(V value, ValueAccessor<V> accessor) {
        return CompositeType.readIsStaticInternal(value, accessor);
    }

    private static boolean readStatic(ByteBuffer bb) {
        if (bb.remaining() < 2) {
            return false;
        }
        int header = ByteBufferUtil.getShortLength(bb, bb.position());
        if ((header & 0xFFFF) != 65535) {
            return false;
        }
        ByteBufferUtil.readShortLength(bb);
        return true;
    }

    public static CompositeType getInstance(List<AbstractType<?>> types) {
        assert (types != null && !types.isEmpty());
        CompositeType t = (CompositeType)instances.get(types);
        return null == t ? instances.computeIfAbsent(types, CompositeType::new) : t;
    }

    protected CompositeType(List<AbstractType<?>> types) {
        this.types = ImmutableList.copyOf(types);
        this.serializer = new Serializer(this.types);
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return this.serializer;
    }

    @Override
    protected <V> AbstractType<?> getComparator(int i, V value, ValueAccessor<V> accessor, int offset) {
        try {
            return this.types.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Cannot get comparator " + i + " in " + this + ". This might due to a mismatch between the schema and the data read", e);
        }
    }

    @Override
    protected <VL, VR> AbstractType<?> getComparator(int i, VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR, int offsetL, int offsetR) {
        return this.getComparator(i, left, accessorL, offsetL);
    }

    @Override
    protected <V> AbstractType<?> getAndAppendComparator(int i, V value, ValueAccessor<V> accessor, StringBuilder sb, int offset) {
        return this.types.get(i);
    }

    @Override
    protected AbstractCompositeType.ParsedComparator parseComparator(int i, String part) {
        return new StaticParsedComparator(this.types.get(i), part);
    }

    @Override
    protected <V> AbstractType<?> validateComparator(int i, V value, ValueAccessor<V> accessor, int offset) throws MarshalException {
        if (i >= this.types.size()) {
            throw new MarshalException("Too many bytes for comparator");
        }
        return this.types.get(i);
    }

    @Override
    protected <V> int getComparatorSize(int i, V value, ValueAccessor<V> accessor, int offset) {
        return 0;
    }

    @Override
    public ByteBuffer decompose(Object ... objects) {
        assert (objects.length == this.types.size());
        ByteBuffer[] serialized = new ByteBuffer[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ByteBuffer buffer;
            serialized[i] = buffer = this.types.get(i).decompose(objects[i]);
        }
        return CompositeType.build(ByteBufferAccessor.instance, serialized);
    }

    @Override
    public ByteBuffer[] split(ByteBuffer name) {
        ByteBuffer[] l = new ByteBuffer[this.types.size()];
        ByteBuffer bb = name.duplicate();
        CompositeType.readStatic(bb);
        int i = 0;
        while (bb.remaining() > 0) {
            l[i++] = ByteBufferUtil.readBytesWithShortLength(bb);
            bb.get();
        }
        return i == l.length ? l : Arrays.copyOfRange(l, 0, i);
    }

    public static <V> List<V> splitName(V name, ValueAccessor<V> accessor) {
        ArrayList<V> l = new ArrayList<V>();
        boolean isStatic = CompositeType.readIsStaticInternal(name, accessor);
        int offset = CompositeType.startingOffsetInternal(isStatic);
        while (!accessor.isEmptyFromOffset(name, offset)) {
            V value = accessor.sliceWithShortLength(name, offset);
            offset += accessor.sizeWithShortLength(value);
            l.add(value);
            ++offset;
        }
        return l;
    }

    public static ByteBuffer extractComponent(ByteBuffer bb, int idx) {
        bb = bb.duplicate();
        CompositeType.readStatic(bb);
        int i = 0;
        while (bb.remaining() > 0) {
            ByteBuffer c = ByteBufferUtil.readBytesWithShortLength(bb);
            if (i == idx) {
                return c;
            }
            bb.get();
            ++i;
        }
        return null;
    }

    public static <V> boolean isStaticName(V value, ValueAccessor<V> accessor) {
        return accessor.size(value) >= 2 && (accessor.getUnsignedShort(value, 0) & 0xFFFF) == 65535;
    }

    @Override
    public List<AbstractType<?>> getComponents() {
        return this.types;
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!(previous instanceof CompositeType)) {
            return false;
        }
        CompositeType cp = (CompositeType)previous;
        if (this.types.size() < cp.types.size()) {
            return false;
        }
        for (int i = 0; i < cp.types.size(); ++i) {
            AbstractType<?> tprev = cp.types.get(i);
            AbstractType<?> tnew = this.types.get(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        if (this == otherType) {
            return true;
        }
        if (!(otherType instanceof CompositeType)) {
            return false;
        }
        CompositeType cp = (CompositeType)otherType;
        if (this.types.size() < cp.types.size()) {
            return false;
        }
        for (int i = 0; i < cp.types.size(); ++i) {
            AbstractType<?> tprev = cp.types.get(i);
            AbstractType<?> tnew = this.types.get(i);
            if (tnew.isValueCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <V> boolean referencesUserType(V name, ValueAccessor<V> accessor) {
        return Iterables.any(this.types, t -> t.referencesUserType(name, accessor));
    }

    public CompositeType withUpdatedUserType(UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        instances.remove(this.types);
        return CompositeType.getInstance(Iterables.transform(this.types, t -> t.withUpdatedUserType(udt)));
    }

    @Override
    public AbstractType<?> expandUserTypes() {
        return CompositeType.getInstance(Iterables.transform(this.types, AbstractType::expandUserTypes));
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyTypeParameters(this.types);
    }

    @SafeVarargs
    public static <V> V build(ValueAccessor<V> accessor, V ... values) {
        return CompositeType.build(accessor, false, values);
    }

    @SafeVarargs
    public static <V> V build(ValueAccessor<V> accessor, boolean isStatic, V ... values) {
        int totalLength = isStatic ? 2 : 0;
        for (V v : values) {
            totalLength += 2 + accessor.size(v) + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        if (isStatic) {
            out.putShort((short)-1);
        }
        for (V v : values) {
            ByteBufferUtil.writeShortLength(out, accessor.size(v));
            accessor.write(v, out);
            out.put((byte)0);
        }
        out.flip();
        return accessor.valueOf(out);
    }

    private static class StaticParsedComparator
    implements AbstractCompositeType.ParsedComparator {
        final AbstractType<?> type;
        final String part;

        StaticParsedComparator(AbstractType<?> type, String part) {
            this.type = type;
            this.part = part;
        }

        @Override
        public AbstractType<?> getAbstractType() {
            return this.type;
        }

        @Override
        public String getRemainingPart() {
            return this.part;
        }

        @Override
        public int getComparatorSerializedSize() {
            return 0;
        }

        @Override
        public void serializeComparator(ByteBuffer bb) {
        }
    }

    private static class Serializer
    extends BytesSerializer {
        public final List<AbstractType<?>> types;

        public Serializer(List<AbstractType<?>> types) {
            this.types = types;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Serializer that = (Serializer)o;
            return this.types.equals(that.types);
        }

        public int hashCode() {
            return Objects.hash(this.types);
        }
    }
}

