/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Interval;
import org.apache.cassandra.utils.IntervalTree;

public class SSTableIntervalTree
extends IntervalTree<PartitionPosition, SSTableReader, Interval<PartitionPosition, SSTableReader>> {
    private static final SSTableIntervalTree EMPTY = new SSTableIntervalTree(null);

    SSTableIntervalTree(Collection<Interval<PartitionPosition, SSTableReader>> intervals) {
        super(intervals);
    }

    public static SSTableIntervalTree empty() {
        return EMPTY;
    }

    public static SSTableIntervalTree build(Iterable<SSTableReader> sstables) {
        return new SSTableIntervalTree((Collection<Interval<PartitionPosition, SSTableReader>>)SSTableIntervalTree.buildIntervals(sstables));
    }

    public static List<Interval<PartitionPosition, SSTableReader>> buildIntervals(Iterable<SSTableReader> sstables) {
        ArrayList<Interval<PartitionPosition, SSTableReader>> intervals = new ArrayList<Interval<PartitionPosition, SSTableReader>>(Iterables.size(sstables));
        for (SSTableReader sstable : sstables) {
            intervals.add(Interval.create(sstable.first, sstable.last, sstable));
        }
        return intervals;
    }
}

