/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import com.codahale.metrics.Counter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.util.concurrent.Runnables;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LogFile;
import org.apache.cassandra.db.lifecycle.LogRecord;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogTransaction
extends Transactional.AbstractTransactional
implements Transactional {
    private static final Logger logger = LoggerFactory.getLogger(LogTransaction.class);
    private final Tracker tracker;
    private final LogFile txnFile;
    private final Object lock;
    private final Ref<LogTransaction> selfRef;
    private static final Queue<Runnable> failedDeletions = new ConcurrentLinkedQueue<Runnable>();

    LogTransaction(OperationType opType) {
        this(opType, null);
    }

    LogTransaction(OperationType opType, Tracker tracker) {
        this.tracker = tracker;
        this.txnFile = new LogFile(opType, TimeUUID.Generator.nextTimeUUID());
        this.lock = new Object();
        this.selfRef = new Ref<LogTransaction>(this, new TransactionTidier(this.txnFile, this.lock));
        if (logger.isTraceEnabled()) {
            logger.trace("Created transaction logs with id {}", (Object)this.txnFile.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackNew(SSTable table) {
        Object object = this.lock;
        synchronized (object) {
            if (logger.isTraceEnabled()) {
                logger.trace("Track NEW sstable {} in {}", (Object)table.getFilename(), (Object)this.txnFile.toString());
            }
            this.txnFile.add(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void untrackNew(SSTable table) {
        Object object = this.lock;
        synchronized (object) {
            this.txnFile.remove(table);
        }
    }

    @VisibleForTesting
    SSTableTidier obsoleted(SSTableReader sstable) {
        return this.obsoleted(sstable, LogRecord.make(LogRecord.Type.REMOVE, sstable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSTableTidier obsoleted(SSTableReader reader, LogRecord logRecord) {
        Object object = this.lock;
        synchronized (object) {
            if (logger.isTraceEnabled()) {
                logger.trace("Track OLD sstable {} in {}", (Object)reader.getFilename(), (Object)this.txnFile.toString());
            }
            if (this.txnFile.contains(LogRecord.Type.ADD, reader, logRecord)) {
                if (this.txnFile.contains(LogRecord.Type.REMOVE, reader, logRecord)) {
                    throw new IllegalArgumentException();
                }
                return new SSTableTidier(reader, true, this);
            }
            this.txnFile.addRecord(logRecord);
            if (this.tracker != null) {
                this.tracker.notifyDeleting(reader);
            }
            return new SSTableTidier(reader, false, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<SSTable, LogRecord> makeRemoveRecords(Iterable<SSTableReader> sstables) {
        Object object = this.lock;
        synchronized (object) {
            return this.txnFile.makeRecords(LogRecord.Type.REMOVE, sstables);
        }
    }

    OperationType type() {
        return this.txnFile.type();
    }

    TimeUUID id() {
        return this.txnFile.id();
    }

    @VisibleForTesting
    LogFile txnFile() {
        return this.txnFile;
    }

    @VisibleForTesting
    List<File> logFiles() {
        return this.txnFile.getFiles();
    }

    @VisibleForTesting
    List<String> logFilePaths() {
        return this.txnFile.getFilePaths();
    }

    static void delete(File file) {
        block18: {
            try {
                if (!StorageService.instance.isDaemonSetupCompleted()) {
                    logger.info("Unfinished transaction log, deleting {} ", (Object)file);
                } else if (logger.isTraceEnabled()) {
                    logger.trace("Deleting {}", (Object)file);
                }
                Files.delete(file.toPath());
            }
            catch (NoSuchFileException e) {
                logger.error("Unable to delete {} as it does not exist, see debug log file for stack trace", (Object)file);
                if (!logger.isDebugEnabled()) break block18;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (PrintStream ps = new PrintStream(baos);){
                    e.printStackTrace(ps);
                }
                logger.debug("Unable to delete {} as it does not exist, stack trace:\n {}", (Object)file, (Object)baos);
            }
            catch (IOException e) {
                logger.error("Unable to delete {}", (Object)file, (Object)e);
                FileUtils.handleFSErrorAndPropagate(new FSWriteError((Throwable)e, file));
            }
        }
    }

    static void rescheduleFailedDeletions() {
        Runnable task;
        while (null != (task = failedDeletions.poll())) {
            ScheduledExecutors.nonPeriodicTasks.submit(task);
        }
    }

    static void waitForDeletions() {
        FBUtilities.waitOnFuture(ScheduledExecutors.nonPeriodicTasks.schedule(Runnables.doNothing(), 0L, TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    Throwable complete(Throwable accumulate) {
        if (logger.isTraceEnabled()) {
            logger.trace("Completing txn {} with last record {}", (Object)this.txnFile.toString(), (Object)this.txnFile.getLastRecord());
        }
        try {
            accumulate = this.selfRef.ensureReleased(accumulate);
            return accumulate;
        }
        catch (Throwable t) {
            logger.error("Failed to complete file transaction id {}", (Object)this.id(), (Object)t);
            return Throwables.merge(accumulate, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Throwable doCommit(Throwable accumulate) {
        Object object = this.lock;
        synchronized (object) {
            Throwables.DiscreteAction[] discreteActionArray = new Throwables.DiscreteAction[1];
            discreteActionArray[0] = this.txnFile::commit;
            return this.complete(Throwables.perform(accumulate, discreteActionArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Throwable doAbort(Throwable accumulate) {
        Object object = this.lock;
        synchronized (object) {
            Throwables.DiscreteAction[] discreteActionArray = new Throwables.DiscreteAction[1];
            discreteActionArray[0] = this.txnFile::abort;
            return this.complete(Throwables.perform(accumulate, discreteActionArray));
        }
    }

    @Override
    protected void doPrepare() {
    }

    static boolean removeUnfinishedLeftovers(TableMetadata metadata) {
        return LogTransaction.removeUnfinishedLeftovers(new Directories(metadata).getCFDirectories());
    }

    @VisibleForTesting
    static boolean removeUnfinishedLeftovers(List<File> directories) {
        LogFilesByName logFiles = new LogFilesByName();
        directories.forEach(logFiles::list);
        return logFiles.removeUnfinishedLeftovers();
    }

    private static final class LogFilesByName {
        Map<String, List<File>> files = new HashMap<String, List<File>>();

        private LogFilesByName() {
        }

        void list(File directory) {
            Arrays.stream(directory.tryList(LogFile::isLogFile)).forEach(this::add);
        }

        void add(File file) {
            List<File> filesByName = this.files.get(file.name());
            if (filesByName == null) {
                filesByName = new ArrayList<File>();
                this.files.put(file.name(), filesByName);
            }
            filesByName.add(file);
        }

        boolean removeUnfinishedLeftovers() {
            return this.files.entrySet().stream().map(LogFilesByName::removeUnfinishedLeftovers).allMatch(Predicate.isEqual(true));
        }

        static boolean removeUnfinishedLeftovers(Map.Entry<String, List<File>> entry) {
            try (LogFile txn = LogFile.make(entry.getKey(), entry.getValue());){
                logger.info("Verifying logfile transaction {}", (Object)txn);
                if (txn.verify()) {
                    Throwable failure = txn.removeUnfinishedLeftovers(null);
                    if (failure != null) {
                        logger.error("Failed to remove unfinished transaction leftovers for transaction log {}", (Object)txn.toString(true), (Object)failure);
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                logger.error("Unexpected disk state: failed to read transaction log {}", (Object)txn.toString(true));
                boolean bl = false;
                return bl;
            }
        }
    }

    public static class SSTableTidier
    implements Runnable {
        private final Descriptor desc;
        private final long sizeOnDisk;
        private final boolean wasNew;
        private final Object lock;
        private final Ref<LogTransaction> parentRef;
        private final Counter totalDiskSpaceUsed;

        public SSTableTidier(SSTableReader referent, boolean wasNew, LogTransaction parent) {
            this.desc = referent.descriptor;
            this.sizeOnDisk = referent.bytesOnDisk();
            this.wasNew = wasNew;
            this.lock = parent.lock;
            this.parentRef = parent.selfRef.tryRef();
            if (this.parentRef == null) {
                throw new IllegalStateException("Transaction already completed");
            }
            this.totalDiskSpaceUsed = parent.tracker != null && ((LogTransaction)parent).tracker.cfstore != null ? ((LogTransaction)parent).tracker.cfstore.metric.totalDiskSpaceUsed : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (DatabaseDescriptor.isDaemonInitialized()) {
                SystemKeyspace.clearSSTableReadMeter(this.desc.ksname, this.desc.cfname, this.desc.id);
            }
            Object object = this.lock;
            synchronized (object) {
                try {
                    File datafile = new File(this.desc.filenameFor(Component.DATA));
                    if (logger.isTraceEnabled()) {
                        logger.trace("Tidier running for old sstable {}", (Object)this.desc.baseFilename());
                    }
                    if (datafile.exists()) {
                        LogTransaction.delete(datafile);
                    } else if (!this.wasNew) {
                        logger.error("SSTableTidier ran with no existing data file for an sstable that was not new");
                    }
                    SSTable.delete(this.desc, SSTable.discoverComponentsFor(this.desc));
                }
                catch (Throwable t) {
                    logger.error("Failed deletion for {}, we'll retry after GC and on server restart", (Object)this.desc);
                    failedDeletions.add(this);
                    return;
                }
                if (DatabaseDescriptor.isDaemonInitialized() && this.totalDiskSpaceUsed != null && !this.wasNew) {
                    this.totalDiskSpaceUsed.dec(this.sizeOnDisk);
                }
                this.parentRef.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            Object object = this.lock;
            synchronized (object) {
                this.parentRef.release();
            }
        }
    }

    static class Obsoletion {
        final SSTableReader reader;
        final SSTableTidier tidier;

        Obsoletion(SSTableReader reader, SSTableTidier tidier) {
            this.reader = reader;
            this.tidier = tidier;
        }
    }

    private static class TransactionTidier
    implements RefCounted.Tidy,
    Runnable {
        private final LogFile data;
        private final Object lock;

        TransactionTidier(LogFile data, Object lock) {
            this.data = data;
            this.lock = lock;
        }

        @Override
        public void tidy() {
            this.run();
        }

        @Override
        public String name() {
            return this.data.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                Throwable err;
                if (logger.isTraceEnabled()) {
                    logger.trace("Removing files for transaction {}", (Object)this.name());
                }
                if (!this.data.completed()) {
                    logger.error("{} was not completed, trying to abort it now", (Object)this.data);
                    Throwables.DiscreteAction[] discreteActionArray = new Throwables.DiscreteAction[1];
                    discreteActionArray[0] = this.data::abort;
                    err = Throwables.perform((Throwable)null, discreteActionArray);
                    if (err != null) {
                        logger.error("Failed to abort {}", (Object)this.data, (Object)err);
                    }
                }
                if ((err = this.data.removeUnfinishedLeftovers(null)) != null) {
                    logger.info("Failed deleting files for transaction {}, we'll retry after GC and on on server restart", (Object)this.name(), (Object)err);
                    failedDeletions.add(this);
                } else {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Closing file transaction {}", (Object)this.name());
                    }
                    this.data.close();
                }
            }
        }
    }

    public static final class CorruptTransactionLogException
    extends RuntimeException {
        public final LogFile txnFile;

        public CorruptTransactionLogException(String message, LogFile txnFile) {
            super(message);
            this.txnFile = txnFile;
        }
    }
}

