/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import net.nmoncho.shaded.com.google.common.collect.SortedSetMultimap;
import net.nmoncho.shaded.com.google.common.collect.TreeMultimap;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnSubselection;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.CassandraVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ColumnFilter {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFilter.class);
    public static final ColumnFilter NONE = ColumnFilter.selection(RegularAndStaticColumns.NONE);
    public static final Serializer serializer = new Serializer();

    private static boolean isUpgradingFromVersionLowerThan40RC2() {
        if (Gossiper.instance.isUpgradingFromVersionLowerThan(CassandraVersion.CASSANDRA_4_0_RC2)) {
            logger.trace("ColumnFilter conversion has been applied so that static columns will not be fetched because there are pre 4.0-rc2 nodes in the cluster");
            return true;
        }
        return false;
    }

    private static boolean isUpgradingFromVersionLowerThan40() {
        if (Gossiper.instance.isUpgradingFromVersionLowerThan(CassandraVersion.CASSANDRA_4_0)) {
            logger.trace("ColumnFilter conversion has been applied so that all static columns will be fetched because there are pre 4.0 nodes in the cluster");
            return true;
        }
        return false;
    }

    private static boolean isUpgradingFromVersionLowerThan34() {
        if (Gossiper.instance.isUpgradingFromVersionLowerThan(CassandraVersion.CASSANDRA_3_4)) {
            logger.trace("ColumnFilter conversion has been applied so that all columns will be queried because there are pre 3.4 nodes in the cluster");
            return true;
        }
        return false;
    }

    public static ColumnFilter all(TableMetadata metadata) {
        return new WildCardColumnFilter(metadata.regularAndStaticColumns());
    }

    public static ColumnFilter selection(RegularAndStaticColumns columns) {
        return SelectionColumnFilter.newInstance(FetchingStrategy.ONLY_QUERIED_COLUMNS, null, columns, null);
    }

    public static ColumnFilter selection(TableMetadata metadata, RegularAndStaticColumns queried, boolean returnStaticContentOnPartitionWithNoRows) {
        if (ColumnFilter.isUpgradingFromVersionLowerThan34()) {
            return new WildCardColumnFilter(metadata.regularAndStaticColumns());
        }
        if (ColumnFilter.isUpgradingFromVersionLowerThan40()) {
            return SelectionColumnFilter.newInstance(FetchingStrategy.ALL_COLUMNS, metadata, queried, null);
        }
        if (!returnStaticContentOnPartitionWithNoRows || ColumnFilter.isUpgradingFromVersionLowerThan40RC2()) {
            return SelectionColumnFilter.newInstance(FetchingStrategy.ALL_REGULARS_AND_QUERIED_STATICS_COLUMNS, metadata, queried, null);
        }
        return SelectionColumnFilter.newInstance(FetchingStrategy.ALL_COLUMNS, metadata, queried, null);
    }

    public abstract RegularAndStaticColumns fetchedColumns();

    public abstract RegularAndStaticColumns queriedColumns();

    public abstract boolean fetchesAllColumns(boolean var1);

    public abstract boolean allFetchedColumnsAreQueried();

    public abstract boolean fetches(ColumnMetadata var1);

    public abstract boolean fetchedColumnIsQueried(ColumnMetadata var1);

    public abstract boolean fetchedCellIsQueried(ColumnMetadata var1, CellPath var2);

    @Nullable
    public abstract Tester newTester(ColumnMetadata var1);

    public boolean isWildcard() {
        return false;
    }

    public abstract String toCQLString();

    protected abstract SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections();

    public static Builder allRegularColumnsBuilder(TableMetadata metadata, boolean returnStaticContentOnPartitionWithNoRows) {
        return new Builder(metadata, returnStaticContentOnPartitionWithNoRows);
    }

    public static Builder selectionBuilder() {
        return new Builder(null, false);
    }

    public static class Serializer {
        private static final int FETCH_ALL_MASK = 1;
        private static final int HAS_QUERIED_MASK = 2;
        private static final int HAS_SUB_SELECTIONS_MASK = 4;
        private static final int FETCH_ALL_STATICS_MASK = 8;

        private static int makeHeaderByte(ColumnFilter selection) {
            return (selection.fetchesAllColumns(false) ? 1 : 0) | (!selection.isWildcard() ? 2 : 0) | (selection.subSelections() != null ? 4 : 0) | (selection.fetchesAllColumns(true) ? 8 : 0);
        }

        public void serialize(ColumnFilter selection, DataOutputPlus out, int version) throws IOException {
            out.writeByte(Serializer.makeHeaderByte(selection));
            if (version >= 11 && selection.fetchesAllColumns(false)) {
                this.serializeRegularAndStaticColumns(selection.fetchedColumns(), out);
            }
            if (!selection.isWildcard()) {
                this.serializeRegularAndStaticColumns(selection.queriedColumns(), out);
            }
            this.serializeSubSelections(selection.subSelections(), out, version);
        }

        private void serializeSubSelections(SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections, DataOutputPlus out, int version) throws IOException {
            if (subSelections != null) {
                out.writeUnsignedVInt(subSelections.size());
                for (ColumnSubselection subSel : subSelections.values()) {
                    ColumnSubselection.serializer.serialize(subSel, out, version);
                }
            }
        }

        private void serializeRegularAndStaticColumns(RegularAndStaticColumns regularAndStaticColumns, DataOutputPlus out) throws IOException {
            Columns.serializer.serialize(regularAndStaticColumns.statics, out);
            Columns.serializer.serialize(regularAndStaticColumns.regulars, out);
        }

        public ColumnFilter deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            int header = in.readUnsignedByte();
            boolean isFetchAll = (header & 1) != 0;
            boolean hasQueried = (header & 2) != 0;
            boolean hasSubSelections = (header & 4) != 0;
            boolean isFetchAllStatics = (header & 8) != 0;
            RegularAndStaticColumns fetched = null;
            RegularAndStaticColumns queried = null;
            if (isFetchAll) {
                fetched = version >= 11 ? this.deserializeRegularAndStaticColumns(in, metadata) : metadata.regularAndStaticColumns();
            }
            if (hasQueried) {
                queried = this.deserializeRegularAndStaticColumns(in, metadata);
            }
            SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections = null;
            if (hasSubSelections) {
                subSelections = this.deserializeSubSelection(in, version, metadata);
            }
            if (isFetchAll) {
                if (!hasQueried || ColumnFilter.isUpgradingFromVersionLowerThan34()) {
                    return new WildCardColumnFilter(fetched);
                }
                if (ColumnFilter.isUpgradingFromVersionLowerThan40()) {
                    return new SelectionColumnFilter(FetchingStrategy.ALL_COLUMNS, queried, fetched, subSelections);
                }
                if (!isFetchAllStatics || ColumnFilter.isUpgradingFromVersionLowerThan40RC2()) {
                    return new SelectionColumnFilter(FetchingStrategy.ALL_REGULARS_AND_QUERIED_STATICS_COLUMNS, queried, fetched, subSelections);
                }
                return new SelectionColumnFilter(FetchingStrategy.ALL_COLUMNS, queried, fetched, subSelections);
            }
            return new SelectionColumnFilter(FetchingStrategy.ONLY_QUERIED_COLUMNS, queried, queried, subSelections);
        }

        private RegularAndStaticColumns deserializeRegularAndStaticColumns(DataInputPlus in, TableMetadata metadata) throws IOException {
            Columns statics = Columns.serializer.deserialize(in, metadata);
            Columns regulars = Columns.serializer.deserialize(in, metadata);
            return new RegularAndStaticColumns(statics, regulars);
        }

        private SortedSetMultimap<ColumnIdentifier, ColumnSubselection> deserializeSubSelection(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            TreeMultimap<ColumnIdentifier, ColumnSubselection> subSelections = TreeMultimap.create(Comparator.naturalOrder(), Comparator.naturalOrder());
            int size = (int)in.readUnsignedVInt();
            for (int i = 0; i < size; ++i) {
                ColumnSubselection subSel = ColumnSubselection.serializer.deserialize(in, version, metadata);
                subSelections.put(subSel.column().name, subSel);
            }
            return subSelections;
        }

        public long serializedSize(ColumnFilter selection, int version) {
            long size = 1L;
            if (version >= 11 && selection.fetchesAllColumns(false)) {
                size += this.regularAndStaticColumnsSerializedSize(selection.fetchedColumns());
            }
            if (!selection.isWildcard()) {
                size += this.regularAndStaticColumnsSerializedSize(selection.queriedColumns());
            }
            return size += this.subSelectionsSerializedSize(selection.subSelections(), version);
        }

        private long regularAndStaticColumnsSerializedSize(RegularAndStaticColumns columns) {
            return Columns.serializer.serializedSize(columns.statics) + Columns.serializer.serializedSize(columns.regulars);
        }

        private long subSelectionsSerializedSize(SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections, int version) {
            if (subSelections == null) {
                return 0L;
            }
            int size = TypeSizes.sizeofUnsignedVInt(subSelections.size());
            for (ColumnSubselection subSel : subSelections.values()) {
                size = (int)((long)size + ColumnSubselection.serializer.serializedSize(subSel, version));
            }
            return size;
        }
    }

    public static class SelectionColumnFilter
    extends ColumnFilter {
        public final FetchingStrategy fetchingStrategy;
        private final RegularAndStaticColumns queried;
        private final RegularAndStaticColumns fetched;
        private final SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections;

        public static SelectionColumnFilter newInstance(FetchingStrategy fetchingStrategy, TableMetadata metadata, RegularAndStaticColumns queried, SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections) {
            assert (fetchingStrategy != FetchingStrategy.ONLY_QUERIED_COLUMNS || metadata == null);
            assert (queried != null);
            return new SelectionColumnFilter(fetchingStrategy, queried, fetchingStrategy.getFetchedColumns(metadata, queried), subSelections);
        }

        public SelectionColumnFilter(FetchingStrategy fetchingStrategy, RegularAndStaticColumns queried, RegularAndStaticColumns fetched, SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections) {
            assert (queried != null);
            assert (fetched.includes(queried));
            this.fetchingStrategy = fetchingStrategy;
            this.queried = queried;
            this.fetched = fetched;
            this.subSelections = subSelections;
        }

        @Override
        public RegularAndStaticColumns fetchedColumns() {
            return this.fetched;
        }

        @Override
        public RegularAndStaticColumns queriedColumns() {
            return this.queried;
        }

        @Override
        public boolean fetchesAllColumns(boolean isStatic) {
            return this.fetchingStrategy.fetchesAllColumns(isStatic);
        }

        @Override
        public boolean allFetchedColumnsAreQueried() {
            return this.fetchingStrategy.areAllFetchedColumnsQueried();
        }

        @Override
        public boolean fetches(ColumnMetadata column) {
            return this.fetchingStrategy.fetchesAllColumns(column.isStatic()) || this.fetched.contains(column);
        }

        @Override
        public boolean fetchedColumnIsQueried(ColumnMetadata column) {
            return this.fetchingStrategy.areAllFetchedColumnsQueried() || this.queried.contains(column);
        }

        @Override
        public boolean fetchedCellIsQueried(ColumnMetadata column, CellPath path) {
            assert (path != null);
            if (!this.fetchedColumnIsQueried(column)) {
                return false;
            }
            if (this.subSelections == null) {
                return true;
            }
            Set s = this.subSelections.get((Object)column.name);
            if (s.isEmpty()) {
                return true;
            }
            for (ColumnSubselection subSel : s) {
                if (subSel.compareInclusionOf(path) != 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public Tester newTester(ColumnMetadata column) {
            if (this.subSelections == null || !column.isComplex()) {
                return null;
            }
            Set s = this.subSelections.get((Object)column.name);
            if (s.isEmpty()) {
                return null;
            }
            return new Tester(this.fetchingStrategy.fetchesAllColumns(column.isStatic()), s.iterator());
        }

        @Override
        protected SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections() {
            return this.subSelections;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof SelectionColumnFilter)) {
                return false;
            }
            SelectionColumnFilter otherCf = (SelectionColumnFilter)other;
            return otherCf.fetchingStrategy == this.fetchingStrategy && Objects.equals(otherCf.queried, this.queried) && Objects.equals(otherCf.fetched, this.fetched) && Objects.equals(otherCf.subSelections, this.subSelections);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.fetchingStrategy, this.queried, this.fetched, this.subSelections});
        }

        public String toString() {
            String prefix = "";
            if (this.fetchingStrategy.fetchesAllColumns(true)) {
                prefix = "*/";
            }
            if (this.fetchingStrategy == FetchingStrategy.ALL_REGULARS_AND_QUERIED_STATICS_COLUMNS) {
                prefix = this.queried.statics.isEmpty() ? "<all regulars>/" : String.format("<all regulars>+%s/", this.toString(this.queried.statics.selectOrderIterator(), false));
            }
            return prefix + this.toString(this.queried.selectOrderIterator(), false);
        }

        @Override
        public String toCQLString() {
            return this.queried.isEmpty() ? "*" : this.toString(this.queried.selectOrderIterator(), true);
        }

        private String toString(Iterator<ColumnMetadata> columns, boolean cql) {
            StringJoiner joiner;
            StringJoiner stringJoiner = joiner = cql ? new StringJoiner(", ") : new StringJoiner(", ", "[", "]");
            while (columns.hasNext()) {
                SortedSet s;
                ColumnMetadata column = columns.next();
                String columnName = cql ? column.name.toCQLString() : String.valueOf(column.name);
                Set set = s = this.subSelections != null ? this.subSelections.get((Object)column.name) : Collections.emptySortedSet();
                if (s.isEmpty()) {
                    joiner.add(columnName);
                    continue;
                }
                s.forEach(subSel -> joiner.add(String.format("%s%s", columnName, subSel.toString(cql))));
            }
            return joiner.toString();
        }
    }

    public static class WildCardColumnFilter
    extends ColumnFilter {
        private final RegularAndStaticColumns fetchedAndQueried;

        private WildCardColumnFilter(RegularAndStaticColumns fetchedAndQueried) {
            this.fetchedAndQueried = fetchedAndQueried;
        }

        @Override
        public RegularAndStaticColumns fetchedColumns() {
            return this.fetchedAndQueried;
        }

        @Override
        public RegularAndStaticColumns queriedColumns() {
            return this.fetchedAndQueried;
        }

        @Override
        public boolean fetchesAllColumns(boolean isStatic) {
            return true;
        }

        @Override
        public boolean allFetchedColumnsAreQueried() {
            return true;
        }

        @Override
        public boolean fetches(ColumnMetadata column) {
            return true;
        }

        @Override
        public boolean fetchedColumnIsQueried(ColumnMetadata column) {
            return true;
        }

        @Override
        public boolean fetchedCellIsQueried(ColumnMetadata column, CellPath path) {
            return true;
        }

        @Override
        public Tester newTester(ColumnMetadata column) {
            return null;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof WildCardColumnFilter)) {
                return false;
            }
            WildCardColumnFilter w = (WildCardColumnFilter)other;
            return this.fetchedAndQueried.equals(w.fetchedAndQueried);
        }

        public int hashCode() {
            return Objects.hash(this.fetchedAndQueried);
        }

        public String toString() {
            return "*/*";
        }

        @Override
        public String toCQLString() {
            return "*";
        }

        @Override
        public boolean isWildcard() {
            return true;
        }

        @Override
        protected SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections() {
            return null;
        }
    }

    public static class Builder {
        private final TableMetadata metadata;
        private final boolean returnStaticContentOnPartitionWithNoRows;
        private RegularAndStaticColumns.Builder queriedBuilder;
        private List<ColumnSubselection> subSelections;
        private Set<ColumnMetadata> fullySelectedComplexColumns;

        private Builder(TableMetadata metadata, boolean returnStaticContentOnPartitionWithNoRows) {
            this.metadata = metadata;
            this.returnStaticContentOnPartitionWithNoRows = returnStaticContentOnPartitionWithNoRows;
        }

        public Builder add(ColumnMetadata c) {
            if (c.isComplex() && c.type.isMultiCell()) {
                if (this.fullySelectedComplexColumns == null) {
                    this.fullySelectedComplexColumns = new HashSet<ColumnMetadata>();
                }
                this.fullySelectedComplexColumns.add(c);
            }
            return this.addInternal(c);
        }

        public Builder addAll(Iterable<ColumnMetadata> columns) {
            for (ColumnMetadata column : columns) {
                this.add(column);
            }
            return this;
        }

        private Builder addInternal(ColumnMetadata c) {
            if (c.isPrimaryKeyColumn()) {
                return this;
            }
            if (this.queriedBuilder == null) {
                this.queriedBuilder = RegularAndStaticColumns.builder();
            }
            this.queriedBuilder.add(c);
            return this;
        }

        private Builder addSubSelection(ColumnSubselection subSelection) {
            ColumnMetadata column = subSelection.column();
            assert (column.isComplex() && column.type.isMultiCell());
            this.addInternal(column);
            if (this.subSelections == null) {
                this.subSelections = new ArrayList<ColumnSubselection>();
            }
            this.subSelections.add(subSelection);
            return this;
        }

        public Builder slice(ColumnMetadata c, CellPath from, CellPath to) {
            return this.addSubSelection(ColumnSubselection.slice(c, from, to));
        }

        public Builder select(ColumnMetadata c, CellPath elt) {
            return this.addSubSelection(ColumnSubselection.element(c, elt));
        }

        public ColumnFilter build() {
            RegularAndStaticColumns queried;
            boolean isFetchAll = this.metadata != null;
            RegularAndStaticColumns regularAndStaticColumns = queried = this.queriedBuilder == null ? null : this.queriedBuilder.build();
            if (!isFetchAll && queried == null) {
                queried = RegularAndStaticColumns.NONE;
            }
            SortedSetMultimap<ColumnIdentifier, ColumnSubselection> s = this.buildSubSelections();
            if (isFetchAll) {
                if (queried == null || ColumnFilter.isUpgradingFromVersionLowerThan34()) {
                    return new WildCardColumnFilter(this.metadata.regularAndStaticColumns());
                }
                if (ColumnFilter.isUpgradingFromVersionLowerThan40()) {
                    return SelectionColumnFilter.newInstance(FetchingStrategy.ALL_COLUMNS, this.metadata, queried, s);
                }
                if (!this.returnStaticContentOnPartitionWithNoRows || ColumnFilter.isUpgradingFromVersionLowerThan40RC2()) {
                    return SelectionColumnFilter.newInstance(FetchingStrategy.ALL_REGULARS_AND_QUERIED_STATICS_COLUMNS, this.metadata, queried, s);
                }
                return SelectionColumnFilter.newInstance(FetchingStrategy.ALL_COLUMNS, this.metadata, queried, s);
            }
            return SelectionColumnFilter.newInstance(FetchingStrategy.ONLY_QUERIED_COLUMNS, null, queried, s);
        }

        private SortedSetMultimap<ColumnIdentifier, ColumnSubselection> buildSubSelections() {
            if (this.subSelections == null) {
                return null;
            }
            TreeMultimap<ColumnIdentifier, ColumnSubselection> s = TreeMultimap.create(Comparator.naturalOrder(), Comparator.naturalOrder());
            for (ColumnSubselection subSelection : this.subSelections) {
                if (this.fullySelectedComplexColumns != null && this.fullySelectedComplexColumns.contains(subSelection.column())) continue;
                s.put(subSelection.column().name, subSelection);
            }
            return s;
        }
    }

    public static class Tester {
        private final boolean isFetched;
        private ColumnSubselection current;
        private final Iterator<ColumnSubselection> iterator;

        private Tester(boolean isFetched, Iterator<ColumnSubselection> iterator) {
            this.isFetched = isFetched;
            this.iterator = iterator;
        }

        public boolean fetches(CellPath path) {
            return this.isFetched || this.hasSubselection(path);
        }

        public boolean fetchedCellIsQueried(CellPath path) {
            return !this.isFetched || this.hasSubselection(path);
        }

        private boolean hasSubselection(CellPath path) {
            while (this.current != null || this.iterator.hasNext()) {
                int cmp;
                if (this.current == null) {
                    this.current = this.iterator.next();
                }
                if ((cmp = this.current.compareInclusionOf(path)) == 0) {
                    return true;
                }
                if (cmp < 0) {
                    return false;
                }
                this.current = null;
            }
            return false;
        }
    }

    private static enum FetchingStrategy {
        ALL_COLUMNS{

            @Override
            boolean fetchesAllColumns(boolean isStatic) {
                return true;
            }

            @Override
            RegularAndStaticColumns getFetchedColumns(TableMetadata metadata, RegularAndStaticColumns queried) {
                return metadata.regularAndStaticColumns();
            }
        }
        ,
        ALL_REGULARS_AND_QUERIED_STATICS_COLUMNS{

            @Override
            boolean fetchesAllColumns(boolean isStatic) {
                return !isStatic;
            }

            @Override
            RegularAndStaticColumns getFetchedColumns(TableMetadata metadata, RegularAndStaticColumns queried) {
                return new RegularAndStaticColumns(queried.statics, metadata.regularColumns());
            }
        }
        ,
        ONLY_QUERIED_COLUMNS{

            @Override
            boolean fetchesAllColumns(boolean isStatic) {
                return false;
            }

            @Override
            boolean areAllFetchedColumnsQueried() {
                return true;
            }

            @Override
            RegularAndStaticColumns getFetchedColumns(TableMetadata metadata, RegularAndStaticColumns queried) {
                return queried;
            }
        };


        abstract boolean fetchesAllColumns(boolean var1);

        boolean areAllFetchedColumnsQueried() {
            return false;
        }

        abstract RegularAndStaticColumns getFetchedColumns(TableMetadata var1, RegularAndStaticColumns var2);
    }
}

