/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import java.text.ParseException;
import java.util.Comparator;
import net.nmoncho.shaded.com.google.common.base.Strings;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class CommitLogPosition
implements Comparable<CommitLogPosition> {
    public static final CommitLogPositionSerializer serializer = new CommitLogPositionSerializer();
    public static final CommitLogPosition NONE = new CommitLogPosition(-1L, 0);
    public final long segmentId;
    public final int position;
    public static final Comparator<CommitLogPosition> comparator = new Comparator<CommitLogPosition>(){

        @Override
        public int compare(CommitLogPosition o1, CommitLogPosition o2) {
            if (o1.segmentId != o2.segmentId) {
                return Long.compare(o1.segmentId, o2.segmentId);
            }
            return Integer.compare(o1.position, o2.position);
        }
    };

    public CommitLogPosition(long segmentId, int position) {
        this.segmentId = segmentId;
        assert (position >= 0);
        this.position = position;
    }

    @Override
    public int compareTo(CommitLogPosition other) {
        return comparator.compare(this, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitLogPosition that = (CommitLogPosition)o;
        if (this.position != that.position) {
            return false;
        }
        return this.segmentId == that.segmentId;
    }

    public int hashCode() {
        int result = (int)(this.segmentId ^ this.segmentId >>> 32);
        result = 31 * result + this.position;
        return result;
    }

    public String toString() {
        return "CommitLogPosition(segmentId=" + this.segmentId + ", position=" + this.position + ')';
    }

    public CommitLogPosition clone() {
        return new CommitLogPosition(this.segmentId, this.position);
    }

    public static class CommitLogPositionSerializer
    implements ISerializer<CommitLogPosition> {
        @Override
        public void serialize(CommitLogPosition clsp, DataOutputPlus out) throws IOException {
            out.writeLong(clsp.segmentId);
            out.writeInt(clsp.position);
        }

        @Override
        public CommitLogPosition deserialize(DataInputPlus in) throws IOException {
            return new CommitLogPosition(in.readLong(), in.readInt());
        }

        @Override
        public long serializedSize(CommitLogPosition clsp) {
            return TypeSizes.sizeof(clsp.segmentId) + TypeSizes.sizeof(clsp.position);
        }

        public CommitLogPosition fromString(String position) throws ParseException {
            if (Strings.isNullOrEmpty(position)) {
                return NONE;
            }
            String[] parts = position.split(",");
            if (parts.length != 2) {
                throw new ParseException("Commit log position must be given as <segment>,<position>", 0);
            }
            return new CommitLogPosition(Long.parseLong(parts[0].trim()), Integer.parseInt(parts[1].trim()));
        }

        public String toString(CommitLogPosition position) {
            return position == NONE ? "" : String.format("%d, %d", position.segmentId, position.position);
        }
    }
}

