/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import net.nmoncho.shaded.com.google.common.base.Throwables;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.snapshot.TableSnapshot;

public class SnapshotDetailsTabularData {
    private static final String[] ITEM_NAMES = new String[]{"Snapshot name", "Keyspace name", "Column family name", "True size", "Size on disk", "Creation time", "Expiration time"};
    private static final String[] ITEM_DESCS = new String[]{"snapshot_name", "keyspace_name", "columnfamily_name", "TrueDiskSpaceUsed", "TotalDiskSpaceUsed", "created_at", "expires_at"};
    private static final String TYPE_NAME = "SnapshotDetails";
    private static final String ROW_DESC = "SnapshotDetails";
    private static final OpenType<?>[] ITEM_TYPES;
    private static final CompositeType COMPOSITE_TYPE;
    public static final TabularType TABULAR_TYPE;

    public static void from(TableSnapshot details, TabularDataSupport result) {
        try {
            String totalSize = FileUtils.stringifyFileSize(details.computeSizeOnDiskBytes());
            String liveSize = FileUtils.stringifyFileSize(details.computeTrueSizeBytes());
            String createdAt = SnapshotDetailsTabularData.safeToString(details.getCreatedAt());
            String expiresAt = SnapshotDetailsTabularData.safeToString(details.getExpiresAt());
            result.put(new CompositeDataSupport(COMPOSITE_TYPE, ITEM_NAMES, new Object[]{details.getTag(), details.getKeyspaceName(), details.getTableName(), liveSize, totalSize, createdAt, expiresAt}));
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    private static String safeToString(Object object) {
        return object == null ? null : object.toString();
    }

    static {
        try {
            ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
            COMPOSITE_TYPE = new CompositeType("SnapshotDetails", "SnapshotDetails", ITEM_NAMES, ITEM_DESCS, ITEM_TYPES);
            TABULAR_TYPE = new TabularType("SnapshotDetails", "SnapshotDetails", COMPOSITE_TYPE, ITEM_NAMES);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate(e);
        }
    }
}

