/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.ViewMetadata;

public class SchemaCQLHelper {
    private static final Pattern EMPTY_TYPE_REGEX = Pattern.compile("empty", 16);
    private static final String EMPTY_TYPE_QUOTED = Matcher.quoteReplacement("'org.apache.cassandra.db.marshal.EmptyType'");

    public static Stream<String> reCreateStatementsForSchemaCql(TableMetadata metadata, KeyspaceMetadata keyspaceMetadata) {
        Stream<String> udts = SchemaCQLHelper.getUserTypesAsCQL(metadata, keyspaceMetadata.types, true);
        Stream<String> tableMatadata = Stream.of(SchemaCQLHelper.getTableMetadataAsCQL(metadata, keyspaceMetadata));
        Stream<String> indexes = SchemaCQLHelper.getIndexesAsCQL(metadata, true);
        return Stream.of(udts, tableMatadata, indexes).flatMap(Function.identity());
    }

    @VisibleForTesting
    public static String getTableMetadataAsCQL(TableMetadata metadata, KeyspaceMetadata keyspaceMetadata) {
        if (metadata.isView()) {
            ViewMetadata viewMetadata = keyspaceMetadata.views.get(metadata.name).orElse(null);
            assert (viewMetadata != null);
            return viewMetadata.toCqlString(true, true);
        }
        return metadata.toCqlString(true, true, true);
    }

    @VisibleForTesting
    public static Stream<String> getUserTypesAsCQL(TableMetadata metadata, Types types, boolean ifNotExists) {
        return metadata.getReferencedUserTypes().stream().map(name -> SchemaCQLHelper.getType(metadata, types, name).toCqlString(false, ifNotExists));
    }

    @VisibleForTesting
    public static Stream<String> getIndexesAsCQL(TableMetadata metadata, boolean ifNotExists) {
        return metadata.indexes.stream().map(indexMetadata -> indexMetadata.toCqlString(metadata, ifNotExists));
    }

    private static UserType getType(TableMetadata metadata, Types types, ByteBuffer name) {
        return types.get(name).orElseThrow(() -> new IllegalStateException(String.format("user type %s is part of table %s definition but its definition was missing", UTF8Type.instance.getString(name), metadata)));
    }

    public static String toCqlType(AbstractType<?> type) {
        return EMPTY_TYPE_REGEX.matcher(type.expandUserTypes().asCQL3Type().toString()).replaceAll(EMPTY_TYPE_QUOTED);
    }
}

