/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import net.nmoncho.shaded.com.google.common.collect.Iterators;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTree;

public class RegularAndStaticColumns
implements Iterable<ColumnMetadata> {
    public static RegularAndStaticColumns NONE = new RegularAndStaticColumns(Columns.NONE, Columns.NONE);
    static final long EMPTY_SIZE = ObjectSizes.measure(NONE);
    public final Columns statics;
    public final Columns regulars;

    public RegularAndStaticColumns(Columns statics, Columns regulars) {
        assert (statics != null && regulars != null);
        this.statics = statics;
        this.regulars = regulars;
    }

    public static RegularAndStaticColumns of(ColumnMetadata column) {
        return new RegularAndStaticColumns(column.isStatic() ? Columns.of(column) : Columns.NONE, column.isStatic() ? Columns.NONE : Columns.of(column));
    }

    public RegularAndStaticColumns without(ColumnMetadata column) {
        return new RegularAndStaticColumns(column.isStatic() ? this.statics.without(column) : this.statics, column.isStatic() ? this.regulars : this.regulars.without(column));
    }

    public RegularAndStaticColumns mergeTo(RegularAndStaticColumns that) {
        if (this == that) {
            return this;
        }
        Columns statics = this.statics.mergeTo(that.statics);
        Columns regulars = this.regulars.mergeTo(that.regulars);
        if (statics == this.statics && regulars == this.regulars) {
            return this;
        }
        if (statics == that.statics && regulars == that.regulars) {
            return that;
        }
        return new RegularAndStaticColumns(statics, regulars);
    }

    public boolean isEmpty() {
        return this.statics.isEmpty() && this.regulars.isEmpty();
    }

    public Columns columns(boolean isStatic) {
        return isStatic ? this.statics : this.regulars;
    }

    public boolean contains(ColumnMetadata column) {
        return column.isStatic() ? this.statics.contains(column) : this.regulars.contains(column);
    }

    public boolean includes(RegularAndStaticColumns columns) {
        return this.statics.containsAll(columns.statics) && this.regulars.containsAll(columns.regulars);
    }

    @Override
    public Iterator<ColumnMetadata> iterator() {
        return Iterators.concat(this.statics.iterator(), this.regulars.iterator());
    }

    public Iterator<ColumnMetadata> selectOrderIterator() {
        return Iterators.concat(this.statics.selectOrderIterator(), this.regulars.selectOrderIterator());
    }

    public int size() {
        return this.regulars.size() + this.statics.size();
    }

    public long unsharedHeapSize() {
        if (this == NONE) {
            return 0L;
        }
        return EMPTY_SIZE + this.regulars.unsharedHeapSize() + this.statics.unsharedHeapSize();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.statics).append(" | ").append(this.regulars).append(']');
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof RegularAndStaticColumns)) {
            return false;
        }
        RegularAndStaticColumns that = (RegularAndStaticColumns)other;
        return this.statics.equals(that.statics) && this.regulars.equals(that.regulars);
    }

    public int hashCode() {
        return Objects.hash(this.statics, this.regulars);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BTree.Builder<ColumnMetadata> regularColumns;
        private BTree.Builder<ColumnMetadata> staticColumns;

        public Builder add(ColumnMetadata c) {
            if (c.isStatic()) {
                if (this.staticColumns == null) {
                    this.staticColumns = BTree.builder(Comparator.naturalOrder());
                }
                this.staticColumns.add(c);
            } else {
                assert (c.isRegular());
                if (this.regularColumns == null) {
                    this.regularColumns = BTree.builder(Comparator.naturalOrder());
                }
                this.regularColumns.add(c);
            }
            return this;
        }

        public Builder addAll(Iterable<ColumnMetadata> columns) {
            for (ColumnMetadata c : columns) {
                this.add(c);
            }
            return this;
        }

        public Builder addAll(RegularAndStaticColumns columns) {
            if (this.regularColumns == null && !columns.regulars.isEmpty()) {
                this.regularColumns = BTree.builder(Comparator.naturalOrder());
            }
            for (ColumnMetadata c : columns.regulars) {
                this.regularColumns.add(c);
            }
            if (this.staticColumns == null && !columns.statics.isEmpty()) {
                this.staticColumns = BTree.builder(Comparator.naturalOrder());
            }
            for (ColumnMetadata c : columns.statics) {
                this.staticColumns.add(c);
            }
            return this;
        }

        public RegularAndStaticColumns build() {
            return new RegularAndStaticColumns(this.staticColumns == null ? Columns.NONE : Columns.from(this.staticColumns), this.regularColumns == null ? Columns.NONE : Columns.from(this.regularColumns));
        }
    }
}

