/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RepairedDataInfo;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.MonotonicClock;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class ReadExecutionController
implements AutoCloseable {
    private static final long NO_SAMPLING = Long.MIN_VALUE;
    private final OpOrder.Group baseOp;
    private final TableMetadata baseMetadata;
    private final ReadExecutionController indexController;
    private final WriteContext writeContext;
    private final ReadCommand command;
    static MonotonicClock clock = MonotonicClock.Global.preciseTime;
    private final long createdAtNanos;
    private final RepairedDataInfo repairedDataInfo;
    private int oldestUnrepairedTombstone = Integer.MAX_VALUE;

    ReadExecutionController(ReadCommand command, OpOrder.Group baseOp, TableMetadata baseMetadata, ReadExecutionController indexController, WriteContext writeContext, long createdAtNanos, boolean trackRepairedStatus) {
        assert (baseOp == null == (baseMetadata == null));
        this.baseOp = baseOp;
        this.baseMetadata = baseMetadata;
        this.indexController = indexController;
        this.writeContext = writeContext;
        this.command = command;
        this.createdAtNanos = createdAtNanos;
        if (trackRepairedStatus) {
            DataLimits.Counter repairedReadCount = command.limits().newCounter(command.nowInSec(), false, command.selectsFullPartition(), this.metadata().enforceStrictLiveness()).onlyCount();
            this.repairedDataInfo = new RepairedDataInfo(repairedReadCount);
        } else {
            this.repairedDataInfo = RepairedDataInfo.NO_OP_REPAIRED_DATA_INFO;
        }
    }

    public ReadExecutionController indexReadController() {
        return this.indexController;
    }

    public WriteContext getWriteContext() {
        return this.writeContext;
    }

    int oldestUnrepairedTombstone() {
        return this.oldestUnrepairedTombstone;
    }

    void updateMinOldestUnrepairedTombstone(int candidate) {
        this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, candidate);
    }

    boolean validForReadOn(ColumnFamilyStore cfs) {
        return this.baseOp != null && cfs.metadata.id.equals(this.baseMetadata.id);
    }

    public static ReadExecutionController empty() {
        return new ReadExecutionController(null, null, null, null, null, Long.MIN_VALUE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ReadExecutionController forCommand(ReadCommand command, boolean trackRepairedStatus) {
        long createdAtNanos;
        ColumnFamilyStore baseCfs = Keyspace.openAndGetStore(command.metadata());
        ColumnFamilyStore indexCfs = ReadExecutionController.maybeGetIndexCfs(baseCfs, command);
        long l = createdAtNanos = baseCfs.metric.topLocalReadQueryTime.isEnabled() ? clock.now() : Long.MIN_VALUE;
        if (indexCfs == null) {
            return new ReadExecutionController(command, baseCfs.readOrdering.start(), baseCfs.metadata(), null, null, createdAtNanos, trackRepairedStatus);
        }
        OpOrder.Group baseOp = null;
        WriteContext writeContext = null;
        ReadExecutionController indexController = null;
        try {
            baseOp = baseCfs.readOrdering.start();
            indexController = new ReadExecutionController(command, indexCfs.readOrdering.start(), indexCfs.metadata(), null, null, Long.MIN_VALUE, false);
            writeContext = baseCfs.keyspace.getWriteHandler().createContextForRead();
            return new ReadExecutionController(command, baseOp, baseCfs.metadata(), indexController, writeContext, createdAtNanos, trackRepairedStatus);
        }
        catch (RuntimeException e) {
            assert (writeContext == null);
            try {
                if (baseOp != null) {
                    baseOp.close();
                }
            }
            finally {
                if (indexController != null) {
                    indexController.close();
                }
            }
            throw e;
        }
    }

    private static ColumnFamilyStore maybeGetIndexCfs(ColumnFamilyStore baseCfs, ReadCommand command) {
        Index index = command.getIndex(baseCfs);
        return index == null ? null : (ColumnFamilyStore)index.getBackingTable().orElse(null);
    }

    public TableMetadata metadata() {
        return this.baseMetadata;
    }

    @Override
    public void close() {
        try {
            if (this.baseOp != null) {
                this.baseOp.close();
            }
        }
        finally {
            if (this.indexController != null) {
                try {
                    this.indexController.close();
                }
                finally {
                    this.writeContext.close();
                }
            }
        }
        if (this.createdAtNanos != Long.MIN_VALUE) {
            this.addSample();
        }
    }

    public boolean isTrackingRepairedStatus() {
        return this.repairedDataInfo != RepairedDataInfo.NO_OP_REPAIRED_DATA_INFO;
    }

    @VisibleForTesting
    public ByteBuffer getRepairedDataDigest() {
        return this.repairedDataInfo.getDigest();
    }

    @VisibleForTesting
    public boolean isRepairedDataDigestConclusive() {
        return this.repairedDataInfo.isConclusive();
    }

    public RepairedDataInfo getRepairedDataInfo() {
        return this.repairedDataInfo;
    }

    private void addSample() {
        String cql = this.command.toCQLString();
        int timeMicros = (int)Math.min(TimeUnit.NANOSECONDS.toMicros(clock.now() - this.createdAtNanos), Integer.MAX_VALUE);
        ColumnFamilyStore cfs = ColumnFamilyStore.getIfExists(this.baseMetadata.id);
        if (cfs != null) {
            cfs.metric.topLocalReadQueryTime.addSample(cql, timeMicros);
        }
    }
}

