/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.File;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.db.DisallowedDirectoriesMBean;
import org.apache.cassandra.utils.MBeanWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisallowedDirectories
implements DisallowedDirectoriesMBean {
    public static final String DEPRECATED_MBEAN_NAME = "org.apache.cassandra.db:type=BlacklistedDirectories";
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=DisallowedDirectories";
    private static final Logger logger = LoggerFactory.getLogger(DisallowedDirectories.class);
    private static final DisallowedDirectories instance = new DisallowedDirectories();
    private final Set<org.apache.cassandra.io.util.File> unreadableDirectories = new CopyOnWriteArraySet<org.apache.cassandra.io.util.File>();
    private final Set<org.apache.cassandra.io.util.File> unwritableDirectories = new CopyOnWriteArraySet<org.apache.cassandra.io.util.File>();
    private static final AtomicInteger directoriesVersion = new AtomicInteger();

    private DisallowedDirectories() {
        MBeanWrapper.instance.registerMBean((Object)this, DEPRECATED_MBEAN_NAME, MBeanWrapper.OnException.LOG);
        MBeanWrapper.instance.registerMBean((Object)this, MBEAN_NAME, MBeanWrapper.OnException.LOG);
    }

    @Override
    public Set<File> getUnreadableDirectories() {
        return DisallowedDirectories.toJmx(this.unreadableDirectories);
    }

    @Override
    public Set<File> getUnwritableDirectories() {
        return DisallowedDirectories.toJmx(this.unwritableDirectories);
    }

    private static Set<File> toJmx(Set<org.apache.cassandra.io.util.File> set) {
        return set.stream().map(f -> f.toPath().toFile()).collect(Collectors.toSet());
    }

    @Override
    public void markUnreadable(String path) {
        DisallowedDirectories.maybeMarkUnreadable(new org.apache.cassandra.io.util.File(path));
    }

    @Override
    public void markUnwritable(String path) {
        DisallowedDirectories.maybeMarkUnwritable(new org.apache.cassandra.io.util.File(path));
    }

    public static org.apache.cassandra.io.util.File maybeMarkUnreadable(org.apache.cassandra.io.util.File path) {
        org.apache.cassandra.io.util.File directory = DisallowedDirectories.getDirectory(path);
        if (DisallowedDirectories.instance.unreadableDirectories.add(directory)) {
            directoriesVersion.incrementAndGet();
            logger.warn("Disallowing {} for reads", (Object)directory);
            return directory;
        }
        return null;
    }

    public static org.apache.cassandra.io.util.File maybeMarkUnwritable(org.apache.cassandra.io.util.File path) {
        org.apache.cassandra.io.util.File directory = DisallowedDirectories.getDirectory(path);
        if (DisallowedDirectories.instance.unwritableDirectories.add(directory)) {
            directoriesVersion.incrementAndGet();
            logger.warn("Disallowing {} for writes", (Object)directory);
            return directory;
        }
        return null;
    }

    public static int getDirectoriesVersion() {
        return directoriesVersion.get();
    }

    @VisibleForTesting
    public static void clearUnwritableUnsafe() {
        DisallowedDirectories.instance.unwritableDirectories.clear();
    }

    public static boolean isUnreadable(org.apache.cassandra.io.util.File directory) {
        return DisallowedDirectories.instance.unreadableDirectories.contains(directory);
    }

    public static boolean isUnwritable(org.apache.cassandra.io.util.File directory) {
        return DisallowedDirectories.instance.unwritableDirectories.contains(directory);
    }

    private static org.apache.cassandra.io.util.File getDirectory(org.apache.cassandra.io.util.File file) {
        if (file.isDirectory()) {
            return file;
        }
        if (file.isFile()) {
            return file.parent();
        }
        if (file.path().endsWith(".db")) {
            return file.parent();
        }
        return file;
    }
}

