/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import net.nmoncho.shaded.com.google.common.hash.HashFunction;
import net.nmoncho.shaded.com.google.common.hash.Hasher;
import net.nmoncho.shaded.com.google.common.hash.Hashing;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.utils.FastByteOperations;

public class Digest {
    private static final ThreadLocal<byte[]> localBuffer = ThreadLocal.withInitial(() -> new byte[4096]);
    private final Hasher hasher;
    private long inputBytes = 0L;

    private static Hasher md5() {
        return Hashing.md5().newHasher();
    }

    public static Digest forReadResponse() {
        return new Digest(Digest.md5());
    }

    public static Digest forSchema() {
        return new Digest(Digest.md5());
    }

    public static Digest forValidator() {
        return new Digest(Hashing.concatenating(Hashing.murmur3_128(1000), Hashing.murmur3_128(2000), new HashFunction[0]).newHasher());
    }

    public static Digest forRepairedDataTracking() {
        return new Digest(Hashing.crc32c().newHasher()){

            @Override
            public <V> Digest updateWithCounterContext(V context, ValueAccessor<V> accessor) {
                if (CounterContext.instance().hasLegacyShards(context, accessor)) {
                    return this;
                }
                return super.updateWithCounterContext(context, accessor);
            }
        };
    }

    Digest(Hasher hasher) {
        this.hasher = hasher;
    }

    public Digest update(byte[] input, int offset, int len) {
        this.hasher.putBytes(input, offset, len);
        this.inputBytes += (long)len;
        return this;
    }

    public <V> Digest update(V input, ValueAccessor<V> accessor) {
        accessor.digest(input, this);
        return this;
    }

    public Digest update(ByteBuffer input) {
        return this.update(input, input.position(), input.remaining());
    }

    public Digest update(ByteBuffer input, int pos, int len) {
        if (len <= 0) {
            return this;
        }
        if (input.hasArray()) {
            byte[] b = input.array();
            int ofs = input.arrayOffset();
            this.hasher.putBytes(b, ofs + pos, len);
            this.inputBytes += (long)len;
        } else {
            byte[] tempArray = localBuffer.get();
            while (len > 0) {
                int chunk = Math.min(len, tempArray.length);
                FastByteOperations.copy(input, pos, tempArray, 0, chunk);
                this.hasher.putBytes(tempArray, 0, chunk);
                len -= chunk;
                pos += chunk;
                this.inputBytes += (long)chunk;
            }
        }
        return this;
    }

    public <V> Digest updateWithCounterContext(V context, ValueAccessor<V> accessor) {
        if (accessor.isEmpty(context)) {
            return this;
        }
        int pos = CounterContext.headerLength(context, accessor);
        int len = accessor.size(context) - pos;
        accessor.digest(context, pos, len, this);
        return this;
    }

    public Digest updateWithByte(int val) {
        this.hasher.putByte((byte)(val & 0xFF));
        ++this.inputBytes;
        return this;
    }

    public Digest updateWithInt(int val) {
        this.hasher.putByte((byte)(val >>> 24 & 0xFF));
        this.hasher.putByte((byte)(val >>> 16 & 0xFF));
        this.hasher.putByte((byte)(val >>> 8 & 0xFF));
        this.hasher.putByte((byte)(val >>> 0 & 0xFF));
        this.inputBytes += 4L;
        return this;
    }

    public Digest updateWithLong(long val) {
        this.hasher.putByte((byte)(val >>> 56 & 0xFFL));
        this.hasher.putByte((byte)(val >>> 48 & 0xFFL));
        this.hasher.putByte((byte)(val >>> 40 & 0xFFL));
        this.hasher.putByte((byte)(val >>> 32 & 0xFFL));
        this.hasher.putByte((byte)(val >>> 24 & 0xFFL));
        this.hasher.putByte((byte)(val >>> 16 & 0xFFL));
        this.hasher.putByte((byte)(val >>> 8 & 0xFFL));
        this.hasher.putByte((byte)(val >>> 0 & 0xFFL));
        this.inputBytes += 8L;
        return this;
    }

    public Digest updateWithBoolean(boolean val) {
        this.updateWithByte(val ? 0 : 1);
        return this;
    }

    public byte[] digest() {
        return this.hasher.hash().asBytes();
    }

    public long inputBytes() {
        return this.inputBytes;
    }
}

