/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.nmoncho.shaded.com.google.common.base.Joiner;
import net.nmoncho.shaded.com.google.common.collect.ImmutableList;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.io.sstable.IndexInfo;

public class ClusteringComparator
implements Comparator<Clusterable> {
    private final List<AbstractType<?>> clusteringTypes;
    private final Comparator<IndexInfo> indexComparator;
    private final Comparator<IndexInfo> indexReverseComparator;
    private final Comparator<Clusterable> reverseComparator;
    private final Comparator<Row> rowComparator = (r1, r2) -> this.compare(r1.clustering(), r2.clustering());

    public ClusteringComparator(AbstractType<?> ... clusteringTypes) {
        this(ImmutableList.copyOf(clusteringTypes));
    }

    public ClusteringComparator(Iterable<AbstractType<?>> clusteringTypes) {
        this.clusteringTypes = ImmutableList.copyOf(clusteringTypes);
        this.indexComparator = (o1, o2) -> this.compare(o1.lastName, o2.lastName);
        this.indexReverseComparator = (o1, o2) -> this.compare(o1.firstName, o2.firstName);
        this.reverseComparator = (c1, c2) -> this.compare((Clusterable)c2, (Clusterable)c1);
        for (AbstractType<?> type : clusteringTypes) {
            type.checkComparable();
        }
    }

    public int size() {
        return this.clusteringTypes.size();
    }

    public List<AbstractType<?>> subtypes() {
        return this.clusteringTypes;
    }

    public AbstractType<?> subtype(int i) {
        return this.clusteringTypes.get(i);
    }

    public Clustering<?> make(Object ... values) {
        if (values.length != this.size()) {
            throw new IllegalArgumentException(String.format("Invalid number of components, expecting %d but got %d", this.size(), values.length));
        }
        CBuilder builder = CBuilder.create(this);
        for (Object val : values) {
            if (val instanceof ByteBuffer) {
                builder.add((ByteBuffer)val);
                continue;
            }
            builder.add(val);
        }
        return builder.build();
    }

    @Override
    public int compare(Clusterable c1, Clusterable c2) {
        return this.compare(c1.clustering(), c2.clustering());
    }

    @Override
    public <V1, V2> int compare(ClusteringPrefix<V1> c1, ClusteringPrefix<V2> c2) {
        int s1 = c1.size();
        int s2 = c2.size();
        int minSize = Math.min(s1, s2);
        for (int i = 0; i < minSize; ++i) {
            int cmp = this.compareComponent(i, c1.get(i), c1.accessor(), c2.get(i), c2.accessor());
            if (cmp == 0) continue;
            return cmp;
        }
        if (s1 == s2) {
            return ClusteringPrefix.Kind.compare(c1.kind(), c2.kind());
        }
        return s1 < s2 ? c1.kind().comparedToClustering : -c2.kind().comparedToClustering;
    }

    @Override
    public <V1, V2> int compare(Clustering<V1> c1, Clustering<V2> c2) {
        return this.compare(c1, c2, this.size());
    }

    public <V1, V2> int compare(Clustering<V1> c1, Clustering<V2> c2, int size) {
        for (int i = 0; i < size; ++i) {
            int cmp = this.compareComponent(i, c1.get(i), c1.accessor(), c2.get(i), c2.accessor());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public <V1, V2> int compareComponent(int i, V1 v1, ValueAccessor<V1> accessor1, V2 v2, ValueAccessor<V2> accessor2) {
        if (v1 == null) {
            return v2 == null ? 0 : -1;
        }
        if (v2 == null) {
            return 1;
        }
        return this.clusteringTypes.get(i).compare(v1, accessor1, v2, accessor2);
    }

    public <V1, V2> int compareComponent(int i, ClusteringPrefix<V1> v1, ClusteringPrefix<V2> v2) {
        return this.compareComponent(i, v1.get(i), v1.accessor(), v2.get(i), v2.accessor());
    }

    public boolean isCompatibleWith(ClusteringComparator previous) {
        if (this == previous) {
            return true;
        }
        if (this.size() < previous.size()) {
            return false;
        }
        for (int i = 0; i < previous.size(); ++i) {
            AbstractType<?> tprev = previous.subtype(i);
            AbstractType<?> tnew = this.subtype(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    public <T> void validate(ClusteringPrefix<T> clustering) {
        ValueAccessor<T> accessor = clustering.accessor();
        for (int i = 0; i < clustering.size(); ++i) {
            T value = clustering.get(i);
            if (value == null) continue;
            this.subtype(i).validate(value, accessor);
        }
    }

    public Comparator<Row> rowComparator() {
        return this.rowComparator;
    }

    public Comparator<IndexInfo> indexComparator(boolean reversed) {
        return reversed ? this.indexReverseComparator : this.indexComparator;
    }

    @Override
    public Comparator<Clusterable> reversed() {
        return this.reverseComparator;
    }

    public String toString() {
        return String.format("comparator(%s)", Joiner.on(", ").join(this.clusteringTypes));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusteringComparator)) {
            return false;
        }
        ClusteringComparator that = (ClusteringComparator)o;
        return this.clusteringTypes.equals(that.clusteringTypes);
    }

    public int hashCode() {
        return Objects.hashCode(this.clusteringTypes);
    }
}

