/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import net.nmoncho.shaded.com.google.common.collect.ImmutableSet;
import org.apache.cassandra.cql3.statements.PropertyDefinitions;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.ReplicationParams;

public final class KeyspaceAttributes
extends PropertyDefinitions {
    private static final Set<String> validKeywords;
    private static final Set<String> obsoleteKeywords;

    public void validate() {
        this.validate(validKeywords, obsoleteKeywords);
        Map<String, String> replicationOptions = this.getAllReplicationOptions();
        if (!replicationOptions.isEmpty() && !replicationOptions.containsKey("class")) {
            throw new ConfigurationException("Missing replication strategy class");
        }
    }

    private String getReplicationStrategyClass() {
        return this.getAllReplicationOptions().get("class");
    }

    private Map<String, String> getAllReplicationOptions() {
        Map<String, String> replication = this.getMap(KeyspaceParams.Option.REPLICATION.toString());
        return replication == null ? Collections.emptyMap() : replication;
    }

    KeyspaceParams asNewKeyspaceParams() {
        boolean durableWrites = this.getBoolean(KeyspaceParams.Option.DURABLE_WRITES.toString(), true);
        return KeyspaceParams.create(durableWrites, this.getAllReplicationOptions());
    }

    KeyspaceParams asAlteredKeyspaceParams(KeyspaceParams previous) {
        boolean durableWrites = this.getBoolean(KeyspaceParams.Option.DURABLE_WRITES.toString(), previous.durableWrites);
        ImmutableMap<String, String> previousOptions = previous.replication.options;
        ReplicationParams replication = this.getReplicationStrategyClass() == null ? previous.replication : ReplicationParams.fromMapWithDefaults(this.getAllReplicationOptions(), previousOptions);
        return new KeyspaceParams(durableWrites, replication);
    }

    public boolean hasOption(KeyspaceParams.Option option) {
        return this.hasProperty(option.toString());
    }

    static {
        ImmutableSet.Builder validBuilder = ImmutableSet.builder();
        for (KeyspaceParams.Option option : KeyspaceParams.Option.values()) {
            validBuilder.add(option.toString());
        }
        validKeywords = validBuilder.build();
        obsoleteKeywords = ImmutableSet.of();
    }
}

