/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import net.nmoncho.shaded.com.google.common.collect.Iterables;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class DropTableStatement
extends AlterSchemaStatement {
    private final String tableName;
    private final boolean ifExists;

    public DropTableStatement(String keyspaceName, String tableName, boolean ifExists) {
        super(keyspaceName);
        this.tableName = tableName;
        this.ifExists = ifExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        TableMetadata table;
        Guardrails.dropTruncateTableEnabled.ensureEnabled(this.state);
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        TableMetadata tableMetadata = table = null == keyspace ? null : keyspace.getTableOrViewNullable(this.tableName);
        if (null == table) {
            if (this.ifExists) {
                return schema;
            }
            throw DropTableStatement.ire("Table '%s.%s' doesn't exist", this.keyspaceName, this.tableName);
        }
        if (table.isView()) {
            throw DropTableStatement.ire("Cannot use DROP TABLE on a materialized view. Please use DROP MATERIALIZED VIEW instead.", new Object[0]);
        }
        Iterable<ViewMetadata> views = keyspace.views.forTable(table.id);
        if (!Iterables.isEmpty(views)) {
            throw DropTableStatement.ire("Cannot drop a table when materialized views still depend on it (%s)", this.keyspaceName, String.join((CharSequence)", ", Iterables.transform(views, ViewMetadata::name)));
        }
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.tables.without(table)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.tableName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureTablePermission(this.keyspaceName, this.tableName, Permission.DROP);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.DROP_TABLE, this.keyspaceName, this.tableName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.tableName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName name;
        private final boolean ifExists;

        public Raw(QualifiedName name, boolean ifExists) {
            this.name = name;
            this.ifExists = ifExists;
        }

        @Override
        public DropTableStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            return new DropTableStatement(keyspaceName, this.name.getName(), this.ifExists);
        }
    }
}

