/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.UTName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AlterTypeStatement
extends AlterSchemaStatement {
    protected final String typeName;
    protected final boolean ifExists;

    public AlterTypeStatement(String keyspaceName, String typeName, boolean ifExists) {
        super(keyspaceName);
        this.ifExists = ifExists;
        this.typeName = typeName;
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureAllTablesPermission(this.keyspaceName, Permission.ALTER);
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TYPE, this.keyspaceName, this.typeName);
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        UserType type;
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        UserType userType = type = null == keyspace ? null : keyspace.types.getNullable(ByteBufferUtil.bytes(this.typeName));
        if (null == type) {
            if (!this.ifExists) {
                throw AlterTypeStatement.ire("Type %s.%s doesn't exist", this.keyspaceName, this.typeName);
            }
            return schema;
        }
        return schema.withAddedOrUpdated(keyspace.withUpdatedUserType(this.apply(keyspace, type)));
    }

    abstract UserType apply(KeyspaceMetadata var1, UserType var2);

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.ALTER_TYPE, this.keyspaceName, this.typeName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.typeName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final UTName name;
        private final boolean ifExists;
        private boolean ifFieldExists;
        private boolean ifFieldNotExists;
        private Kind kind;
        private FieldIdentifier newFieldName;
        private CQL3Type.Raw newFieldType;
        private final Map<FieldIdentifier, FieldIdentifier> renamedFields = new HashMap<FieldIdentifier, FieldIdentifier>();

        public Raw(UTName name, boolean ifExists) {
            this.ifExists = ifExists;
            this.name = name;
        }

        @Override
        public AlterTypeStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            String typeName = this.name.getStringTypeName();
            switch (this.kind) {
                case ADD_FIELD: {
                    return new AddField(keyspaceName, typeName, this.newFieldName, this.newFieldType, this.ifExists, this.ifFieldNotExists);
                }
                case RENAME_FIELDS: {
                    return new RenameFields(keyspaceName, typeName, this.renamedFields, this.ifExists, this.ifFieldExists);
                }
                case ALTER_FIELD: {
                    return new AlterField(keyspaceName, typeName, this.ifExists);
                }
            }
            throw new AssertionError();
        }

        public void add(FieldIdentifier name, CQL3Type.Raw type) {
            this.kind = Kind.ADD_FIELD;
            this.newFieldName = name;
            this.newFieldType = type;
        }

        public void ifFieldNotExists(boolean ifNotExists) {
            this.ifFieldNotExists = ifNotExists;
        }

        public void rename(FieldIdentifier from, FieldIdentifier to) {
            this.kind = Kind.RENAME_FIELDS;
            this.renamedFields.put(from, to);
        }

        public void ifFieldExists(boolean ifExists) {
            this.ifFieldExists = ifExists;
        }

        public void alter(FieldIdentifier name, CQL3Type.Raw type) {
            this.kind = Kind.ALTER_FIELD;
        }

        private static enum Kind {
            ADD_FIELD,
            RENAME_FIELDS,
            ALTER_FIELD;

        }
    }

    private static final class AlterField
    extends AlterTypeStatement {
        private AlterField(String keyspaceName, String typeName, boolean ifExists) {
            super(keyspaceName, typeName, ifExists);
        }

        @Override
        UserType apply(KeyspaceMetadata keyspace, UserType userType) {
            throw AlterField.ire("Altering field types is no longer supported", new Object[0]);
        }
    }

    private static final class RenameFields
    extends AlterTypeStatement {
        private final Map<FieldIdentifier, FieldIdentifier> renamedFields;
        private final boolean ifFieldExists;

        private RenameFields(String keyspaceName, String typeName, Map<FieldIdentifier, FieldIdentifier> renamedFields, boolean ifExists, boolean ifFieldExists) {
            super(keyspaceName, typeName, ifExists);
            this.ifFieldExists = ifFieldExists;
            this.renamedFields = renamedFields;
        }

        @Override
        UserType apply(KeyspaceMetadata keyspace, UserType userType) {
            List dependentAggregates = keyspace.functions.udas().filter(uda -> null != uda.initialCondition() && uda.stateType().referencesUserType(userType.name)).map(uda -> uda.name().toString()).collect(Collectors.toList());
            if (!dependentAggregates.isEmpty()) {
                throw RenameFields.ire("Cannot alter user type %s as it is still used in INITCOND by aggregates %s", userType.getCqlTypeName(), String.join((CharSequence)", ", dependentAggregates));
            }
            ArrayList<FieldIdentifier> fieldNames = new ArrayList<FieldIdentifier>(userType.fieldNames());
            this.renamedFields.forEach((oldName, newName) -> {
                int idx = userType.fieldPosition((FieldIdentifier)oldName);
                if (idx < 0) {
                    if (!this.ifFieldExists) {
                        throw RenameFields.ire("Unkown field %s in user type %s", oldName, userType.getCqlTypeName());
                    }
                    return;
                }
                fieldNames.set(idx, (FieldIdentifier)newName);
            });
            fieldNames.forEach(name -> {
                if (fieldNames.stream().filter(Predicate.isEqual(name)).count() > 1L) {
                    throw RenameFields.ire("Duplicate field name %s in type %s", name, this.keyspaceName, userType.getCqlTypeName());
                }
            });
            return new UserType(this.keyspaceName, userType.name, fieldNames, userType.fieldTypes(), true);
        }
    }

    private static final class AddField
    extends AlterTypeStatement {
        private final FieldIdentifier fieldName;
        private final CQL3Type.Raw type;
        private final boolean ifFieldNotExists;
        private ClientState state;

        private AddField(String keyspaceName, String typeName, FieldIdentifier fieldName, CQL3Type.Raw type, boolean ifExists, boolean ifFieldNotExists) {
            super(keyspaceName, typeName, ifExists);
            this.fieldName = fieldName;
            this.ifFieldNotExists = ifFieldNotExists;
            this.type = type;
        }

        @Override
        public void validate(ClientState state) {
            super.validate(state);
            this.state = state;
        }

        @Override
        UserType apply(KeyspaceMetadata keyspace, UserType userType) {
            if (this.type.isCounter()) {
                throw AddField.ire("A user type cannot contain counters", new Object[0]);
            }
            if (this.type.isUDT() && !this.type.isFrozen()) {
                throw AddField.ire("A user type cannot contain non-frozen UDTs", new Object[0]);
            }
            if (userType.fieldPosition(this.fieldName) >= 0) {
                if (!this.ifFieldNotExists) {
                    throw AddField.ire("Cannot add field %s to type %s: a field with name %s already exists", this.fieldName, userType.getCqlTypeName(), this.fieldName);
                }
                return userType;
            }
            AbstractType<?> fieldType = this.type.prepare(this.keyspaceName, keyspace.types).getType();
            if (fieldType.referencesUserType(userType.name)) {
                throw AddField.ire("Cannot add new field %s of type %s to user type %s as it would create a circular reference", this.fieldName, this.type, userType.getCqlTypeName());
            }
            Collection<TableMetadata> tablesWithTypeInPartitionKey = AddField.findTablesReferencingTypeInPartitionKey(keyspace, userType);
            if (!tablesWithTypeInPartitionKey.isEmpty()) {
                throw AddField.ire("Cannot add new field %s of type %s to user type %s as the type is being used in partition key by the following tables: %s", this.fieldName, this.type, userType.getCqlTypeName(), String.join((CharSequence)", ", Iterables.transform(tablesWithTypeInPartitionKey, TableMetadata::toString)));
            }
            Guardrails.fieldsPerUDT.guard(userType.size() + 1, userType.getNameAsString(), false, this.state);
            ArrayList<FieldIdentifier> fieldNames = new ArrayList<FieldIdentifier>(userType.fieldNames());
            fieldNames.add(this.fieldName);
            ArrayList fieldTypes = new ArrayList(userType.fieldTypes());
            fieldTypes.add(fieldType);
            return new UserType(this.keyspaceName, userType.name, fieldNames, fieldTypes, true);
        }

        private static Collection<TableMetadata> findTablesReferencingTypeInPartitionKey(KeyspaceMetadata keyspace, UserType userType) {
            ArrayList<TableMetadata> tables = new ArrayList<TableMetadata>();
            Iterables.filter(keyspace.tablesAndViews(), table -> Iterables.any(table.partitionKeyColumns(), column -> column.type.referencesUserType(userType.name))).forEach(tables::add);
            return tables;
        }
    }
}

