/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.base.MoreObjects;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.ResultSetBuilder;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.QualifiedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.StatementType;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadQuery;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.SinglePartitionReadQuery;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.aggregation.AggregationSpecification;
import org.apache.cassandra.db.aggregation.GroupMaker;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.ReadSizeAbortException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.pager.AggregationQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStatement
implements CQLStatement.SingleKeyspaceCqlStatement {
    private static final Logger logger = LoggerFactory.getLogger(SelectStatement.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    public static final int DEFAULT_PAGE_SIZE = 10000;
    public final VariableSpecifications bindVariables;
    public final TableMetadata table;
    public final Parameters parameters;
    private final Selection selection;
    private final Term limit;
    private final Term perPartitionLimit;
    private final StatementRestrictions restrictions;
    private final boolean isReversed;
    private final AggregationSpecification.Factory aggregationSpecFactory;
    private final Comparator<List<ByteBuffer>> orderingComparator;
    private static final Parameters defaultParameters = new Parameters(Collections.emptyMap(), Collections.emptyList(), false, false, false);

    public SelectStatement(TableMetadata table, VariableSpecifications bindVariables, Parameters parameters, Selection selection, StatementRestrictions restrictions, boolean isReversed, AggregationSpecification.Factory aggregationSpecFactory, Comparator<List<ByteBuffer>> orderingComparator, Term limit, Term perPartitionLimit) {
        this.table = table;
        this.bindVariables = bindVariables;
        this.selection = selection;
        this.restrictions = restrictions;
        this.isReversed = isReversed;
        this.aggregationSpecFactory = aggregationSpecFactory;
        this.orderingComparator = orderingComparator;
        this.parameters = parameters;
        this.limit = limit;
        this.perPartitionLimit = perPartitionLimit;
    }

    @Override
    public List<ColumnSpecification> getBindVariables() {
        return this.bindVariables.getBindVariables();
    }

    @Override
    public short[] getPartitionKeyBindVariableIndexes() {
        return this.bindVariables.getPartitionKeyBindVariableIndexes(this.table);
    }

    @Override
    public Iterable<Function> getFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        this.addFunctionsTo(functions);
        return functions;
    }

    private void addFunctionsTo(List<Function> functions) {
        this.selection.addFunctionsTo(functions);
        this.restrictions.addFunctionsTo(functions);
        if (this.aggregationSpecFactory != null) {
            this.aggregationSpecFactory.addFunctionsTo(functions);
        }
        if (this.limit != null) {
            this.limit.addFunctionsTo(functions);
        }
        if (this.perPartitionLimit != null) {
            this.perPartitionLimit.addFunctionsTo(functions);
        }
    }

    public ColumnFilter queriedColumns() {
        return this.selection.newSelectors(QueryOptions.DEFAULT).getColumnFilter();
    }

    static SelectStatement forSelection(TableMetadata table, Selection selection) {
        return new SelectStatement(table, VariableSpecifications.empty(), defaultParameters, selection, StatementRestrictions.empty(StatementType.SELECT, table), false, null, null, null, null);
    }

    public ResultSet.ResultMetadata getResultMetadata() {
        return this.selection.getResultMetadata();
    }

    @Override
    public void authorize(ClientState state) throws InvalidRequestException, UnauthorizedException {
        if (this.table.isView()) {
            TableMetadataRef baseTable = View.findBaseTable(this.keyspace(), this.table());
            if (baseTable != null) {
                state.ensureTablePermission(baseTable, Permission.SELECT);
            }
        } else {
            state.ensureTablePermission(this.table, Permission.SELECT);
        }
        for (Function function : this.getFunctions()) {
            state.ensurePermission(Permission.EXECUTE, function);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.parameters.allowFiltering && !SchemaConstants.isSystemKeyspace(this.table.keyspace)) {
            Guardrails.allowFilteringEnabled.ensureEnabled(state);
        }
    }

    @Override
    public ResultMessage.Rows execute(QueryState state, QueryOptions options, Dispatcher.RequestTime requestTime) {
        ConsistencyLevel cl = options.getConsistency();
        RequestValidations.checkNotNull(cl, "Invalid empty consistency level");
        cl.validateForRead();
        Guardrails.readConsistencyLevels.guard(EnumSet.of(cl), state.getClientState());
        int nowInSec = options.getNowInSeconds(state);
        int userLimit = this.getLimit(options);
        int userPerPartitionLimit = this.getPerPartitionLimit(options);
        int pageSize = options.getPageSize();
        Selection.Selectors selectors = this.selection.newSelectors(options);
        AggregationSpecification aggregationSpec = this.getAggregationSpec(options);
        ReadQuery query = this.getQuery(options, state.getClientState(), selectors.getColumnFilter(), nowInSec, userLimit, userPerPartitionLimit, pageSize, aggregationSpec);
        if (options.isReadThresholdsEnabled()) {
            query.trackWarnings();
        }
        if (aggregationSpec == null && (pageSize <= 0 || query.limits().count() <= pageSize)) {
            return this.execute(query, options, state.getClientState(), selectors, nowInSec, userLimit, null, requestTime);
        }
        QueryPager pager = this.getPager(query, options);
        return this.execute(state, Pager.forDistributedQuery(pager, cl, state.getClientState()), options, selectors, pageSize, nowInSec, userLimit, aggregationSpec, requestTime);
    }

    public AggregationSpecification getAggregationSpec(QueryOptions options) {
        return this.aggregationSpecFactory == null ? null : this.aggregationSpecFactory.newInstance(options);
    }

    public ReadQuery getQuery(QueryOptions options, int nowInSec) throws RequestValidationException {
        Selection.Selectors selectors = this.selection.newSelectors(options);
        return this.getQuery(options, ClientState.forInternalCalls(), selectors.getColumnFilter(), nowInSec, this.getLimit(options), this.getPerPartitionLimit(options), options.getPageSize(), this.getAggregationSpec(options));
    }

    public ReadQuery getQuery(QueryOptions options, ClientState state, ColumnFilter columnFilter, int nowInSec, int userLimit, int perPartitionLimit, int pageSize, AggregationSpecification aggregationSpec) {
        boolean isPartitionRangeQuery = this.restrictions.isKeyRange() || this.restrictions.usesSecondaryIndexing();
        DataLimits limit = this.getDataLimits(userLimit, perPartitionLimit, pageSize, aggregationSpec);
        if (isPartitionRangeQuery) {
            return this.getRangeCommand(options, state, columnFilter, limit, nowInSec);
        }
        return this.getSliceCommands(options, state, columnFilter, limit, nowInSec);
    }

    private ResultMessage.Rows execute(ReadQuery query, QueryOptions options, ClientState state, Selection.Selectors selectors, int nowInSec, int userLimit, AggregationSpecification aggregationSpec, Dispatcher.RequestTime requestTime) {
        try (PartitionIterator data = query.execute(options.getConsistency(), state, requestTime);){
            ResultMessage.Rows rows = this.processResults(data, options, selectors, nowInSec, userLimit, aggregationSpec);
            return rows;
        }
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.SELECT, this.keyspace(), this.table.name);
    }

    private ResultMessage.Rows execute(QueryState state, Pager pager, QueryOptions options, Selection.Selectors selectors, int pageSize, int nowInSec, int userLimit, AggregationSpecification aggregationSpec, Dispatcher.RequestTime requestTime) {
        ResultMessage.Rows msg;
        Guardrails.pageSize.guard(pageSize, this.table(), false, state.getClientState());
        if (this.aggregationSpecFactory != null) {
            if (!this.restrictions.hasPartitionKeyRestrictions()) {
                this.warn("Aggregation query used without partition key");
                noSpamLogger.warn(String.format("Aggregation query used without partition key on table %s.%s, aggregation type: %s", new Object[]{this.keyspace(), this.table(), aggregationSpec.kind()}), new Object[0]);
            } else if (this.restrictions.keyIsInRelation()) {
                this.warn("Aggregation query used on multiple partition keys (IN restriction)");
                noSpamLogger.warn(String.format("Aggregation query used on multiple partition keys (IN restriction) on table %s.%s, aggregation type: %s", new Object[]{this.keyspace(), this.table(), aggregationSpec.kind()}), new Object[0]);
            }
        }
        RequestValidations.checkFalse(pageSize > 0 && this.needsPostQueryOrdering(), "Cannot page queries with both ORDER BY and a IN restriction on the partition key; you must either remove the ORDER BY or the IN and sort client side, or disable paging for this query");
        try (PartitionIterator page = pager.fetchPage(pageSize, requestTime);){
            msg = this.processResults(page, options, selectors, nowInSec, userLimit, aggregationSpec);
        }
        if (!pager.isExhausted()) {
            msg.result.metadata.setHasMorePages(pager.state());
        }
        return msg;
    }

    private void warn(String msg) {
        logger.warn(msg);
        ClientWarn.instance.warn(msg);
    }

    private ResultMessage.Rows processResults(PartitionIterator partitions, QueryOptions options, Selection.Selectors selectors, int nowInSec, int userLimit, AggregationSpecification aggregationSpec) throws RequestValidationException {
        ResultSet rset = this.process(partitions, options, selectors, nowInSec, userLimit, aggregationSpec);
        return new ResultMessage.Rows(rset);
    }

    @Override
    public ResultMessage.Rows executeLocally(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        return this.executeInternal(state, options, options.getNowInSeconds(state), Dispatcher.RequestTime.forImmediateExecution());
    }

    public ResultMessage.Rows executeInternal(QueryState state, QueryOptions options, int nowInSec, Dispatcher.RequestTime requestTime) {
        int userLimit = this.getLimit(options);
        int userPerPartitionLimit = this.getPerPartitionLimit(options);
        int pageSize = options.getPageSize();
        Selection.Selectors selectors = this.selection.newSelectors(options);
        AggregationSpecification aggregationSpec = this.getAggregationSpec(options);
        ReadQuery query = this.getQuery(options, state.getClientState(), selectors.getColumnFilter(), nowInSec, userLimit, userPerPartitionLimit, pageSize, aggregationSpec);
        try (ReadExecutionController executionController = query.executionController();){
            if (aggregationSpec == null && (pageSize <= 0 || query.limits().count() <= pageSize)) {
                try (PartitionIterator data = query.executeInternal(executionController);){
                    ResultMessage.Rows rows = this.processResults(data, options, selectors, nowInSec, userLimit, null);
                    return rows;
                }
            }
            QueryPager pager = this.getPager(query, options);
            ResultMessage.Rows rows = this.execute(state, Pager.forInternalQuery(pager, executionController), options, selectors, pageSize, nowInSec, userLimit, aggregationSpec, requestTime);
            return rows;
        }
    }

    private QueryPager getPager(ReadQuery query, QueryOptions options) {
        QueryPager pager = query.getPager(options.getPagingState(), options.getProtocolVersion());
        if (this.aggregationSpecFactory == null || query.isEmpty()) {
            return pager;
        }
        return new AggregationQueryPager(pager, query.limits());
    }

    /*
     * Exception decompiling
     */
    public Map<DecoratedKey, List<Row>> executeRawInternal(QueryOptions options, ClientState state, int nowInSec) throws RequestExecutionException, RequestValidationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [35[UNCONDITIONALDOLOOP]], but top level block is 36[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ResultSet process(PartitionIterator partitions, int nowInSec) throws InvalidRequestException {
        QueryOptions options = QueryOptions.DEFAULT;
        Selection.Selectors selectors = this.selection.newSelectors(options);
        return this.process(partitions, options, selectors, nowInSec, this.getLimit(options), this.getAggregationSpec(options));
    }

    @Override
    public String keyspace() {
        return this.table.keyspace;
    }

    public String table() {
        return this.table.name;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public StatementRestrictions getRestrictions() {
        return this.restrictions;
    }

    private ReadQuery getSliceCommands(QueryOptions options, ClientState state, ColumnFilter columnFilter, DataLimits limit, int nowInSec) {
        ClusteringIndexFilter filter;
        List<ByteBuffer> keys = this.restrictions.getPartitionKeys(options, state);
        if (keys.isEmpty()) {
            return ReadQuery.empty(this.table);
        }
        if (this.restrictions.keyIsInRelation()) {
            Guardrails.partitionKeysInSelect.guard(keys.size(), this.table.name, false, state);
        }
        if ((filter = this.makeClusteringIndexFilter(options, state, columnFilter)) == null || filter.isEmpty(this.table.comparator)) {
            return ReadQuery.empty(this.table);
        }
        RowFilter rowFilter = this.getRowFilter(options);
        ArrayList<DecoratedKey> decoratedKeys = new ArrayList<DecoratedKey>(keys.size());
        for (ByteBuffer key : keys) {
            QueryProcessor.validateKey(key);
            decoratedKeys.add(this.table.partitioner.decorateKey(ByteBufferUtil.clone(key)));
        }
        return SinglePartitionReadQuery.createGroup(this.table, nowInSec, columnFilter, rowFilter, limit, decoratedKeys, filter);
    }

    public Slices clusteringIndexFilterAsSlices() {
        ColumnFilter columnFilter;
        ClientState state;
        QueryOptions options = QueryOptions.forInternalCalls(Collections.emptyList());
        ClusteringIndexFilter filter = this.makeClusteringIndexFilter(options, state = ClientState.forInternalCalls(), columnFilter = this.selection.newSelectors(options).getColumnFilter());
        if (filter instanceof ClusteringIndexSliceFilter) {
            return ((ClusteringIndexSliceFilter)filter).requestedSlices();
        }
        Slices.Builder builder = new Slices.Builder(this.table.comparator);
        for (Clustering<?> clustering : ((ClusteringIndexNamesFilter)filter).requestedRows()) {
            builder.add(Slice.make(clustering));
        }
        return builder.build();
    }

    public SinglePartitionReadCommand internalReadForView(DecoratedKey key, int nowInSec) {
        QueryOptions options = QueryOptions.forInternalCalls(Collections.emptyList());
        ClientState state = ClientState.forInternalCalls();
        ColumnFilter columnFilter = this.selection.newSelectors(options).getColumnFilter();
        ClusteringIndexFilter filter = this.makeClusteringIndexFilter(options, state, columnFilter);
        RowFilter rowFilter = this.getRowFilter(options);
        return SinglePartitionReadCommand.create(this.table, nowInSec, columnFilter, rowFilter, DataLimits.NONE, key, filter);
    }

    public RowFilter rowFilterForInternalCalls() {
        return this.getRowFilter(QueryOptions.forInternalCalls(Collections.emptyList()));
    }

    private ReadQuery getRangeCommand(QueryOptions options, ClientState state, ColumnFilter columnFilter, DataLimits limit, int nowInSec) {
        ClusteringIndexFilter clusteringIndexFilter = this.makeClusteringIndexFilter(options, state, columnFilter);
        if (clusteringIndexFilter == null) {
            return ReadQuery.empty(this.table);
        }
        RowFilter rowFilter = this.getRowFilter(options);
        AbstractBounds<PartitionPosition> keyBounds = this.restrictions.getPartitionKeyBounds(options);
        if (keyBounds == null) {
            return ReadQuery.empty(this.table);
        }
        ReadQuery command = PartitionRangeReadQuery.create(this.table, nowInSec, columnFilter, rowFilter, limit, new DataRange(keyBounds, clusteringIndexFilter));
        command.maybeValidateIndex();
        return command;
    }

    private ClusteringIndexFilter makeClusteringIndexFilter(QueryOptions options, ClientState state, ColumnFilter columnFilter) {
        if (this.parameters.isDistinct) {
            return new ClusteringIndexSliceFilter(Slices.ALL, false);
        }
        if (this.restrictions.isColumnRange()) {
            Slices slices = this.makeSlices(options);
            if (slices == Slices.NONE && !this.selection.containsStaticColumns()) {
                return null;
            }
            return new ClusteringIndexSliceFilter(slices, this.isReversed);
        }
        NavigableSet<Clustering<?>> clusterings = this.getRequestedRows(options, state);
        if (clusterings.isEmpty() && columnFilter.fetchedColumns().statics.isEmpty()) {
            return null;
        }
        return new ClusteringIndexNamesFilter(clusterings, this.isReversed);
    }

    @VisibleForTesting
    public Slices makeSlices(QueryOptions options) throws InvalidRequestException {
        NavigableSet<ClusteringBound<?>> startBounds = this.restrictions.getClusteringColumnsBounds(Bound.START, options);
        NavigableSet<ClusteringBound<?>> endBounds = this.restrictions.getClusteringColumnsBounds(Bound.END, options);
        assert (startBounds.size() == endBounds.size());
        if (startBounds.size() == 1) {
            ClusteringBound end;
            ClusteringBound start = (ClusteringBound)startBounds.first();
            return Slice.isEmpty(this.table.comparator, start, end = (ClusteringBound)endBounds.first()) ? Slices.NONE : Slices.with(this.table.comparator, Slice.make(start, end));
        }
        Slices.Builder builder = new Slices.Builder(this.table.comparator, startBounds.size());
        Iterator startIter = startBounds.iterator();
        Iterator endIter = endBounds.iterator();
        while (startIter.hasNext() && endIter.hasNext()) {
            ClusteringBound end;
            ClusteringBound start = (ClusteringBound)startIter.next();
            if (Slice.isEmpty(this.table.comparator, start, end = (ClusteringBound)endIter.next())) continue;
            builder.add(start, end);
        }
        return builder.build();
    }

    private DataLimits getDataLimits(int userLimit, int perPartitionLimit, int pageSize, AggregationSpecification aggregationSpec) {
        int cqlRowLimit = Integer.MAX_VALUE;
        int cqlPerPartitionLimit = Integer.MAX_VALUE;
        if (aggregationSpec != AggregationSpecification.AGGREGATE_EVERYTHING) {
            if (!this.needsPostQueryOrdering()) {
                cqlRowLimit = userLimit;
            }
            cqlPerPartitionLimit = perPartitionLimit;
        }
        if (pageSize <= 0) {
            pageSize = 10000;
        }
        if (aggregationSpec != null && aggregationSpec != AggregationSpecification.AGGREGATE_EVERYTHING) {
            if (this.parameters.isDistinct) {
                return DataLimits.distinctLimits(cqlRowLimit);
            }
            return DataLimits.groupByLimits(cqlRowLimit, cqlPerPartitionLimit, pageSize, aggregationSpec);
        }
        if (this.parameters.isDistinct) {
            return cqlRowLimit == Integer.MAX_VALUE ? DataLimits.DISTINCT_NONE : DataLimits.distinctLimits(cqlRowLimit);
        }
        return DataLimits.cqlLimits(cqlRowLimit, cqlPerPartitionLimit);
    }

    public int getLimit(QueryOptions options) {
        return this.getLimit(this.limit, options);
    }

    public int getPerPartitionLimit(QueryOptions options) {
        return this.getLimit(this.perPartitionLimit, options);
    }

    private int getLimit(Term limit, QueryOptions options) {
        ByteBuffer b;
        int userLimit = Integer.MAX_VALUE;
        if (limit != null && (b = RequestValidations.checkNotNull(limit.bindAndGet(options), "Invalid null value of limit")) != ByteBufferUtil.UNSET_BYTE_BUFFER) {
            try {
                Int32Type.instance.validate(b);
                userLimit = (Integer)Int32Type.instance.compose(b);
                RequestValidations.checkTrue(userLimit > 0, "LIMIT must be strictly positive");
            }
            catch (MarshalException e) {
                throw new InvalidRequestException("Invalid limit value");
            }
        }
        return userLimit;
    }

    private NavigableSet<Clustering<?>> getRequestedRows(QueryOptions options, ClientState state) throws InvalidRequestException {
        assert (!this.restrictions.isColumnRange());
        return this.restrictions.getClusteringColumns(options, state);
    }

    public RowFilter getRowFilter(QueryOptions options) throws InvalidRequestException {
        IndexRegistry indexRegistry = IndexRegistry.obtain(this.table);
        return this.restrictions.getRowFilter(indexRegistry, options);
    }

    private ResultSet process(PartitionIterator partitions, QueryOptions options, Selection.Selectors selectors, int nowInSec, int userLimit, AggregationSpecification aggregationSpec) throws InvalidRequestException {
        GroupMaker groupMaker = aggregationSpec == null ? null : aggregationSpec.newGroupMaker();
        ResultSetBuilder result = new ResultSetBuilder(this.getResultMetadata(), selectors, groupMaker);
        while (partitions.hasNext()) {
            RowIterator partition = (RowIterator)partitions.next();
            Throwable throwable = null;
            try {
                this.processPartition(partition, options, result, nowInSec);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
        ResultSet cqlRows = result.build();
        this.maybeWarn(result, options);
        this.orderResults(cqlRows);
        cqlRows.trim(userLimit);
        return cqlRows;
    }

    public static ByteBuffer[] getComponents(TableMetadata metadata, DecoratedKey dk) {
        ByteBuffer key = dk.getKey();
        if (metadata.partitionKeyType instanceof CompositeType) {
            return ((CompositeType)metadata.partitionKeyType).split(key);
        }
        return new ByteBuffer[]{key};
    }

    private void maybeWarn(ResultSetBuilder result, QueryOptions options) {
        if (!options.isReadThresholdsEnabled()) {
            return;
        }
        ColumnFamilyStore store = this.cfs();
        if (store != null) {
            store.metric.coordinatorReadSize.update(result.getSize());
        }
        if (result.shouldWarn(options.getCoordinatorReadSizeWarnThresholdBytes())) {
            String msg = String.format("Read on table %s has exceeded the size warning threshold of %,d bytes", this.table, options.getCoordinatorReadSizeWarnThresholdBytes());
            ClientState state = ClientState.forInternalCalls();
            ClientWarn.instance.warn(msg + " with " + this.loggableTokens(options, state));
            logger.warn("{} with query {}", (Object)msg, (Object)this.asCQL(options, state));
            if (store != null) {
                store.metric.coordinatorReadSizeWarnings.mark();
            }
        }
    }

    private void maybeFail(ResultSetBuilder result, QueryOptions options) {
        if (!options.isReadThresholdsEnabled()) {
            return;
        }
        if (result.shouldReject(options.getCoordinatorReadSizeAbortThresholdBytes())) {
            String msg = String.format("Read on table %s has exceeded the size failure threshold of %,d bytes", this.table, options.getCoordinatorReadSizeAbortThresholdBytes());
            ClientState state = ClientState.forInternalCalls();
            String clientMsg = msg + " with " + this.loggableTokens(options, state);
            ClientWarn.instance.warn(clientMsg);
            logger.warn("{} with query {}", (Object)msg, (Object)this.asCQL(options, state));
            ColumnFamilyStore store = this.cfs();
            if (store != null) {
                store.metric.coordinatorReadSizeAborts.mark();
                store.metric.coordinatorReadSize.update(result.getSize());
            }
            ReadSizeAbortException exception = new ReadSizeAbortException(clientMsg, options.getConsistency(), 0, 1, true, ImmutableMap.of(FBUtilities.getBroadcastAddressAndPort(), RequestFailureReason.READ_SIZE));
            StorageProxy.recordReadRegularAbort(options.getConsistency(), exception);
            throw exception;
        }
    }

    private ColumnFamilyStore cfs() {
        return Schema.instance.getColumnFamilyStoreInstance(this.table.id);
    }

    public void processPartition(RowIterator partition, QueryOptions options, ResultSetBuilder result, int nowInSec) throws InvalidRequestException {
        this.maybeFail(result, options);
        ProtocolVersion protocolVersion = options.getProtocolVersion();
        ByteBuffer[] keyComponents = SelectStatement.getComponents(this.table, partition.partitionKey());
        Row staticRow = partition.staticRow();
        if (!partition.hasNext()) {
            if (!staticRow.isEmpty() && this.restrictions.returnStaticContentOnPartitionWithNoRows()) {
                result.newRow(partition.partitionKey(), (Clustering<?>)staticRow.clustering());
                this.maybeFail(result, options);
                block10: for (ColumnMetadata def : this.selection.getColumns()) {
                    switch (def.kind) {
                        case PARTITION_KEY: {
                            result.add(keyComponents[def.position()]);
                            continue block10;
                        }
                        case STATIC: {
                            SelectStatement.addValue(result, def, staticRow, nowInSec, protocolVersion);
                            continue block10;
                        }
                    }
                    result.add(null);
                }
            }
            return;
        }
        while (partition.hasNext()) {
            Row row = (Row)partition.next();
            result.newRow(partition.partitionKey(), (Clustering<?>)row.clustering());
            this.maybeFail(result, options);
            for (ColumnMetadata def : this.selection.getColumns()) {
                switch (def.kind) {
                    case PARTITION_KEY: {
                        result.add(keyComponents[def.position()]);
                        break;
                    }
                    case CLUSTERING: {
                        result.add(row.clustering().bufferAt(def.position()));
                        break;
                    }
                    case REGULAR: {
                        SelectStatement.addValue(result, def, row, nowInSec, protocolVersion);
                        break;
                    }
                    case STATIC: {
                        SelectStatement.addValue(result, def, staticRow, nowInSec, protocolVersion);
                    }
                }
            }
        }
    }

    private static void addValue(ResultSetBuilder result, ColumnMetadata def, Row row, int nowInSec, ProtocolVersion protocolVersion) {
        if (def.isComplex()) {
            assert (def.type.isMultiCell());
            ComplexColumnData complexData = row.getComplexColumnData(def);
            if (complexData == null) {
                result.add(null);
            } else if (def.type.isCollection()) {
                result.add(((CollectionType)def.type).serializeForNativeProtocol(complexData.iterator(), protocolVersion));
            } else {
                result.add(((UserType)def.type).serializeForNativeProtocol(complexData.iterator(), protocolVersion));
            }
        } else {
            result.add(row.getCell(def), nowInSec);
        }
    }

    private boolean needsPostQueryOrdering() {
        return this.restrictions.keyIsInRelation() && !this.parameters.orderings.isEmpty();
    }

    private void orderResults(ResultSet cqlRows) {
        if (cqlRows.size() == 0 || !this.needsPostQueryOrdering()) {
            return;
        }
        Collections.sort(cqlRows.rows, this.orderingComparator);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private String loggableTokens(QueryOptions options, ClientState state) {
        if (this.restrictions.isKeyRange() || this.restrictions.usesSecondaryIndexing()) {
            AbstractBounds<PartitionPosition> bounds = this.restrictions.getPartitionKeyBounds(options);
            return "token range: " + (bounds.inclusiveLeft() ? (char)'[' : '(') + ((PartitionPosition)bounds.left).getToken().toString() + ", " + ((PartitionPosition)bounds.right).getToken().toString() + (bounds.inclusiveRight() ? (char)']' : ')');
        }
        List<ByteBuffer> keys = this.restrictions.getPartitionKeys(options, state);
        if (keys.size() == 1) {
            return "token: " + this.table.partitioner.getToken(Iterables.getOnlyElement(keys)).toString();
        }
        StringBuilder sb = new StringBuilder("tokens: [");
        boolean isFirst = true;
        for (ByteBuffer key : keys) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(this.table.partitioner.getToken(key).toString());
            isFirst = false;
        }
        return sb.append(']').toString();
    }

    private String asCQL(QueryOptions options, ClientState state) {
        ColumnFilter columnFilter = this.selection.newSelectors(options).getColumnFilter();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(this.queriedColumns().toCQLString());
        sb.append(" FROM ").append(this.table.keyspace).append('.').append(this.table.name);
        if (this.restrictions.isKeyRange() || this.restrictions.usesSecondaryIndexing()) {
            ClusteringIndexFilter clusteringIndexFilter = this.makeClusteringIndexFilter(options, state, columnFilter);
            if (clusteringIndexFilter == null) {
                return "EMPTY";
            }
            RowFilter rowFilter = this.getRowFilter(options);
            AbstractBounds<PartitionPosition> keyBounds = this.restrictions.getPartitionKeyBounds(options);
            if (keyBounds == null) {
                return "EMPTY";
            }
            DataRange dataRange = new DataRange(keyBounds, clusteringIndexFilter);
            if (!dataRange.isUnrestricted(this.table) || !rowFilter.isEmpty()) {
                sb.append(" WHERE ");
                if (!rowFilter.isEmpty()) {
                    sb.append(rowFilter);
                    if (!dataRange.isUnrestricted(this.table)) {
                        sb.append(" AND ");
                    }
                }
                if (!dataRange.isUnrestricted(this.table)) {
                    sb.append(dataRange.toCQLString(this.table, rowFilter));
                }
            }
        } else {
            String filterString;
            RowFilter rowFilter;
            boolean compoundPk;
            List<ByteBuffer> keys = this.restrictions.getPartitionKeys(options, state);
            if (keys.isEmpty()) {
                return "EMPTY";
            }
            ClusteringIndexFilter filter = this.makeClusteringIndexFilter(options, state, columnFilter);
            if (filter == null) {
                return "EMPTY";
            }
            sb.append(" WHERE ");
            boolean bl = compoundPk = this.table.partitionKeyColumns().size() > 1;
            if (compoundPk) {
                sb.append('(');
            }
            sb.append(ColumnMetadata.toCQLString(this.table.partitionKeyColumns()));
            if (compoundPk) {
                sb.append(')');
            }
            if (keys.size() == 1) {
                sb.append(" = ");
                if (compoundPk) {
                    sb.append('(');
                }
                DataRange.appendKeyString(sb, this.table.partitionKeyType, Iterables.getOnlyElement(keys));
                if (compoundPk) {
                    sb.append(')');
                }
            } else {
                sb.append(" IN (");
                boolean first = true;
                for (ByteBuffer key : keys) {
                    if (!first) {
                        sb.append(", ");
                    }
                    if (compoundPk) {
                        sb.append('(');
                    }
                    DataRange.appendKeyString(sb, this.table.partitionKeyType, key);
                    if (compoundPk) {
                        sb.append(')');
                    }
                    first = false;
                }
                sb.append(')');
            }
            if (!(rowFilter = this.getRowFilter(options)).isEmpty()) {
                sb.append(" AND ").append(rowFilter);
            }
            if (!(filterString = filter.toCQLString(this.table, rowFilter)).isEmpty()) {
                sb.append(" AND ").append(filterString);
            }
        }
        DataLimits limits = this.getDataLimits(this.getLimit(options), this.getPerPartitionLimit(options), options.getPageSize(), this.getAggregationSpec(options));
        if (limits != DataLimits.NONE) {
            sb.append(' ').append(limits);
        }
        return sb.toString();
    }

    private static class CompositeComparator
    extends ColumnComparator<List<ByteBuffer>> {
        private final List<Comparator<ByteBuffer>> orderTypes;
        private final List<Integer> positions;

        private CompositeComparator(List<Comparator<ByteBuffer>> orderTypes, List<Integer> positions) {
            this.orderTypes = orderTypes;
            this.positions = positions;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            for (int i = 0; i < this.positions.size(); ++i) {
                int columnPos;
                Comparator<ByteBuffer> type = this.orderTypes.get(i);
                int comparison = this.compare(type, a.get(columnPos = this.positions.get(i).intValue()), b.get(columnPos));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    private static class SingleColumnComparator
    extends ColumnComparator<List<ByteBuffer>> {
        private final int index;
        private final Comparator<ByteBuffer> comparator;

        public SingleColumnComparator(int columnIndex, Comparator<ByteBuffer> orderer) {
            this.index = columnIndex;
            this.comparator = orderer;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            return this.compare(this.comparator, a.get(this.index), b.get(this.index));
        }
    }

    private static abstract class ColumnComparator<T>
    implements Comparator<T> {
        private ColumnComparator() {
        }

        protected final int compare(Comparator<ByteBuffer> comparator, ByteBuffer aValue, ByteBuffer bValue) {
            if (aValue == null) {
                return bValue == null ? 0 : -1;
            }
            return bValue == null ? 1 : comparator.compare(aValue, bValue);
        }
    }

    public static class Parameters {
        public final Map<ColumnIdentifier, Boolean> orderings;
        public final List<Selectable.Raw> groups;
        public final boolean isDistinct;
        public final boolean allowFiltering;
        public final boolean isJson;

        public Parameters(Map<ColumnIdentifier, Boolean> orderings, List<Selectable.Raw> groups, boolean isDistinct, boolean allowFiltering, boolean isJson) {
            this.orderings = orderings;
            this.groups = groups;
            this.isDistinct = isDistinct;
            this.allowFiltering = allowFiltering;
            this.isJson = isJson;
        }
    }

    public static class RawStatement
    extends QualifiedStatement {
        public final Parameters parameters;
        public final List<RawSelector> selectClause;
        public final WhereClause whereClause;
        public final Term.Raw limit;
        public final Term.Raw perPartitionLimit;
        private ClientState state;

        public RawStatement(QualifiedName cfName, Parameters parameters, List<RawSelector> selectClause, WhereClause whereClause, Term.Raw limit, Term.Raw perPartitionLimit) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause;
            this.limit = limit;
            this.perPartitionLimit = perPartitionLimit;
        }

        @Override
        public SelectStatement prepare(ClientState state) {
            this.state = state;
            return this.prepare(false);
        }

        public SelectStatement prepare(boolean forView) throws InvalidRequestException {
            AggregationSpecification.Factory aggregationSpecFactory;
            TableMetadata table = Schema.instance.validateTable(this.keyspace(), this.name());
            List<Selectable> selectables = RawSelector.toSelectables(this.selectClause, table);
            boolean containsOnlyStaticColumns = this.selectOnlyStaticColumns(table, selectables);
            StatementRestrictions restrictions = this.prepareRestrictions(table, this.bindVariables, containsOnlyStaticColumns, forView);
            Map<ColumnMetadata, Boolean> orderingColumns = this.getOrderingColumns(table);
            Set<ColumnMetadata> resultSetOrderingColumns = restrictions.keyIsInRelation() ? orderingColumns.keySet() : Collections.emptySet();
            Selection selection = this.prepareSelection(table, selectables, this.bindVariables, resultSetOrderingColumns, restrictions);
            if (this.parameters.isDistinct) {
                RequestValidations.checkNull(this.perPartitionLimit, "PER PARTITION LIMIT is not allowed with SELECT DISTINCT queries");
                RawStatement.validateDistinctSelection(table, selection, restrictions);
            }
            RequestValidations.checkFalse((aggregationSpecFactory = this.getAggregationSpecFactory(table, this.bindVariables, selection, restrictions, this.parameters.isDistinct)) == AggregationSpecification.AGGREGATE_EVERYTHING_FACTORY && this.perPartitionLimit != null, "PER PARTITION LIMIT is not allowed with aggregate queries.");
            Comparator<List<ByteBuffer>> orderingComparator = null;
            boolean isReversed = false;
            if (!orderingColumns.isEmpty()) {
                assert (!forView);
                RawStatement.verifyOrderingIsAllowed(restrictions);
                orderingComparator = this.getOrderingComparator(selection, restrictions, orderingColumns);
                isReversed = this.isReversed(table, orderingColumns, restrictions);
                if (isReversed) {
                    orderingComparator = Collections.reverseOrder(orderingComparator);
                }
            }
            this.checkNeedsFiltering(restrictions);
            return new SelectStatement(table, this.bindVariables, this.parameters, selection, restrictions, isReversed, aggregationSpecFactory, orderingComparator, this.prepareLimit(this.bindVariables, this.limit, this.keyspace(), this.limitReceiver()), this.prepareLimit(this.bindVariables, this.perPartitionLimit, this.keyspace(), this.perPartitionLimitReceiver()));
        }

        private Selection prepareSelection(TableMetadata table, List<Selectable> selectables, VariableSpecifications boundNames, Set<ColumnMetadata> resultSetOrderingColumns, StatementRestrictions restrictions) {
            boolean hasGroupBy;
            boolean bl = hasGroupBy = !this.parameters.groups.isEmpty();
            if (hasGroupBy) {
                Guardrails.groupByEnabled.ensureEnabled(this.state);
            }
            if (selectables.isEmpty()) {
                return hasGroupBy ? Selection.wildcardWithGroupBy(table, boundNames, this.parameters.isJson, restrictions.returnStaticContentOnPartitionWithNoRows()) : Selection.wildcard(table, this.parameters.isJson, restrictions.returnStaticContentOnPartitionWithNoRows());
            }
            return Selection.fromSelectors(table, selectables, boundNames, resultSetOrderingColumns, restrictions.nonPKRestrictedColumns(false), hasGroupBy, this.parameters.isJson, restrictions.returnStaticContentOnPartitionWithNoRows());
        }

        private boolean selectOnlyStaticColumns(TableMetadata table, List<Selectable> selectables) {
            if (table.isStaticCompactTable()) {
                return false;
            }
            if (!table.hasStaticColumns() || selectables.isEmpty()) {
                return false;
            }
            return Selectable.selectColumns(selectables, column -> column.isStatic()) && !Selectable.selectColumns(selectables, column -> !column.isPartitionKey() && !column.isStatic());
        }

        private Map<ColumnMetadata, Boolean> getOrderingColumns(TableMetadata table) {
            if (this.parameters.orderings.isEmpty()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<ColumnMetadata, Boolean> orderingColumns = new LinkedHashMap<ColumnMetadata, Boolean>();
            for (Map.Entry<ColumnIdentifier, Boolean> entry : this.parameters.orderings.entrySet()) {
                orderingColumns.put(table.getExistingColumn(entry.getKey()), entry.getValue());
            }
            return orderingColumns;
        }

        private StatementRestrictions prepareRestrictions(TableMetadata metadata, VariableSpecifications boundNames, boolean selectsOnlyStaticColumns, boolean forView) throws InvalidRequestException {
            return new StatementRestrictions(StatementType.SELECT, metadata, this.whereClause, boundNames, selectsOnlyStaticColumns, this.parameters.allowFiltering, forView);
        }

        private Term prepareLimit(VariableSpecifications boundNames, Term.Raw limit, String keyspace, ColumnSpecification limitReceiver) throws InvalidRequestException {
            if (limit == null) {
                return null;
            }
            Term prepLimit = limit.prepare(keyspace, limitReceiver);
            prepLimit.collectMarkerSpecification(boundNames);
            return prepLimit;
        }

        private static void verifyOrderingIsAllowed(StatementRestrictions restrictions) throws InvalidRequestException {
            RequestValidations.checkFalse(restrictions.usesSecondaryIndexing(), "ORDER BY with 2ndary indexes is not supported.");
            RequestValidations.checkFalse(restrictions.isKeyRange(), "ORDER BY is only supported when the partition key is restricted by an EQ or an IN.");
        }

        private static void validateDistinctSelection(TableMetadata metadata, Selection selection, StatementRestrictions restrictions) throws InvalidRequestException {
            RequestValidations.checkFalse(restrictions.hasClusteringColumnsRestrictions() || restrictions.hasNonPrimaryKeyRestrictions() && !restrictions.nonPKRestrictedColumns(true).stream().allMatch(ColumnMetadata::isStatic), "SELECT DISTINCT with WHERE clause only supports restriction by partition key and/or static columns.");
            List<ColumnMetadata> requestedColumns = selection.getColumns();
            for (ColumnMetadata def : requestedColumns) {
                RequestValidations.checkFalse(!def.isPartitionKey() && !def.isStatic(), "SELECT DISTINCT queries must only request partition key columns and/or static columns (not %s)", def.name);
            }
            if (!restrictions.isKeyRange()) {
                return;
            }
            for (ColumnMetadata def : metadata.partitionKeyColumns()) {
                RequestValidations.checkTrue(requestedColumns.contains(def), "SELECT DISTINCT queries must request all the partition key columns (missing %s)", def.name);
            }
        }

        private AggregationSpecification.Factory getAggregationSpecFactory(TableMetadata metadata, VariableSpecifications boundNames, Selection selection, StatementRestrictions restrictions, boolean isDistinct) {
            if (this.parameters.groups.isEmpty()) {
                return selection.isAggregate() ? AggregationSpecification.AGGREGATE_EVERYTHING_FACTORY : null;
            }
            int clusteringPrefixSize = 0;
            Iterator<ColumnMetadata> pkColumns = metadata.primaryKeyColumns().iterator();
            Selector.Factory selectorFactory = null;
            block0: for (Selectable.Raw raw : this.parameters.groups) {
                Selectable selectable = raw.prepare(metadata);
                ColumnMetadata def = null;
                if (selectable instanceof Selectable.WithFunction) {
                    Selectable.WithFunction withFunction = (Selectable.WithFunction)selectable;
                    this.validateGroupByFunction(withFunction);
                    ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
                    selectorFactory = selectable.newSelectorFactory(metadata, null, columns, boundNames);
                    RequestValidations.checkFalse(columns.isEmpty(), "GROUP BY functions must have one clustering column name as parameter");
                    if (columns.size() > 1) {
                        throw RequestValidations.invalidRequest("GROUP BY functions accept only one clustering column as parameter, got: %s", columns.stream().map(c -> c.name.toCQLString()).collect(Collectors.joining(",")));
                    }
                    def = (ColumnMetadata)columns.get(0);
                    RequestValidations.checkTrue(def.isClusteringColumn(), "Group by functions are only supported on clustering columns, got %s", def.name);
                } else {
                    def = (ColumnMetadata)selectable;
                    RequestValidations.checkTrue(def.isPartitionKey() || def.isClusteringColumn(), "Group by is currently only supported on the columns of the PRIMARY KEY, got %s", def.name);
                    RequestValidations.checkNull(selectorFactory, "Functions are only supported on the last element of the GROUP BY clause");
                }
                while (true) {
                    RequestValidations.checkTrue(pkColumns.hasNext(), "Group by currently only support groups of columns following their declared order in the PRIMARY KEY");
                    ColumnMetadata pkColumn = pkColumns.next();
                    if (pkColumn.isClusteringColumn()) {
                        ++clusteringPrefixSize;
                    }
                    if (pkColumn.equals(def)) continue block0;
                    RequestValidations.checkTrue(restrictions.isColumnRestrictedByEq(pkColumn), "Group by currently only support groups of columns following their declared order in the PRIMARY KEY");
                }
            }
            RequestValidations.checkFalse(pkColumns.hasNext() && pkColumns.next().isPartitionKey(), "Group by is not supported on only a part of the partition key");
            RequestValidations.checkFalse(clusteringPrefixSize > 0 && isDistinct, "Grouping on clustering columns is not allowed for SELECT DISTINCT queries");
            return selectorFactory == null ? AggregationSpecification.aggregatePkPrefixFactory(metadata.comparator, clusteringPrefixSize) : AggregationSpecification.aggregatePkPrefixFactoryWithSelector(metadata.comparator, clusteringPrefixSize, selectorFactory);
        }

        private void validateGroupByFunction(Selectable.WithFunction withFunction) {
            Function f = withFunction.function;
            RequestValidations.checkFalse(f.isAggregate(), "Aggregate functions are not supported within the GROUP BY clause, got: %s", f.name());
        }

        private Comparator<List<ByteBuffer>> getOrderingComparator(Selection selection, StatementRestrictions restrictions, Map<ColumnMetadata, Boolean> orderingColumns) throws InvalidRequestException {
            if (!restrictions.keyIsInRelation()) {
                return null;
            }
            ArrayList<Integer> idToSort = new ArrayList<Integer>(orderingColumns.size());
            ArrayList<AbstractType> sorters = new ArrayList<AbstractType>(orderingColumns.size());
            for (ColumnMetadata orderingColumn : orderingColumns.keySet()) {
                idToSort.add(selection.getOrderingIndex(orderingColumn));
                sorters.add(orderingColumn.type);
            }
            return idToSort.size() == 1 ? new SingleColumnComparator((Integer)idToSort.get(0), (Comparator)sorters.get(0)) : new CompositeComparator(sorters, idToSort);
        }

        private boolean isReversed(TableMetadata table, Map<ColumnMetadata, Boolean> orderingColumns, StatementRestrictions restrictions) throws InvalidRequestException {
            Boolean[] reversedMap = new Boolean[table.clusteringColumns().size()];
            int i = 0;
            for (Map.Entry<ColumnMetadata, Boolean> entry : orderingColumns.entrySet()) {
                ColumnMetadata def = entry.getKey();
                boolean reversed = entry.getValue();
                RequestValidations.checkTrue(def.isClusteringColumn(), "Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", def.name);
                while (i != def.position()) {
                    RequestValidations.checkTrue(restrictions.isColumnRestrictedByEq((ColumnMetadata)table.clusteringColumns().get(i++)), "Order by currently only supports the ordering of columns following their declared order in the PRIMARY KEY");
                }
                ++i;
                reversedMap[def.position()] = reversed != def.isReversedType();
            }
            Boolean isReversed = null;
            for (Boolean b : reversedMap) {
                if (b == null) continue;
                if (isReversed == null) {
                    isReversed = b;
                    continue;
                }
                RequestValidations.checkTrue(isReversed.equals(b), "Unsupported order by relation");
            }
            assert (isReversed != null);
            return isReversed;
        }

        private void checkNeedsFiltering(StatementRestrictions restrictions) throws InvalidRequestException {
            if (!this.parameters.allowFiltering && (restrictions.isKeyRange() || restrictions.usesSecondaryIndexing())) {
                RequestValidations.checkFalse(restrictions.needFiltering(), "Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING");
            }
        }

        private ColumnSpecification limitReceiver() {
            return new ColumnSpecification(this.keyspace(), this.name(), new ColumnIdentifier("[limit]", true), Int32Type.instance);
        }

        private ColumnSpecification perPartitionLimitReceiver() {
            return new ColumnSpecification(this.keyspace(), this.name(), new ColumnIdentifier("[per_partition_limit]", true), Int32Type.instance);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", this.qualifiedName).add("selectClause", this.selectClause).add("whereClause", this.whereClause).add("isDistinct", this.parameters.isDistinct).toString();
        }
    }

    private static abstract class Pager {
        protected QueryPager pager;

        protected Pager(QueryPager pager) {
            this.pager = pager;
        }

        public static Pager forInternalQuery(QueryPager pager, ReadExecutionController executionController) {
            return new InternalPager(pager, executionController);
        }

        public static Pager forDistributedQuery(QueryPager pager, ConsistencyLevel consistency, ClientState clientState) {
            return new NormalPager(pager, consistency, clientState);
        }

        public boolean isExhausted() {
            return this.pager.isExhausted();
        }

        public PagingState state() {
            return this.pager.state();
        }

        public abstract PartitionIterator fetchPage(int var1, Dispatcher.RequestTime var2);

        public static class InternalPager
        extends Pager {
            private final ReadExecutionController executionController;

            private InternalPager(QueryPager pager, ReadExecutionController executionController) {
                super(pager);
                this.executionController = executionController;
            }

            @Override
            public PartitionIterator fetchPage(int pageSize, Dispatcher.RequestTime requestTime) {
                return this.pager.fetchPageInternal(pageSize, this.executionController);
            }
        }

        public static class NormalPager
        extends Pager {
            private final ConsistencyLevel consistency;
            private final ClientState clientState;

            private NormalPager(QueryPager pager, ConsistencyLevel consistency, ClientState clientState) {
                super(pager);
                this.consistency = consistency;
                this.clientState = clientState;
            }

            @Override
            public PartitionIterator fetchPage(int pageSize, Dispatcher.RequestTime requestTime) {
                return this.pager.fetchPage(pageSize, this.consistency, this.clientState, requestTime);
            }
        }
    }
}

