/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.base.Objects;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.Pair;

final class MapSelector
extends Selector {
    protected static final Selector.SelectorDeserializer deserializer = new Selector.SelectorDeserializer(){

        @Override
        protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            MapType type = (MapType)this.readType(metadata, in);
            int size = (int)in.readUnsignedVInt();
            ArrayList<Pair<Selector, Selector>> entries = new ArrayList<Pair<Selector, Selector>>(size);
            for (int i = 0; i < size; ++i) {
                Pair<Selector, Selector> entry = Pair.create(Selector.serializer.deserialize(in, version, metadata), Selector.serializer.deserialize(in, version, metadata));
                entries.add(entry);
            }
            return new MapSelector(type, entries);
        }
    };
    private final MapType<?, ?> type;
    private final List<Pair<Selector, Selector>> elements;

    public static Selector.Factory newFactory(final AbstractType<?> type, final List<Pair<Selector.Factory, Selector.Factory>> factories) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return Maps.mapToString(factories, Selector.Factory::getColumnName);
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return type;
            }

            @Override
            protected final void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
                SelectionColumnMapping tmpMapping = SelectionColumnMapping.newMapping();
                for (Pair entry : factories) {
                    ((Selector.Factory)entry.left).addColumnMapping(tmpMapping, resultsColumn);
                    ((Selector.Factory)entry.right).addColumnMapping(tmpMapping, resultsColumn);
                }
                if (tmpMapping.getMappings().get(resultsColumn).isEmpty()) {
                    mapping.addMapping(resultsColumn, (ColumnMetadata)null);
                } else {
                    mapping.addMapping(resultsColumn, tmpMapping.getMappings().values());
                }
            }

            @Override
            public Selector newInstance(QueryOptions options) {
                return new MapSelector(type, factories.stream().map(p -> Pair.create(((Selector.Factory)p.left).newInstance(options), ((Selector.Factory)p.right).newInstance(options))).collect(Collectors.toList()));
            }

            @Override
            public boolean isAggregateSelectorFactory() {
                for (Pair entry : factories) {
                    if (!((Selector.Factory)entry.left).isAggregateSelectorFactory() && !((Selector.Factory)entry.right).isAggregateSelectorFactory()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void addFunctionsTo(List<Function> functions) {
                for (Pair entry : factories) {
                    ((Selector.Factory)entry.left).addFunctionsTo(functions);
                    ((Selector.Factory)entry.right).addFunctionsTo(functions);
                }
            }

            @Override
            public boolean isWritetimeSelectorFactory() {
                for (Pair entry : factories) {
                    if (!((Selector.Factory)entry.left).isWritetimeSelectorFactory() && !((Selector.Factory)entry.right).isWritetimeSelectorFactory()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isTTLSelectorFactory() {
                for (Pair entry : factories) {
                    if (!((Selector.Factory)entry.left).isTTLSelectorFactory() && !((Selector.Factory)entry.right).isTTLSelectorFactory()) continue;
                    return true;
                }
                return false;
            }

            @Override
            boolean areAllFetchedColumnsKnown() {
                for (Pair entry : factories) {
                    if (((Selector.Factory)entry.left).areAllFetchedColumnsKnown() && ((Selector.Factory)entry.right).areAllFetchedColumnsKnown()) continue;
                    return false;
                }
                return true;
            }

            @Override
            void addFetchedColumns(ColumnFilter.Builder builder) {
                for (Pair entry : factories) {
                    ((Selector.Factory)entry.left).addFetchedColumns(builder);
                    ((Selector.Factory)entry.right).addFetchedColumns(builder);
                }
            }
        };
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            Pair<Selector, Selector> pair = this.elements.get(i);
            ((Selector)pair.left).addFetchedColumns(builder);
            ((Selector)pair.right).addFetchedColumns(builder);
        }
    }

    @Override
    public void addInput(ProtocolVersion protocolVersion, Selector.InputRow input) {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            Pair<Selector, Selector> pair = this.elements.get(i);
            ((Selector)pair.left).addInput(protocolVersion, input);
            ((Selector)pair.right).addInput(protocolVersion, input);
        }
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) {
        TreeMap<ByteBuffer, ByteBuffer> map = new TreeMap<ByteBuffer, ByteBuffer>(this.type.getKeysType());
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            Pair<Selector, Selector> pair = this.elements.get(i);
            map.put(((Selector)pair.left).getOutput(protocolVersion), ((Selector)pair.right).getOutput(protocolVersion));
        }
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.elements.size() * 2);
        for (Map.Entry entry : map.entrySet()) {
            buffers.add((ByteBuffer)entry.getKey());
            buffers.add((ByteBuffer)entry.getValue());
        }
        return CollectionSerializer.pack(buffers, this.elements.size(), protocolVersion);
    }

    @Override
    public void reset() {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            Pair<Selector, Selector> pair = this.elements.get(i);
            ((Selector)pair.left).reset();
            ((Selector)pair.right).reset();
        }
    }

    @Override
    public boolean isTerminal() {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            Pair<Selector, Selector> pair = this.elements.get(i);
            if (((Selector)pair.left).isTerminal() && ((Selector)pair.right).isTerminal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public AbstractType<?> getType() {
        return this.type;
    }

    public String toString() {
        return Maps.mapToString(this.elements);
    }

    private MapSelector(AbstractType<?> type, List<Pair<Selector, Selector>> elements) {
        super(Selector.Kind.MAP_SELECTOR);
        this.type = (MapType)type;
        this.elements = elements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapSelector)) {
            return false;
        }
        MapSelector s = (MapSelector)o;
        return Objects.equal(this.type, s.type) && Objects.equal(this.elements, s.elements);
    }

    public int hashCode() {
        return Objects.hashCode(this.type, this.elements);
    }

    @Override
    protected int serializedSize(int version) {
        int size = MapSelector.sizeOf(this.type) + TypeSizes.sizeofUnsignedVInt(this.elements.size());
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            Pair<Selector, Selector> entry = this.elements.get(i);
            size += serializer.serializedSize((Selector)entry.left, version) + serializer.serializedSize((Selector)entry.right, version);
        }
        return size;
    }

    @Override
    protected void serialize(DataOutputPlus out, int version) throws IOException {
        MapSelector.writeType(out, this.type);
        out.writeUnsignedVInt(this.elements.size());
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            Pair<Selector, Selector> entry = this.elements.get(i);
            serializer.serialize((Selector)entry.left, out, version);
            serializer.serialize((Selector)entry.right, out, version);
        }
    }
}

