/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.nmoncho.shaded.com.google.common.base.Objects;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.selection.CollectionFactory;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.transport.ProtocolVersion;

final class ListSelector
extends Selector {
    protected static final Selector.SelectorDeserializer deserializer = new Selector.SelectorDeserializer(){

        @Override
        protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            ListType type = (ListType)this.readType(metadata, in);
            int size = (int)in.readUnsignedVInt();
            ArrayList<Selector> elements = new ArrayList<Selector>(size);
            for (int i = 0; i < size; ++i) {
                elements.add(Selector.serializer.deserialize(in, version, metadata));
            }
            return new ListSelector(type, elements);
        }
    };
    private final AbstractType<?> type;
    private final List<Selector> elements;

    public static Selector.Factory newFactory(final AbstractType<?> type, final SelectorFactories factories) {
        return new CollectionFactory(type, factories){

            @Override
            protected String getColumnName() {
                return Lists.listToString(factories, Selector.Factory::getColumnName);
            }

            @Override
            public Selector newInstance(QueryOptions options) {
                return new ListSelector(type, factories.newInstances(options));
            }
        };
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            this.elements.get(i).addFetchedColumns(builder);
        }
    }

    @Override
    public void addInput(ProtocolVersion protocolVersion, Selector.InputRow input) {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            this.elements.get(i).addInput(protocolVersion, input);
        }
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.elements.size());
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            buffers.add(this.elements.get(i).getOutput(protocolVersion));
        }
        return CollectionSerializer.pack(buffers, buffers.size(), protocolVersion);
    }

    @Override
    public void reset() {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            this.elements.get(i).reset();
        }
    }

    @Override
    public boolean isTerminal() {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            if (this.elements.get(i).isTerminal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public AbstractType<?> getType() {
        return this.type;
    }

    public String toString() {
        return Lists.listToString(this.elements);
    }

    private ListSelector(AbstractType<?> type, List<Selector> elements) {
        super(Selector.Kind.LIST_SELECTOR);
        this.type = type;
        this.elements = elements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSelector)) {
            return false;
        }
        ListSelector s = (ListSelector)o;
        return Objects.equal(this.type, s.type) && Objects.equal(this.elements, s.elements);
    }

    public int hashCode() {
        return Objects.hashCode(this.type, this.elements);
    }

    @Override
    protected int serializedSize(int version) {
        int size = ListSelector.sizeOf(this.type) + TypeSizes.sizeofUnsignedVInt(this.elements.size());
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            size += serializer.serializedSize(this.elements.get(i), version);
        }
        return size;
    }

    @Override
    protected void serialize(DataOutputPlus out, int version) throws IOException {
        ListSelector.writeType(out, this.type);
        out.writeUnsignedVInt(this.elements.size());
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            serializer.serialize(this.elements.get(i), out, version);
        }
    }
}

