/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.base.Objects;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.PartialScalarFunction;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.selection.AggregateFunctionSelector;
import org.apache.cassandra.cql3.selection.ScalarFunctionSelector;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.cql3.selection.TermSelector;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.text.StrBuilder;

abstract class AbstractFunctionSelector<T extends Function>
extends Selector {
    protected final T fun;
    private final List<ByteBuffer> args;
    protected final List<Selector> argSelectors;

    public static Selector.Factory newFactory(final Function fun, final SelectorFactories factories) throws InvalidRequestException {
        if (fun.isAggregate() && factories.doesAggregation()) {
            throw new InvalidRequestException("aggregate functions cannot be used as arguments of aggregate functions");
        }
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return fun.columnName(factories.getColumnNames());
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return fun.returnType();
            }

            @Override
            protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
                SelectionColumnMapping tmpMapping = SelectionColumnMapping.newMapping();
                for (Selector.Factory factory : factories) {
                    factory.addColumnMapping(tmpMapping, resultsColumn);
                }
                if (tmpMapping.getMappings().get(resultsColumn).isEmpty()) {
                    mapping.addMapping(resultsColumn, (ColumnMetadata)null);
                } else {
                    mapping.addMapping(resultsColumn, tmpMapping.getMappings().values());
                }
            }

            @Override
            public void addFunctionsTo(List<Function> functions) {
                fun.addFunctionsTo(functions);
                factories.addFunctionsTo(functions);
            }

            @Override
            public Selector newInstance(QueryOptions options) throws InvalidRequestException {
                return fun.isAggregate() ? new AggregateFunctionSelector(fun, factories.newInstances(options)) : this.createScalarSelector(options, (ScalarFunction)fun, factories.newInstances(options));
            }

            private Selector createScalarSelector(QueryOptions options, ScalarFunction function, List<Selector> argSelectors) {
                ProtocolVersion version = options.getProtocolVersion();
                int terminalCount = 0;
                ArrayList<ByteBuffer> terminalArgs = new ArrayList<ByteBuffer>(argSelectors.size());
                for (Selector selector : argSelectors) {
                    if (selector.isTerminal()) {
                        ++terminalCount;
                        ByteBuffer output = selector.getOutput(version);
                        RequestValidations.checkBindValueSet(output, "Invalid unset value for argument in call to function %s", fun.name().name);
                        terminalArgs.add(output);
                        continue;
                    }
                    terminalArgs.add(Function.UNRESOLVED);
                }
                if (terminalCount == 0) {
                    return new ScalarFunctionSelector(fun, argSelectors);
                }
                if (terminalCount == argSelectors.size() && function.isPure()) {
                    return new TermSelector(function.execute(version, terminalArgs), function.returnType());
                }
                ScalarFunction partialFunction = function.partialApplication(version, terminalArgs);
                ArrayList<Selector> remainingSelectors = new ArrayList<Selector>(argSelectors.size() - terminalCount);
                for (Selector selector : argSelectors) {
                    if (selector.isTerminal()) continue;
                    remainingSelectors.add(selector);
                }
                return new ScalarFunctionSelector(partialFunction, remainingSelectors);
            }

            @Override
            public boolean isWritetimeSelectorFactory() {
                return factories.containsWritetimeSelectorFactory();
            }

            @Override
            public boolean isTTLSelectorFactory() {
                return factories.containsTTLSelectorFactory();
            }

            @Override
            public boolean isAggregateSelectorFactory() {
                return fun.isAggregate() || factories.doesAggregation();
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return Iterables.all(factories, f -> f.areAllFetchedColumnsKnown());
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
                for (Selector.Factory factory : factories) {
                    factory.addFetchedColumns(builder);
                }
            }
        };
    }

    protected AbstractFunctionSelector(Selector.Kind kind, T fun, List<Selector> argSelectors) {
        super(kind);
        this.fun = fun;
        this.argSelectors = argSelectors;
        this.args = Arrays.asList(new ByteBuffer[argSelectors.size()]);
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        for (Selector selector : this.argSelectors) {
            selector.addFetchedColumns(builder);
        }
    }

    protected void setArg(int i, ByteBuffer value) throws InvalidRequestException {
        RequestValidations.checkBindValueSet(value, "Invalid unset value for argument in call to function %s", this.fun.name().name);
        this.args.set(i, value);
    }

    protected List<ByteBuffer> args() {
        return this.args;
    }

    @Override
    public AbstractType<?> getType() {
        return this.fun.returnType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractFunctionSelector)) {
            return false;
        }
        AbstractFunctionSelector s = (AbstractFunctionSelector)o;
        return Objects.equal(this.fun.name(), s.fun.name()) && Objects.equal(this.fun.argTypes(), s.fun.argTypes()) && Objects.equal(this.argSelectors, s.argSelectors);
    }

    public int hashCode() {
        return Objects.hashCode(this.fun.name(), this.fun.argTypes(), this.argSelectors);
    }

    public String toString() {
        return new StrBuilder().append((Object)this.fun.name()).append("(").appendWithSeparators(this.argSelectors, ", ").append(")").toString();
    }

    @Override
    protected int serializedSize(int version) {
        int i;
        boolean isPartial = this.fun instanceof PartialScalarFunction;
        T function = isPartial ? ((PartialScalarFunction)this.fun).getFunction() : this.fun;
        FunctionName name = function.name();
        int size = TypeSizes.sizeof(name.keyspace) + TypeSizes.sizeof(name.name);
        List<AbstractType<?>> argTypes = function.argTypes();
        size += TypeSizes.sizeofUnsignedVInt(argTypes.size());
        int m = argTypes.size();
        for (int i2 = 0; i2 < m; ++i2) {
            size += AbstractFunctionSelector.sizeOf(argTypes.get(i2));
        }
        size += TypeSizes.sizeof(isPartial);
        if (isPartial) {
            List<ByteBuffer> partialParameters = ((PartialScalarFunction)this.fun).getPartialParameters();
            size += TypeSizes.sizeofUnsignedVInt(this.computeBitSet(partialParameters));
            int m2 = partialParameters.size();
            for (i = 0; i < m2; ++i) {
                ByteBuffer buffer = partialParameters.get(i);
                if (buffer == Function.UNRESOLVED) continue;
                size += ByteBufferUtil.serializedSizeWithVIntLength(buffer);
            }
        }
        int numberOfRemainingArguments = this.argSelectors.size();
        size += TypeSizes.sizeofUnsignedVInt(numberOfRemainingArguments);
        for (i = 0; i < numberOfRemainingArguments; ++i) {
            size += serializer.serializedSize(this.argSelectors.get(i), version);
        }
        return size;
    }

    @Override
    protected void serialize(DataOutputPlus out, int version) throws IOException {
        int i;
        boolean isPartial = this.fun instanceof PartialScalarFunction;
        T function = isPartial ? ((PartialScalarFunction)this.fun).getFunction() : this.fun;
        FunctionName name = function.name();
        out.writeUTF(name.keyspace);
        out.writeUTF(name.name);
        List<AbstractType<?>> argTypes = function.argTypes();
        int numberOfArguments = argTypes.size();
        out.writeUnsignedVInt(numberOfArguments);
        for (int i2 = 0; i2 < numberOfArguments; ++i2) {
            AbstractFunctionSelector.writeType(out, argTypes.get(i2));
        }
        out.writeBoolean(isPartial);
        if (isPartial) {
            List<ByteBuffer> partialParameters = ((PartialScalarFunction)this.fun).getPartialParameters();
            out.writeUnsignedVInt(this.computeBitSet(partialParameters));
            int m = partialParameters.size();
            for (i = 0; i < m; ++i) {
                ByteBuffer buffer = partialParameters.get(i);
                if (buffer == Function.UNRESOLVED) continue;
                ByteBufferUtil.writeWithVIntLength(buffer, out);
            }
        }
        int numberOfRemainingArguments = this.argSelectors.size();
        out.writeUnsignedVInt(numberOfRemainingArguments);
        for (i = 0; i < numberOfRemainingArguments; ++i) {
            serializer.serialize(this.argSelectors.get(i), out, version);
        }
    }

    private int computeBitSet(List<ByteBuffer> partialParameters) {
        assert (partialParameters.size() <= 32) : "cannot serialize partial function with more than 32 parameters";
        int bitset = 0;
        int m = partialParameters.size();
        for (int i = 0; i < m; ++i) {
            if (partialParameters.get(i) == Function.UNRESOLVED) continue;
            bitset |= 1 << i;
        }
        return bitset;
    }

    protected static abstract class AbstractFunctionSelectorDeserializer
    extends Selector.SelectorDeserializer {
        protected AbstractFunctionSelectorDeserializer() {
        }

        @Override
        protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            int i;
            FunctionName name = new FunctionName(in.readUTF(), in.readUTF());
            int numberOfArguments = (int)in.readUnsignedVInt();
            ArrayList argTypes = new ArrayList(numberOfArguments);
            for (int i2 = 0; i2 < numberOfArguments; ++i2) {
                argTypes.add(this.readType(metadata, in));
            }
            Optional<Function> optional = Schema.instance.findFunction(name, argTypes);
            if (!optional.isPresent()) {
                throw new IOException(String.format("Unknown serialized function %s(%s)", name, argTypes.stream().map(p -> p.asCQL3Type().toString()).collect(Collectors.joining(", "))));
            }
            Function function = optional.get();
            boolean isPartial = in.readBoolean();
            if (isPartial) {
                int bitset = (int)in.readUnsignedVInt();
                ArrayList<ByteBuffer> partialParameters = new ArrayList<ByteBuffer>(numberOfArguments);
                for (i = 0; i < numberOfArguments; ++i) {
                    ByteBuffer parameter = (bitset & 1) == 1 ? ByteBufferUtil.readWithVIntLength(in) : Function.UNRESOLVED;
                    partialParameters.add(parameter);
                    bitset >>= 1;
                }
                function = ((ScalarFunction)function).partialApplication(ProtocolVersion.CURRENT, partialParameters);
            }
            int numberOfRemainingArguments = (int)in.readUnsignedVInt();
            ArrayList<Selector> argSelectors = new ArrayList<Selector>(numberOfRemainingArguments);
            for (i = 0; i < numberOfRemainingArguments; ++i) {
                argSelectors.add(Selector.serializer.deserialize(in, version, metadata));
            }
            return this.newFunctionSelector(function, argSelectors);
        }

        protected abstract Selector newFunctionSelector(Function var1, List<Selector> var2);
    }
}

