/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.nmoncho.shaded.com.google.common.collect.AbstractIterator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.Restrictions;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.restrictions.SingleRestriction;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

final class RestrictionSet
implements Restrictions,
Iterable<SingleRestriction> {
    private static final Comparator<ColumnMetadata> COLUMN_DEFINITION_COMPARATOR = new Comparator<ColumnMetadata>(){

        @Override
        public int compare(ColumnMetadata column, ColumnMetadata otherColumn) {
            int value = Integer.compare(column.position(), otherColumn.position());
            return value != 0 ? value : column.name.bytes.compareTo(otherColumn.name.bytes);
        }
    };
    private static final TreeMap<ColumnMetadata, SingleRestriction> EMPTY = new TreeMap(COLUMN_DEFINITION_COMPARATOR);
    protected final TreeMap<ColumnMetadata, SingleRestriction> restrictions;
    private final boolean hasMultiColumnRestrictions;
    private final boolean hasIn;
    private final boolean hasContains;
    private final boolean hasSlice;
    private final boolean hasOnlyEqualityRestrictions;

    public RestrictionSet() {
        this(EMPTY, false, false, false, false, true);
    }

    private RestrictionSet(TreeMap<ColumnMetadata, SingleRestriction> restrictions, boolean hasMultiColumnRestrictions, boolean hasIn, boolean hasContains, boolean hasSlice, boolean hasOnlyEqualityRestrictions) {
        this.restrictions = restrictions;
        this.hasMultiColumnRestrictions = hasMultiColumnRestrictions;
        this.hasIn = hasIn;
        this.hasContains = hasContains;
        this.hasSlice = hasSlice;
        this.hasOnlyEqualityRestrictions = hasOnlyEqualityRestrictions;
    }

    @Override
    public void addRowFilterTo(RowFilter filter, IndexRegistry indexRegistry, QueryOptions options) throws InvalidRequestException {
        for (Restriction restriction : this.restrictions.values()) {
            restriction.addRowFilterTo(filter, indexRegistry, options);
        }
    }

    @Override
    public List<ColumnMetadata> getColumnDefs() {
        return new ArrayList<ColumnMetadata>(this.restrictions.keySet());
    }

    @Override
    public void addFunctionsTo(List<Function> functions) {
        for (Restriction restriction : this) {
            restriction.addFunctionsTo(functions);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.restrictions.isEmpty();
    }

    @Override
    public int size() {
        return this.restrictions.size();
    }

    public boolean hasRestrictionFor(ColumnMetadata.Kind kind) {
        for (ColumnMetadata column : this.restrictions.keySet()) {
            if (column.kind != kind) continue;
            return true;
        }
        return false;
    }

    public RestrictionSet addRestriction(SingleRestriction restriction) {
        TreeMap<ColumnMetadata, SingleRestriction> newRestricitons = new TreeMap<ColumnMetadata, SingleRestriction>((SortedMap<ColumnMetadata, SingleRestriction>)this.restrictions);
        boolean newHasIn = this.hasIn || restriction.isIN();
        boolean newHasContains = this.hasContains || restriction.isContains();
        boolean newHasSlice = this.hasSlice || restriction.isSlice();
        boolean newHasOnlyEqualityRestrictions = this.hasOnlyEqualityRestrictions && (restriction.isEQ() || restriction.isIN());
        return new RestrictionSet(this.mergeRestrictions(newRestricitons, restriction), this.hasMultiColumnRestrictions || restriction.isMultiColumn(), newHasIn, newHasContains, newHasSlice, newHasOnlyEqualityRestrictions);
    }

    private TreeMap<ColumnMetadata, SingleRestriction> mergeRestrictions(TreeMap<ColumnMetadata, SingleRestriction> restrictions, SingleRestriction restriction) {
        List<ColumnMetadata> columnDefs = restriction.getColumnDefs();
        Set<SingleRestriction> existingRestrictions = this.getRestrictions(columnDefs);
        if (existingRestrictions.isEmpty()) {
            for (ColumnMetadata columnDef : columnDefs) {
                restrictions.put(columnDef, restriction);
            }
        } else {
            for (SingleRestriction existing : existingRestrictions) {
                SingleRestriction newRestriction = RestrictionSet.mergeRestrictions(existing, restriction);
                for (ColumnMetadata columnDef : columnDefs) {
                    restrictions.put(columnDef, newRestriction);
                }
            }
        }
        return restrictions;
    }

    @Override
    public Set<Restriction> getRestrictions(ColumnMetadata columnDef) {
        Restriction existing = this.restrictions.get(columnDef);
        return existing == null ? Collections.emptySet() : Collections.singleton(existing);
    }

    private Set<SingleRestriction> getRestrictions(Collection<ColumnMetadata> columnDefs) {
        HashSet<SingleRestriction> set = new HashSet<SingleRestriction>();
        for (ColumnMetadata columnDef : columnDefs) {
            SingleRestriction existing = this.restrictions.get(columnDef);
            if (existing == null) continue;
            set.add(existing);
        }
        return set;
    }

    @Override
    public final boolean hasSupportingIndex(IndexRegistry indexRegistry) {
        for (Restriction restriction : this.restrictions.values()) {
            if (!restriction.hasSupportingIndex(indexRegistry)) continue;
            return true;
        }
        return false;
    }

    ColumnMetadata nextColumn(ColumnMetadata columnDef) {
        return (ColumnMetadata)this.restrictions.tailMap(columnDef, false).firstKey();
    }

    @Override
    public ColumnMetadata getFirstColumn() {
        return this.isEmpty() ? null : this.restrictions.firstKey();
    }

    @Override
    public ColumnMetadata getLastColumn() {
        return this.isEmpty() ? null : this.restrictions.lastKey();
    }

    SingleRestriction lastRestriction() {
        return this.isEmpty() ? null : this.restrictions.lastEntry().getValue();
    }

    private static SingleRestriction mergeRestrictions(SingleRestriction restriction, SingleRestriction otherRestriction) {
        return restriction == null ? otherRestriction : restriction.mergeWith(otherRestriction);
    }

    public final boolean hasMultipleContains() {
        int numberOfContains = 0;
        for (SingleRestriction restriction : this.restrictions.values()) {
            if (!restriction.isContains()) continue;
            SingleColumnRestriction.ContainsRestriction contains = (SingleColumnRestriction.ContainsRestriction)restriction;
            numberOfContains += contains.numberOfValues() + contains.numberOfKeys() + contains.numberOfEntries();
        }
        return numberOfContains > 1;
    }

    @Override
    public Iterator<SingleRestriction> iterator() {
        DistinctIterator iterator = this.restrictions.values().iterator();
        return this.hasMultiColumnRestrictions ? new DistinctIterator(iterator) : iterator;
    }

    @Override
    public final boolean hasIN() {
        return this.hasIn;
    }

    @Override
    public boolean hasContains() {
        return this.hasContains;
    }

    @Override
    public final boolean hasSlice() {
        return this.hasSlice;
    }

    @Override
    public final boolean hasOnlyEqualityRestrictions() {
        return this.hasOnlyEqualityRestrictions;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static final class DistinctIterator<E>
    extends AbstractIterator<E> {
        private final Iterator<E> iterator;
        private E previous;

        public DistinctIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        protected E computeNext() {
            while (this.iterator.hasNext()) {
                E next = this.iterator.next();
                if (next.equals(this.previous)) continue;
                this.previous = next;
                return next;
            }
            return (E)this.endOfData();
        }
    }
}

