/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.base.Objects;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.commons.lang3.text.StrBuilder;

public abstract class AbstractFunction
implements Function {
    protected final FunctionName name;
    protected final List<AbstractType<?>> argTypes;
    protected final AbstractType<?> returnType;

    protected AbstractFunction(FunctionName name, List<AbstractType<?>> argTypes, AbstractType<?> returnType) {
        this.name = name;
        this.argTypes = argTypes;
        this.returnType = returnType;
    }

    @Override
    public FunctionName name() {
        return this.name;
    }

    @Override
    public List<AbstractType<?>> argTypes() {
        return this.argTypes;
    }

    @Override
    public AbstractType<?> returnType() {
        return this.returnType;
    }

    public List<String> argumentsList() {
        return this.argTypes().stream().map(AbstractType::asCQL3Type).map(Object::toString).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractFunction)) {
            return false;
        }
        AbstractFunction that = (AbstractFunction)o;
        return Objects.equal(this.name, that.name) && Objects.equal(this.argTypes, that.argTypes) && Objects.equal(this.returnType, that.returnType);
    }

    @Override
    public void addFunctionsTo(List<Function> functions) {
        functions.add(this);
    }

    @Override
    public boolean referencesUserType(ByteBuffer name) {
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.argTypes, this.returnType);
    }

    @Override
    public final AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
        AbstractType<?> returnType = this.returnType();
        if (receiver.type.isFreezable() && !receiver.type.isMultiCell()) {
            returnType = returnType.freeze();
        }
        if (receiver.type.equals(returnType)) {
            return AssignmentTestable.TestResult.EXACT_MATCH;
        }
        if (receiver.type.isValueCompatibleWith(returnType)) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }
        return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
    }

    public String toString() {
        return new CqlBuilder().append(this.name).append(" : (").appendWithSeparators(this.argTypes, (b, t) -> b.append(this.toCqlString((AbstractType<?>)t)), ", ").append(") -> ").append(this.returnType).toString();
    }

    public String elementKeyspace() {
        return this.name.keyspace;
    }

    public String elementName() {
        return new CqlBuilder().append(this.name.name).append('(').appendWithSeparators(this.argTypes, (b, t) -> b.append(this.toCqlString((AbstractType<?>)t)), ", ").append(')').toString();
    }

    protected String toCqlString(AbstractType<?> type) {
        return type.isTuple() ? ((CQL3Type.Tuple)type.asCQL3Type()).toString(false) : type.asCQL3Type().toString();
    }

    @Override
    public String columnName(List<String> columnNames) {
        return new StrBuilder(this.name().toString()).append('(').appendWithSeparators(columnNames, ", ").append(')').toString();
    }
}

